/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.reference;

import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.util.SpringContext;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class NotEqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final Object referenceKey;
    private final T value;

    public NotEqualPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
        RediSearchIndexer indexer = SpringContext.getBean(RediSearchIndexer.class);
        String keyspace = indexer.getKeyspaceForEntityClass(field.getTargetClass());
        this.referenceKey = QueryUtils.escape(ObjectUtils.getKey(keyspace, ObjectUtils.getIdFieldForEntity(value)));
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        Class<?> cls = this.referenceKey.getClass();
        if (cls == Integer.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{Values.eq((int)Integer.parseInt(this.referenceKey.toString()))})});
        }
        if (cls == Long.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{Values.eq((double)Long.parseLong(this.referenceKey.toString()))})});
        }
        if (cls == Double.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{Values.eq((double)Double.parseDouble(this.referenceKey.toString()))})});
        }
        if (CharSequence.class.isAssignableFrom(cls)) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{Values.value((String)("{" + this.referenceKey + "}"))})});
        }
        return root;
    }
}

