/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class ReferenceDeserializer
implements JsonDeserializer<Object> {
    private static final Log logger = LogFactory.getLog(ReferenceDeserializer.class);
    private final Class<?> type;
    private final ObjectConstructor<?> objectConstructor;
    private final JSONOperations<String> ops;
    private final Gson gson = new Gson();
    private final Cache referenceCache;
    private final List<String> cachedReferenceClasses;

    public ReferenceDeserializer(Field field, JSONOperations<?> ops, RedisOMProperties properties, CacheManager cacheManager) {
        Optional<Class<?>> collectionType;
        this.ops = ops;
        HashMap instanceCreators = new HashMap();
        ConstructorConstructor constructorConstructor = new ConstructorConstructor(instanceCreators, true, Collections.emptyList());
        this.type = ObjectUtils.isCollection(field) ? ((collectionType = ObjectUtils.getCollectionElementClass(field)).isPresent() ? collectionType.get() : field.getType()) : field.getType();
        this.objectConstructor = constructorConstructor.get(TypeToken.get(this.type));
        RedisOMProperties.References referencesConfig = properties.getReferences();
        this.referenceCache = cacheManager.getCache(referencesConfig.getCacheName());
        this.cachedReferenceClasses = referencesConfig.getCachedReferenceClasses();
    }

    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object reference = null;
        if (json.isJsonPrimitive()) {
            String referenceKey = ObjectUtils.unQuote(json.toString());
            String referenceJSON = null;
            if (this.shouldCache(this.type)) {
                referenceJSON = (String)this.referenceCache.get((Object)referenceKey, String.class);
            }
            if (referenceJSON == null) {
                referenceJSON = this.ops.get(referenceKey);
                if (this.referenceCache != null && this.shouldCache(this.type)) {
                    this.referenceCache.put((Object)referenceKey, (Object)referenceJSON);
                }
            }
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(referenceJSON, JsonObject.class);
            reference = this.deserializeEntity(jsonObject, context);
        } else if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            reference = this.deserializeEntity(jsonObject, context);
        } else if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            reference = this.instantiateCollection(typeOfT);
            String[] keys = (String[])jsonArray.asList().stream().filter(JsonElement::isJsonPrimitive).map(jsonElement -> ObjectUtils.unQuote(jsonElement.toString())).toArray(String[]::new);
            if (keys.length > 0) {
                List<String> values;
                if (this.shouldCache(this.type)) {
                    values = Arrays.stream(keys).map(key -> (String)this.referenceCache.get(key, String.class)).filter(Objects::nonNull).collect(Collectors.toList());
                    if (values.size() < keys.length) {
                        String[] missingKeys = (String[])Arrays.stream(keys).filter(key -> this.referenceCache.get(key, String.class) == null).toArray(String[]::new);
                        List<String> fetchedValues = this.ops.mget((String[])missingKeys);
                        for (int i = 0; i < missingKeys.length; ++i) {
                            this.referenceCache.put((Object)missingKeys[i], (Object)fetchedValues.get(i));
                        }
                        values.addAll(fetchedValues);
                    }
                } else {
                    values = this.ops.mget((String[])keys);
                }
                ((Collection)reference).addAll(values.stream().map(raw -> (JsonObject)this.gson.fromJson(raw, JsonObject.class)).map(jo -> this.deserializeEntity((JsonObject)jo, context)).toList());
            }
        }
        return reference;
    }

    public Collection<?> instantiateCollection(Type type) {
        Class rawType = (Class)((ParameterizedType)type).getRawType();
        if (rawType.isInterface()) {
            if (List.class.isAssignableFrom(rawType)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new HashSet();
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new LinkedList();
            }
            throw new IllegalArgumentException("Unsupported interface: " + rawType);
        }
        try {
            return (Collection)rawType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type not instantiatable: " + rawType);
        }
    }

    private Object deserializeEntity(JsonObject jsonObject, JsonDeserializationContext context) {
        Object reference = this.objectConstructor.construct();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            try {
                Field field = this.type.getDeclaredField(key);
                Method setter = ObjectUtils.getSetterForField(this.type, field);
                Class<?> fieldType = field.getType();
                Object elementValue = context.deserialize(value, fieldType);
                if (setter != null) {
                    setter.invoke(reference, elementValue);
                    continue;
                }
                field.setAccessible(true);
                field.set(reference, elementValue);
            }
            catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
                logger.error((Object)String.format("Error while deserializing reference of type %s", this.type), (Throwable)e);
            }
        }
        return reference;
    }

    private boolean shouldCache(Class<?> referenceClass) {
        return this.cachedReferenceClasses.contains(referenceClass.getName());
    }
}

