/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.client;

import com.google.gson.GsonBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.ClientSetInfoConfig;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.JedisSentineled;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.bloom.commands.BloomFilterCommands;
import redis.clients.jedis.bloom.commands.CountMinSketchCommands;
import redis.clients.jedis.bloom.commands.CuckooFilterCommands;
import redis.clients.jedis.bloom.commands.TopKFilterCommands;
import redis.clients.jedis.json.commands.RedisJsonCommands;
import redis.clients.jedis.search.RediSearchCommands;

public class RedisModulesClient {
    private static final Log logger = LogFactory.getLog(RedisModulesClient.class);
    private final GsonBuilder builder;
    private final UnifiedJedis unifiedJedis;
    private final JedisConnectionFactory jedisConnectionFactory;

    public RedisModulesClient(JedisConnectionFactory jedisConnectionFactory, GsonBuilder builder) {
        this.jedisConnectionFactory = jedisConnectionFactory;
        this.builder = builder;
        this.unifiedJedis = this.getUnifiedJedis();
    }

    private static HostAndPort apply(RedisNode node) {
        return new HostAndPort(node.getHost(), node.getPort() != null ? node.getPort() : 0);
    }

    public RedisJsonCommands clientForJSON() {
        return this.unifiedJedis;
    }

    public RediSearchCommands clientForSearch() {
        return this.unifiedJedis;
    }

    public BloomFilterCommands clientForBloom() {
        return this.unifiedJedis;
    }

    public CountMinSketchCommands clientForCMS() {
        return this.unifiedJedis;
    }

    public CuckooFilterCommands clientForCuckoo() {
        return this.unifiedJedis;
    }

    public TopKFilterCommands clientForTopK() {
        return this.unifiedJedis;
    }

    private UnifiedJedis getUnifiedJedis() {
        RedisSentinelConfiguration sentinelConfiguration = this.jedisConnectionFactory.getSentinelConfiguration();
        if (sentinelConfiguration != null) {
            NamedNode masterNode = sentinelConfiguration.getMaster();
            String master = masterNode != null ? masterNode.getName() : "mymaster";
            Set sentinels = sentinelConfiguration.getSentinels().stream().map(RedisModulesClient::apply).collect(Collectors.toSet());
            RedisPassword password = sentinelConfiguration.getPassword();
            RedisPassword sentinelPassword = sentinelConfiguration.getSentinelPassword();
            String username = sentinelConfiguration.getUsername();
            JedisClientConfig masterClientConfig = this.createClientConfig(this.jedisConnectionFactory.getDatabase(), username, password, this.jedisConnectionFactory.getClientConfiguration());
            JedisClientConfig sentinelClientConfig = this.createClientConfig(this.jedisConnectionFactory.getDatabase(), username, sentinelPassword, this.jedisConnectionFactory.getClientConfiguration());
            logger.info((Object)("Modules Client connecting in Sentinel mode, master: " + master));
            return new JedisSentineled(master, masterClientConfig, sentinels, sentinelClientConfig);
        }
        JedisClientConfiguration cc = this.jedisConnectionFactory.getClientConfiguration();
        HostAndPort hostAndPort = new HostAndPort(this.jedisConnectionFactory.getHostName(), this.jedisConnectionFactory.getPort());
        RedisStandaloneConfiguration standaloneConfig = this.jedisConnectionFactory.getStandaloneConfiguration();
        String username = standaloneConfig != null ? standaloneConfig.getUsername() : null;
        RedisPassword password = standaloneConfig != null ? standaloneConfig.getPassword() : null;
        JedisClientConfig jedisClientConfig = this.createClientConfig(this.jedisConnectionFactory.getDatabase(), username, password, cc);
        logger.info((Object)"Modules Client connecting with standalone pool");
        return new JedisPooled(Objects.requireNonNull(this.jedisConnectionFactory.getPoolConfig()), hostAndPort, jedisClientConfig);
    }

    public Optional<Jedis> getJedis() {
        Object nativeConnection = this.jedisConnectionFactory.getConnection().getNativeConnection();
        if (nativeConnection instanceof Jedis) {
            Jedis jedis = (Jedis)nativeConnection;
            return Optional.of(jedis);
        }
        return Optional.empty();
    }

    public Optional<JedisCluster> getJedisCluster() {
        Object nativeConnection = this.jedisConnectionFactory.getConnection().getNativeConnection();
        if (nativeConnection instanceof JedisCluster) {
            JedisCluster jedisCluster = (JedisCluster)nativeConnection;
            return Optional.of(jedisCluster);
        }
        return Optional.empty();
    }

    public GsonBuilder gsonBuilder() {
        return this.builder;
    }

    private JedisClientConfig createClientConfig(int database, @Nullable String username, RedisPassword password, JedisClientConfiguration clientConfiguration) {
        DefaultJedisClientConfig.Builder jedisConfigBuilder = DefaultJedisClientConfig.builder();
        clientConfiguration.getClientName().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)jedisConfigBuilder).clientName(arg_0));
        jedisConfigBuilder.connectionTimeoutMillis(Math.toIntExact(clientConfiguration.getConnectTimeout().toMillis()));
        jedisConfigBuilder.socketTimeoutMillis(Math.toIntExact(clientConfiguration.getReadTimeout().toMillis()));
        jedisConfigBuilder.database(database);
        jedisConfigBuilder.clientSetInfoConfig(ClientSetInfoConfig.withLibNameSuffix((String)"redis-om-spring_v0.9.6"));
        if (!ObjectUtils.isEmpty((Object)username)) {
            jedisConfigBuilder.user(username);
        }
        password.toOptional().map(String::new).ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)jedisConfigBuilder).password(arg_0));
        if (clientConfiguration.isUseSsl()) {
            jedisConfigBuilder.ssl(true);
            clientConfiguration.getSslSocketFactory().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)jedisConfigBuilder).sslSocketFactory(arg_0));
            clientConfiguration.getHostnameVerifier().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)jedisConfigBuilder).hostnameVerifier(arg_0));
            clientConfiguration.getSslParameters().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)jedisConfigBuilder).sslParameters(arg_0));
        }
        return jedisConfigBuilder.build();
    }
}

