/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.google.gson.GsonBuilder;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.SearchStreamImpl;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.Optional;

public class EntityStreamImpl
implements EntityStream {
    private final RedisModulesOperations<String> modulesOperations;
    private final GsonBuilder gsonBuilder;
    private final RediSearchIndexer indexer;

    public EntityStreamImpl(RedisModulesOperations<?> rmo, GsonBuilder gsonBuilder, RediSearchIndexer indexer) {
        this.modulesOperations = rmo;
        this.gsonBuilder = gsonBuilder;
        this.indexer = indexer;
    }

    @Override
    public <E> SearchStream<E> of(Class<E> entityClass) {
        return new SearchStreamImpl<E>(entityClass, this.modulesOperations, this.gsonBuilder, this.indexer);
    }

    @Override
    public <E> SearchStream<E> of(Class<E> entityClass, String searchIndex, String idField) {
        Optional<Field> maybeIdField = ObjectUtils.getDeclaredFieldsTransitively(entityClass).stream().filter(f -> f.getName().equals("id")).findFirst();
        if (maybeIdField.isPresent()) {
            return new SearchStreamImpl<E>(entityClass, searchIndex, maybeIdField.get(), this.modulesOperations, this.gsonBuilder, this.indexer);
        }
        throw new IllegalArgumentException(entityClass.getName() + " does not appear to have an ID field");
    }
}

