/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.tuple.impl;

import com.redis.om.spring.tuple.GenericTuple;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class BasicAbstractTuple<T extends GenericTuple<R>, R>
implements GenericTuple<R> {
    protected final Object[] values;
    protected final String[] labels;
    protected final Class<? extends T> baseClass;

    BasicAbstractTuple(Class<? extends T> baseClass, String[] labels, Object ... values) {
        Objects.requireNonNull(values);
        this.baseClass = Objects.requireNonNull(baseClass);
        this.labels = labels;
        if (!this.isNullable()) {
            for (Object v : values) {
                Objects.requireNonNull(v, () -> this.getClass().getName() + " cannot hold null values.");
            }
        }
        this.values = values;
    }

    protected abstract boolean isNullable();

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.baseClass.isInstance(obj)) {
            return false;
        }
        BasicAbstractTuple tuple = (BasicAbstractTuple)obj;
        return Arrays.equals(this.values, tuple.values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + Stream.of(this.values).map(Objects::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    public <C> Stream<C> streamOf(Class<C> clazz) {
        Objects.requireNonNull(clazz);
        return Stream.of(this.values).filter(clazz::isInstance).map(clazz::cast);
    }

    @Override
    public Map<String, Object> labelledMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < Math.min(this.labels.length, this.values.length); ++i) {
            String label = StringUtils.removeStart((String)this.labels[i], (String)"$.");
            Object value = this.values[i];
            result.put(label, value);
        }
        return Collections.unmodifiableMap(result);
    }
}

