/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.vectorize;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.translator.ImageFeatureExtractor;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import com.azure.ai.openai.OpenAIClient;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.EmbeddingProvider;
import com.redis.om.spring.annotations.EmbeddingType;
import com.redis.om.spring.annotations.Vectorize;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingModel;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingOptions;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingModel;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingModel;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.ollama.OllamaEmbeddingModel;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.ai.ollama.api.OllamaOptions;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.vertexai.palm2.VertexAiPaLm2EmbeddingModel;
import org.springframework.ai.vertexai.palm2.api.VertexAiPaLm2Api;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.client.RestClient;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class DefaultEmbedder
implements Embedder {
    private static final Log logger = LogFactory.getLog(DefaultEmbedder.class);
    public final Pipeline imagePipeline;
    public final HuggingFaceTokenizer sentenceTokenizer;
    private final ZooModel<Image, byte[]> imageEmbeddingModel;
    private final ZooModel<Image, float[]> faceEmbeddingModel;
    private final ImageFactory imageFactory;
    private final ApplicationContext applicationContext;
    private final ImageFeatureExtractor imageFeatureExtractor;
    private final OpenAiEmbeddingModel defaultOpenAITextVectorizer;
    private final OllamaEmbeddingModel defaultOllamaEmbeddingModel;
    private final RedisOMProperties properties;
    private final OllamaApi ollamaApi;
    private final OpenAIClient azureOpenAIClient;
    private final VertexAiPaLm2EmbeddingModel vertexAiPaLm2EmbeddingModel;
    private final BedrockCohereEmbeddingModel bedrockCohereEmbeddingModel;
    private final BedrockTitanEmbeddingModel bedrockTitanEmbeddingModel;

    public DefaultEmbedder(ApplicationContext applicationContext, ZooModel<Image, byte[]> imageEmbeddingModel, ZooModel<Image, float[]> faceEmbeddingModel, ImageFactory imageFactory, Pipeline imagePipeline, HuggingFaceTokenizer sentenceTokenizer, OpenAiEmbeddingModel openAITextVectorizer, OpenAIClient azureOpenAIClient, VertexAiPaLm2EmbeddingModel vertexAiPaLm2EmbeddingModel, BedrockCohereEmbeddingModel bedrockCohereEmbeddingModel, BedrockTitanEmbeddingModel bedrockTitanEmbeddingModel, RedisOMProperties properties) {
        this.applicationContext = applicationContext;
        this.imageEmbeddingModel = imageEmbeddingModel;
        this.faceEmbeddingModel = faceEmbeddingModel;
        this.imageFactory = imageFactory;
        this.imagePipeline = imagePipeline;
        this.sentenceTokenizer = sentenceTokenizer;
        this.imageFeatureExtractor = ((ImageFeatureExtractor.Builder)ImageFeatureExtractor.builder().setPipeline(imagePipeline)).build();
        this.defaultOpenAITextVectorizer = openAITextVectorizer;
        this.azureOpenAIClient = azureOpenAIClient;
        this.vertexAiPaLm2EmbeddingModel = vertexAiPaLm2EmbeddingModel;
        this.bedrockCohereEmbeddingModel = bedrockCohereEmbeddingModel;
        this.bedrockTitanEmbeddingModel = bedrockTitanEmbeddingModel;
        this.properties = properties;
        this.ollamaApi = new OllamaApi(properties.getOllama().getBaseUrl());
        this.defaultOllamaEmbeddingModel = new OllamaEmbeddingModel(this.ollamaApi, new OllamaOptions().withModel(OllamaOptions.DEFAULT_MODEL));
    }

    private byte[] getImageEmbeddingsAsByteArrayFor(InputStream is) {
        try {
            Image img = this.imageFactory.fromInputStream(is);
            Predictor predictor = this.imageEmbeddingModel.newPredictor((Translator)this.imageFeatureExtractor);
            return (byte[])predictor.predict((Object)img);
        }
        catch (TranslateException | IOException e) {
            logger.warn((Object)"Error generating image embedding", e);
            return new byte[0];
        }
    }

    private float[] getImageEmbeddingsAsFloatArrayFor(InputStream is) {
        return ObjectUtils.byteArrayToFloatArray(this.getImageEmbeddingsAsByteArrayFor(is));
    }

    private byte[] getFacialImageEmbeddingsAsByteArrayFor(InputStream is) throws IOException, TranslateException {
        return ObjectUtils.floatArrayToByteArray(this.getFacialImageEmbeddingsAsFloatArrayFor(is));
    }

    private float[] getFacialImageEmbeddingsAsFloatArrayFor(InputStream is) throws IOException, TranslateException {
        try (Predictor predictor = this.faceEmbeddingModel.newPredictor();){
            Image img = this.imageFactory.fromInputStream(is);
            float[] fArray = (float[])predictor.predict((Object)img);
            return fArray;
        }
    }

    private List<byte[]> getSentenceEmbeddingsAsByteArrayFor(List<String> texts) {
        Encoding[] encodings = this.sentenceTokenizer.batchEncode(texts);
        return Arrays.stream(encodings).map(e -> ObjectUtils.longArrayToByteArray(e.getIds())).toList();
    }

    private List<float[]> getSentenceEmbeddingAsFloatArrayFor(List<String> texts) {
        Encoding[] encodings = this.sentenceTokenizer.batchEncode(texts);
        return Arrays.stream(encodings).map(e -> ObjectUtils.longArrayToFloatArray(e.getIds())).toList();
    }

    private byte[] getSentenceEmbeddingsAsByteArrayFor(String text) {
        Encoding encoding = this.sentenceTokenizer.encode(text);
        return ObjectUtils.longArrayToByteArray(encoding.getIds());
    }

    private float[] getSentenceEmbeddingAsFloatArrayFor(String text) {
        Encoding encoding = this.sentenceTokenizer.encode(text);
        return ObjectUtils.longArrayToFloatArray(encoding.getIds());
    }

    private List<byte[]> getEmbeddingsAsByteArrayFor(List<String> texts, EmbeddingModel model) {
        EmbeddingResponse embeddingResponse = model.embedForResponse(texts);
        List embeddings = embeddingResponse.getResults();
        return embeddings.stream().map(e -> ObjectUtils.floatArrayToByteArray(e.getOutput())).toList();
    }

    private List<float[]> getEmbeddingAsFloatArrayFor(List<String> texts, EmbeddingModel model) {
        EmbeddingResponse embeddingResponse = model.embedForResponse(texts);
        List embeddings = embeddingResponse.getResults();
        return embeddings.stream().map(Embedding::getOutput).toList();
    }

    private byte[] getEmbeddingsAsByteArrayFor(String text, EmbeddingModel model) {
        EmbeddingResponse embeddingResponse = model.embedForResponse(List.of(text));
        Embedding embedding = embeddingResponse.getResult();
        return ObjectUtils.floatArrayToByteArray(embedding.getOutput());
    }

    private float[] getEmbeddingAsFloatArrayFor(String text, EmbeddingModel model) {
        EmbeddingResponse embeddingResponse = model.embedForResponse(List.of(text));
        Embedding embedding = embeddingResponse.getResult();
        return embedding.getOutput();
    }

    @Override
    public void processEntity(Object item) {
        if (!this.isReady()) {
            return;
        }
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Vectorize.class);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> this.lambda$processEntity$3((PropertyAccessor)accessor, item, arg_0));
        }
    }

    private void processImageEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        Resource resource = this.applicationContext.getResource(fieldValue.toString());
        try {
            if (isDocument) {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getImageEmbeddingsAsFloatArrayFor(resource.getInputStream()));
            } else {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getImageEmbeddingsAsByteArrayFor(resource.getInputStream()));
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error generating image embedding", (Throwable)e);
        }
    }

    private void processFaceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        Resource resource = this.applicationContext.getResource(fieldValue.toString());
        try {
            if (isDocument) {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getFacialImageEmbeddingsAsFloatArrayFor(resource.getInputStream()));
            } else {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getFacialImageEmbeddingsAsByteArrayFor(resource.getInputStream()));
            }
        }
        catch (TranslateException | IOException e) {
            logger.warn((Object)"Error generating facial image embedding", e);
        }
    }

    private void processSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        switch (vectorize.provider()) {
            case DJL: {
                this.processDjlSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                break;
            }
            case OPENAI: {
                this.processOpenAiSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                break;
            }
            case OLLAMA: {
                this.processOllamaSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                break;
            }
            case AZURE_OPENAI: {
                this.processAzureOpenAiSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                break;
            }
            case VERTEX_AI: {
                this.processVertexAiSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                break;
            }
            case AMAZON_BEDROCK_COHERE: {
                this.processBedrockCohereSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                break;
            }
            case AMAZON_BEDROCK_TITAN: {
                this.processBedrockTitanSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
            }
        }
    }

    private void processDjlSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getSentenceEmbeddingAsFloatArrayFor(fieldValue.toString()));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getSentenceEmbeddingsAsByteArrayFor(fieldValue.toString()));
        }
    }

    private void processOpenAiSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        OpenAiEmbeddingModel model = this.getOpenAiEmbeddingModel(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        }
    }

    private void processOllamaSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        OllamaEmbeddingModel model = this.getOllamaEmbeddingModel(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        }
    }

    private void processAzureOpenAiSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        AzureOpenAiEmbeddingModel model = this.getAzureOpenAiEmbeddingModel(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        }
    }

    private void processVertexAiSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        VertexAiPaLm2EmbeddingModel model = this.getVertexAiPaLm2EmbeddingModel(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        }
    }

    private void processBedrockCohereSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        BedrockCohereEmbeddingModel model = this.getBedrockCohereEmbeddingModel(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        }
    }

    private void processBedrockTitanSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        BedrockTitanEmbeddingModel model = this.getBedrockTitanEmbeddingModel(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), (EmbeddingModel)model));
        }
    }

    private OpenAiEmbeddingModel getOpenAiEmbeddingModel(Vectorize vectorize) {
        if (vectorize.openAiEmbeddingModel() != OpenAiApi.EmbeddingModel.TEXT_EMBEDDING_ADA_002) {
            OpenAiApi openAiApi = new OpenAiApi(this.properties.getOpenAi().getApiKey());
            return new OpenAiEmbeddingModel(openAiApi, MetadataMode.EMBED, OpenAiEmbeddingOptions.builder().withModel(vectorize.openAiEmbeddingModel().getValue()).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
        }
        return this.defaultOpenAITextVectorizer;
    }

    private OllamaEmbeddingModel getOllamaEmbeddingModel(Vectorize vectorize) {
        if (!vectorize.ollamaEmbeddingModel().id().equals(OllamaOptions.DEFAULT_MODEL)) {
            return new OllamaEmbeddingModel(this.ollamaApi, new OllamaOptions().withModel(vectorize.ollamaEmbeddingModel().id()));
        }
        return this.defaultOllamaEmbeddingModel;
    }

    private AzureOpenAiEmbeddingModel getAzureOpenAiEmbeddingModel(Vectorize vectorize) {
        AzureOpenAiEmbeddingOptions options = AzureOpenAiEmbeddingOptions.builder().withDeploymentName(vectorize.azureOpenAiDeploymentName()).build();
        return new AzureOpenAiEmbeddingModel(this.azureOpenAIClient, MetadataMode.EMBED, options);
    }

    private VertexAiPaLm2EmbeddingModel getVertexAiPaLm2EmbeddingModel(Vectorize vectorize) {
        if (!vectorize.vertexAiPaLm2ApiModel().equals("embedding-gecko-001")) {
            VertexAiPaLm2Api vertexAiApi = new VertexAiPaLm2Api(this.properties.getVertexAi().getEndPoint(), this.properties.getVertexAi().getApiKey(), "chat-bison-001", vectorize.vertexAiPaLm2ApiModel(), RestClient.builder());
            return new VertexAiPaLm2EmbeddingModel(vertexAiApi);
        }
        return this.vertexAiPaLm2EmbeddingModel;
    }

    private BedrockCohereEmbeddingModel getBedrockCohereEmbeddingModel(Vectorize vectorize) {
        if (!vectorize.cohereEmbeddingModel().equals((Object)CohereEmbeddingBedrockApi.CohereEmbeddingModel.COHERE_EMBED_MULTILINGUAL_V1)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.properties.getBedrockCohere().getAccessKey(), (String)this.properties.getBedrockCohere().getSecretKey());
            CohereEmbeddingBedrockApi cohereEmbeddingApi = new CohereEmbeddingBedrockApi(vectorize.cohereEmbeddingModel().id(), (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials), this.properties.getBedrockCohere().getRegion(), ModelOptionsUtils.OBJECT_MAPPER);
            return new BedrockCohereEmbeddingModel(cohereEmbeddingApi);
        }
        return this.bedrockCohereEmbeddingModel;
    }

    private BedrockTitanEmbeddingModel getBedrockTitanEmbeddingModel(Vectorize vectorize) {
        if (!vectorize.titanEmbeddingModel().equals((Object)TitanEmbeddingBedrockApi.TitanEmbeddingModel.TITAN_EMBED_IMAGE_V1)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.properties.getBedrockCohere().getAccessKey(), (String)this.properties.getBedrockCohere().getSecretKey());
            TitanEmbeddingBedrockApi titanEmbeddingApi = new TitanEmbeddingBedrockApi(vectorize.cohereEmbeddingModel().id(), (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials), this.properties.getBedrockTitan().getRegion(), ModelOptionsUtils.OBJECT_MAPPER, Duration.ofMinutes(5L));
            return new BedrockTitanEmbeddingModel(titanEmbeddingApi);
        }
        return this.bedrockTitanEmbeddingModel;
    }

    @Override
    public boolean isReady() {
        return this.faceEmbeddingModel != null && this.sentenceTokenizer != null;
    }

    @Override
    public List<byte[]> getTextEmbeddingsAsBytes(List<String> texts, Field field) {
        if (field.isAnnotationPresent(Vectorize.class)) {
            Vectorize vectorize = field.getAnnotation(Vectorize.class);
            return vectorize.embeddingType() == EmbeddingType.SENTENCE ? this.getSentenceEmbeddingAsBytes(texts, vectorize) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<byte[]> getSentenceEmbeddingAsBytes(List<String> texts, Vectorize vectorize) {
        return switch (vectorize.provider()) {
            default -> throw new MatchException(null, null);
            case EmbeddingProvider.DJL -> this.getSentenceEmbeddingsAsByteArrayFor(texts);
            case EmbeddingProvider.OPENAI -> {
                OpenAiEmbeddingModel model = this.getOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.OLLAMA -> {
                OllamaEmbeddingModel model = this.getOllamaEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AZURE_OPENAI -> {
                AzureOpenAiEmbeddingModel model = this.getAzureOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.VERTEX_AI -> {
                VertexAiPaLm2EmbeddingModel model = this.getVertexAiPaLm2EmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_COHERE -> {
                BedrockCohereEmbeddingModel model = this.getBedrockCohereEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_TITAN -> {
                BedrockTitanEmbeddingModel model = this.getBedrockTitanEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
        };
    }

    private List<float[]> getSentenceEmbeddingAsFloats(List<String> texts, Vectorize vectorize) {
        return switch (vectorize.provider()) {
            default -> throw new MatchException(null, null);
            case EmbeddingProvider.DJL -> this.getSentenceEmbeddingAsFloatArrayFor(texts);
            case EmbeddingProvider.OPENAI -> {
                OpenAiEmbeddingModel model = this.getOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.OLLAMA -> {
                OllamaEmbeddingModel model = this.getOllamaEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AZURE_OPENAI -> {
                AzureOpenAiEmbeddingModel model = this.getAzureOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.VERTEX_AI -> {
                VertexAiPaLm2EmbeddingModel model = this.getVertexAiPaLm2EmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_COHERE -> {
                BedrockCohereEmbeddingModel model = this.getBedrockCohereEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_TITAN -> {
                BedrockTitanEmbeddingModel model = this.getBedrockTitanEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
        };
    }

    @Override
    public List<float[]> getTextEmbeddingsAsFloats(List<String> texts, Field field) {
        if (field.isAnnotationPresent(Vectorize.class)) {
            Vectorize vectorize = field.getAnnotation(Vectorize.class);
            return vectorize.embeddingType() == EmbeddingType.SENTENCE ? this.getSentenceEmbeddingAsFloats(texts, vectorize) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> getTextEmbeddingsAsBytes(List<String> texts, MetamodelField<?, ?> metamodelField) {
        return this.getTextEmbeddingsAsBytes(texts, metamodelField.getSearchFieldAccessor().getField());
    }

    @Override
    public List<float[]> getTextEmbeddingsAsFloats(List<String> texts, MetamodelField<?, ?> metamodelField) {
        return this.getTextEmbeddingsAsFloats(texts, metamodelField.getSearchFieldAccessor().getField());
    }

    private /* synthetic */ void lambda$processEntity$3(PropertyAccessor accessor, Object item, Field f) {
        Vectorize vectorize = f.getAnnotation(Vectorize.class);
        Object fieldValue = accessor.getPropertyValue(f.getName());
        boolean isDocument = item.getClass().isAnnotationPresent(Document.class);
        if (fieldValue != null) {
            switch (vectorize.embeddingType()) {
                case IMAGE: {
                    this.processImageEmbedding(accessor, vectorize, fieldValue, isDocument);
                    break;
                }
                case WORD: {
                    break;
                }
                case FACE: {
                    this.processFaceEmbedding(accessor, vectorize, fieldValue, isDocument);
                    break;
                }
                case SENTENCE: {
                    this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                }
            }
        }
    }
}

