/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.audit.EntityAuditor;
import com.redis.om.spring.convert.RedisOMCustomConversions;
import com.redis.om.spring.id.IdentifierFilter;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Version;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.SafeEncoder;

public class RedisJSONKeyValueAdapter
extends RedisKeyValueAdapter {
    private static final Log logger = LogFactory.getLog(RedisJSONKeyValueAdapter.class);
    private final JSONOperations<?> redisJSONOperations;
    private final RedisOperations<?, ?> redisOperations;
    private final RedisMappingContext mappingContext;
    private final RedisModulesOperations<String> modulesOperations;
    private final RediSearchIndexer indexer;
    private final GsonBuilder gsonBuilder;
    private final EntityAuditor auditor;
    private final Embedder embedder;
    private final RedisOMProperties redisOMProperties;

    public RedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RedisMappingContext mappingContext, RediSearchIndexer indexer, GsonBuilder gsonBuilder, Embedder embedder, RedisOMProperties redisOMProperties) {
        super(redisOps, mappingContext, (CustomConversions)new RedisOMCustomConversions());
        this.modulesOperations = rmo;
        this.redisJSONOperations = this.modulesOperations.opsForJSON();
        this.redisOperations = redisOps;
        this.mappingContext = mappingContext;
        this.indexer = indexer;
        this.auditor = new EntityAuditor(this.redisOperations);
        this.gsonBuilder = gsonBuilder;
        this.embedder = embedder;
        this.redisOMProperties = redisOMProperties;
    }

    public Object put(Object id, Object item, String keyspace) {
        logger.debug((Object)String.format("%s, %s, %s", id, item, keyspace));
        JSONOperations<?> ops = this.redisJSONOperations;
        String key = this.createKeyAsString(keyspace, id);
        this.processVersion(key, item);
        this.auditor.processEntity(key, item);
        this.embedder.processEntity(item);
        Optional<Long> maybeTtl = this.getTTLForEntity(item);
        ops.set(key, item);
        this.processReferences(key, item);
        this.redisOperations.execute(connection -> {
            maybeTtl.ifPresent(ttl -> {
                if (ttl > 0L) {
                    connection.keyCommands().expire(this.toBytes(key), ttl.longValue());
                }
            });
            return null;
        });
        return item;
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        String key = this.createKeyAsString(keyspace, id);
        return this.get(key, type);
    }

    @Nullable
    public <T> T get(String key, Class<T> type) {
        JSONOperations<?> ops = this.redisJSONOperations;
        return ops.get(key, type);
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type, long offset, int rows) {
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        Query query = new Query("*");
        offset = Math.max(0L, offset);
        int limit = rows;
        if (limit <= 0) {
            limit = this.redisOMProperties.getRepository().getQuery().getLimit();
        }
        query.limit(Integer.valueOf(Math.toIntExact(offset)), Integer.valueOf(limit));
        SearchResult searchResult = searchOps.search(query);
        Gson gson = this.gsonBuilder.create();
        return searchResult.getDocuments().stream().map(d -> gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), type)).toList();
    }

    public <T> List<String> getAllKeys(String keyspace, Class<T> type) {
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(type);
        String idField = maybeIdField.map(Field::getName).orElse("id");
        Query query = new Query("*");
        query.returnFields(new String[]{idField});
        SearchResult searchResult = searchOps.search(query);
        return searchResult.getDocuments().stream().map(Document::getId).toList();
    }

    public <T> T delete(Object id, String keyspace, Class<T> type) {
        JSONOperations<?> ops = this.redisJSONOperations;
        T entity = this.get(id, keyspace, type);
        if (entity != null) {
            String key = this.createKeyAsString(keyspace, id);
            ops.del(key, Path2.ROOT_PATH);
        }
        return entity;
    }

    public void deleteAllOf(String keyspace) {
        Class<?> type = this.indexer.getEntityClassForKeyspace(keyspace);
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        if (this.redisOMProperties.getRepository().isDropAndRecreateIndexOnDeleteAll()) {
            searchOps.dropIndexAndDocuments();
            this.indexer.createIndexFor(type);
        } else {
            boolean moreRecords = true;
            while (moreRecords) {
                Query query = new Query("*");
                query.limit(Integer.valueOf(0), Integer.valueOf(this.redisOMProperties.getRepository().getDeleteBatchSize()));
                query.setNoContent();
                SearchResult searchResult = searchOps.search(query);
                if (searchResult.getTotalResults() > 0L) {
                    List<byte[]> keys = searchResult.getDocuments().stream().map(k -> this.toBytes(k.getId())).toList();
                    this.redisOperations.executePipelined(connection -> {
                        RedisKeyCommands keyCommands = connection.keyCommands();
                        for (byte[] key : keys) {
                            keyCommands.del((byte[][])new byte[][]{key});
                        }
                        return null;
                    });
                    continue;
                }
                moreRecords = false;
            }
        }
    }

    public long count(String keyspace) {
        long count = 0L;
        String indexName = this.indexer.getIndexName(keyspace);
        SearchOperations<String> search = this.modulesOperations.opsForSearch(indexName);
        Query query = new Query("*");
        query.limit(Integer.valueOf(0), Integer.valueOf(0));
        SearchResult result = search.search(query);
        return result.getTotalResults();
    }

    public boolean contains(Object id, String keyspace) {
        Boolean exists = (Boolean)this.redisOperations.execute(connection -> connection.keyCommands().exists(this.toBytes(this.createKeyAsString(keyspace, id))));
        return exists != null && exists != false;
    }

    private void processReferences(String key, Object item) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Reference.class);
        if (!fields.isEmpty()) {
            JSONOperations<?> ops = this.redisJSONOperations;
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> this.lambda$processReferences$7((PropertyAccessor)accessor, ops, key, arg_0));
        }
    }

    private void processVersion(String key, Object item) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Version.class);
        if (fields.size() == 1) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(item);
            Field versionField = fields.get(0);
            String property = versionField.getName();
            if (versionField.getType() == Integer.class || ObjectUtils.isPrimitiveOfType(versionField.getType(), Integer.class) || versionField.getType() == Long.class || ObjectUtils.isPrimitiveOfType(versionField.getType(), Long.class)) {
                Number version = (Number)wrapper.getPropertyValue(property);
                Number dbVersion = this.getEntityVersion(key, property);
                if (dbVersion != null && version != null && dbVersion.longValue() != version.longValue()) {
                    throw new OptimisticLockingFailureException(String.format("Cannot insert/update entity %s with version %s as it already exists", item, version));
                }
                Long nextVersion = version == null ? 0L : version.longValue() + 1L;
                try {
                    wrapper.setPropertyValue(property, (Object)nextVersion);
                }
                catch (NotWritablePropertyException nwpe) {
                    versionField.setAccessible(true);
                    try {
                        versionField.set(item, nextVersion);
                    }
                    catch (IllegalAccessException iae) {
                        throw new RuntimeException(nwpe);
                    }
                }
            }
        }
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        Class<?> entityClassKey;
        Class<?> entityClass = entity.getClass();
        try {
            entityClassKey = ClassLoader.getSystemClassLoader().loadClass(entity.getClass().getTypeName());
        }
        catch (ClassNotFoundException e) {
            entityClassKey = entity.getClass();
        }
        KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
        if (keyspaceConfig.hasSettingsFor(entityClassKey)) {
            KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entityClassKey);
            if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                try {
                    Field fld = ReflectionUtils.findField(entityClass, (String)settings.getTimeToLivePropertyName());
                    if (fld != null) {
                        Method ttlGetter = ObjectUtils.getGetterForField(entityClass, fld);
                        long ttlPropertyValue = ((Number)ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity)).longValue();
                        TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                        if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                            return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                        }
                        return Optional.of(ttlPropertyValue);
                    }
                    return Optional.empty();
                }
                catch (IllegalArgumentException | SecurityException e) {
                    return Optional.empty();
                }
            }
            if (settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                return Optional.of(settings.getTimeToLive());
            }
        }
        return Optional.empty();
    }

    private Number getEntityVersion(String key, String versionProperty) {
        JSONOperations<?> ops = this.redisJSONOperations;
        Class type = new TypeToken<Long[]>(){}.getRawType();
        Long[] dbVersionArray = (Long[])ops.get(key, type, Path2.of((String)("$." + versionProperty)));
        return dbVersionArray != null ? dbVersionArray[0] : null;
    }

    public String createKeyAsString(String keyspace, Object id) {
        String format = keyspace.endsWith(":") ? "%s%s" : "%s:%s";
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(keyspace);
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            id = filter.filter(id.toString());
        }
        return String.format(format, keyspace, id);
    }

    private /* synthetic */ void lambda$processReferences$7(PropertyAccessor accessor, JSONOperations ops, String key, Field f) {
        Object referencedValue = accessor.getPropertyValue(f.getName());
        if (referencedValue != null) {
            if (referencedValue instanceof Collection) {
                Collection referenceValues = (Collection)referencedValue;
                ArrayList referenceKeys = new ArrayList();
                referenceValues.forEach(r -> {
                    Object id = ObjectUtils.getIdFieldForEntity(r);
                    if (id != null) {
                        String referenceKey = this.indexer.getKeyspaceForEntityClass(r.getClass()) + String.valueOf(id);
                        referenceKeys.add(referenceKey);
                    }
                });
                ops.set(key, referenceKeys, Path2.of((String)("$." + f.getName())));
            } else {
                Object id = ObjectUtils.getIdFieldForEntity(referencedValue);
                if (id != null) {
                    String referenceKey = this.indexer.getKeyspaceForEntityClass(f.getType()) + String.valueOf(id);
                    ops.set(key, (Object)referenceKey, Path2.of((String)("$." + f.getName())));
                }
            }
        }
    }
}

