/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import ai.djl.MalformedModelException;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.github.f4b6a3.ulid.Ulid;
import com.google.gson.ExclusionStrategy;
import com.google.gson.GsonBuilder;
import com.redis.om.spring.CustomRedisKeyValueTemplate;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.RedisJSONKeyValueAdapter;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.annotations.Bloom;
import com.redis.om.spring.annotations.Cuckoo;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.pds.BloomOperations;
import com.redis.om.spring.ops.pds.CuckooFilterOperations;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.serialization.gson.DateTypeAdapter;
import com.redis.om.spring.serialization.gson.GsonReferenceSerializerRegistrar;
import com.redis.om.spring.serialization.gson.GsonReferencesSerializationExclusionStrategy;
import com.redis.om.spring.serialization.gson.InstantTypeAdapter;
import com.redis.om.spring.serialization.gson.LocalDateTimeTypeAdapter;
import com.redis.om.spring.serialization.gson.LocalDateTypeAdapter;
import com.redis.om.spring.serialization.gson.OffsetDateTimeTypeAdapter;
import com.redis.om.spring.serialization.gson.PointTypeAdapter;
import com.redis.om.spring.serialization.gson.UlidTypeAdapter;
import com.redis.om.spring.serialization.gson.YearMonthTypeAdapter;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.DefaultEmbedder;
import com.redis.om.spring.vectorize.Embedder;
import com.redis.om.spring.vectorize.NoopEmbedder;
import com.redis.om.spring.vectorize.face.FaceDetectionTranslator;
import com.redis.om.spring.vectorize.face.FaceFeatureTranslator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingModel;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingModel;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.vertexai.palm2.VertexAiPaLm2EmbeddingModel;
import org.springframework.ai.vertexai.palm2.api.VertexAiPaLm2Api;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.gson.GsonBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClient;
import redis.clients.jedis.bloom.CFReserveParams;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class, RedisOMProperties.class})
@EnableAspectJAutoProxy
@ComponentScans(value={@ComponentScan(value={"com.redis.om.spring.bloom"}), @ComponentScan(value={"com.redis.om.spring.cuckoo"}), @ComponentScan(value={"com.redis.om.spring.autocomplete"}), @ComponentScan(value={"com.redis.om.spring.metamodel"}), @ComponentScan(value={"com.redis.om.spring.util"})})
public class RedisModulesConfiguration {
    private static final Log logger = LogFactory.getLog(RedisModulesConfiguration.class);

    @Bean(name={"keyValueMappingContext"})
    @ConditionalOnMissingBean
    public RedisMappingContext redisMappingContext() {
        return new RedisMappingContext();
    }

    @Bean(name={"omGsonBuilder"})
    public GsonBuilder gsonBuilder(List<GsonBuilderCustomizer> customizers) {
        GsonBuilder builder = new GsonBuilder();
        customizers.forEach(c -> c.customize(builder));
        builder.registerTypeAdapter(Point.class, (Object)PointTypeAdapter.getInstance());
        builder.registerTypeAdapter(Date.class, (Object)DateTypeAdapter.getInstance());
        builder.registerTypeAdapter(LocalDate.class, (Object)LocalDateTypeAdapter.getInstance());
        builder.registerTypeAdapter(LocalDateTime.class, (Object)LocalDateTimeTypeAdapter.getInstance());
        builder.registerTypeAdapter(Ulid.class, (Object)UlidTypeAdapter.getInstance());
        builder.registerTypeAdapter(Instant.class, (Object)InstantTypeAdapter.getInstance());
        builder.registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter());
        builder.registerTypeAdapter(YearMonth.class, (Object)new YearMonthTypeAdapter());
        builder.addSerializationExclusionStrategy((ExclusionStrategy)GsonReferencesSerializationExclusionStrategy.INSTANCE);
        return builder;
    }

    @Bean(name={"redisModulesClient"})
    @Lazy
    RedisModulesClient redisModulesClient(JedisConnectionFactory jedisConnectionFactory, @Qualifier(value="omGsonBuilder") GsonBuilder builder) {
        return new RedisModulesClient(jedisConnectionFactory, builder);
    }

    @Bean(name={"redisModulesOperations"})
    @Primary
    @ConditionalOnMissingBean
    @Lazy
    RedisModulesOperations<?> redisModulesOperations(RedisModulesClient rmc, StringRedisTemplate template, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder) {
        return new RedisModulesOperations(rmc, template, gsonBuilder);
    }

    @Bean(name={"redisJSONOperations"})
    JSONOperations<?> redisJSONOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForJSON();
    }

    @Bean(name={"redisBloomOperations"})
    BloomOperations<?> redisBloomOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForBloom();
    }

    @Bean(name={"redisCuckooOperations"})
    CuckooFilterOperations<?> redisCuckooFilterOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForCuckoFilter();
    }

    @Bean(name={"redisOmTemplate"})
    @Primary
    public RedisTemplate<?, ?> redisTemplate(JedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setDefaultSerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory((RedisConnectionFactory)connectionFactory);
        return template;
    }

    @Bean(name={"rediSearchIndexer"})
    public RediSearchIndexer redisearchIndexer(ApplicationContext ac, RedisOMProperties properties, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder) {
        return new RediSearchIndexer(ac, properties, gsonBuilder);
    }

    @Bean(name={"djlImageFactory"})
    public ImageFactory imageFactory() {
        return ImageFactory.getInstance();
    }

    @Bean(name={"djlImageEmbeddingModelCriteria"})
    public Criteria<Image, byte[]> imageEmbeddingModelCriteria(RedisOMProperties properties) {
        return properties.getDjl().isEnabled() ? Criteria.builder().setTypes(Image.class, byte[].class).optEngine(properties.getDjl().getImageEmbeddingModelEngine()).optModelUrls(properties.getDjl().getImageEmbeddingModelModelUrls()).build() : null;
    }

    @Bean(name={"djlFaceDetectionTranslator"})
    public Translator<Image, DetectedObjects> faceDetectionTranslator() {
        double confThresh = 0.85f;
        double nmsThresh = 0.45f;
        double[] variance = new double[]{0.1f, 0.2f};
        int topK = 5000;
        int[][] scales = new int[][]{{16, 32}, {64, 128}, {256, 512}};
        int[] steps = new int[]{8, 16, 32};
        return new FaceDetectionTranslator(confThresh, nmsThresh, variance, topK, scales, steps);
    }

    @Bean(name={"djlFaceDetectionModelCriteria"})
    public Criteria<Image, DetectedObjects> faceDetectionModelCriteria(@Qualifier(value="djlFaceDetectionTranslator") Translator<Image, DetectedObjects> translator, RedisOMProperties properties) {
        return properties.getDjl().isEnabled() ? Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelUrls(properties.getDjl().getFaceDetectionModelModelUrls()).optModelName(properties.getDjl().getFaceDetectionModelName()).optTranslator(translator).optEngine(properties.getDjl().getFaceDetectionModelEngine()).build() : null;
    }

    @Bean(name={"djlFaceDetectionModel"})
    public ZooModel<Image, DetectedObjects> faceDetectionModel(@Nullable @Qualifier(value="djlFaceDetectionModelCriteria") Criteria<Image, DetectedObjects> criteria, RedisOMProperties properties) {
        try {
            return properties.getDjl().isEnabled() && criteria != null ? ModelZoo.loadModel(criteria) : null;
        }
        catch (MalformedModelException | ModelNotFoundException | IOException ex) {
            logger.warn((Object)"Error retrieving default DJL face detection model", ex);
            return null;
        }
    }

    @Bean(name={"djlFaceEmbeddingTranslator"})
    public Translator<Image, float[]> faceEmbeddingTranslator() {
        return new FaceFeatureTranslator();
    }

    @Bean(name={"djlFaceEmbeddingModelCriteria"})
    public Criteria<Image, float[]> faceEmbeddingModelCriteria(@Qualifier(value="djlFaceEmbeddingTranslator") Translator<Image, float[]> translator, RedisOMProperties properties) {
        return properties.getDjl().isEnabled() ? Criteria.builder().setTypes(Image.class, float[].class).optModelUrls(properties.getDjl().getFaceEmbeddingModelModelUrls()).optModelName(properties.getDjl().getFaceEmbeddingModelName()).optTranslator(translator).optEngine(properties.getDjl().getFaceEmbeddingModelEngine()).build() : null;
    }

    @Bean(name={"djlFaceEmbeddingModel"})
    public ZooModel<Image, float[]> faceEmbeddingModel(@Nullable @Qualifier(value="djlFaceEmbeddingModelCriteria") Criteria<Image, float[]> criteria, RedisOMProperties properties) {
        try {
            return properties.getDjl().isEnabled() && criteria != null ? ModelZoo.loadModel(criteria) : null;
        }
        catch (Exception e) {
            logger.warn((Object)"Error retrieving default DJL face embeddings model", (Throwable)e);
            return null;
        }
    }

    @Bean(name={"djlImageEmbeddingModel"})
    public ZooModel<Image, byte[]> imageModel(@Nullable @Qualifier(value="djlImageEmbeddingModelCriteria") Criteria<Image, byte[]> criteria, RedisOMProperties properties) throws MalformedModelException, ModelNotFoundException, IOException {
        return properties.getDjl().isEnabled() && criteria != null ? ModelZoo.loadModel(criteria) : null;
    }

    @Bean(name={"djlDefaultImagePipeline"})
    public Pipeline defaultImagePipeline(RedisOMProperties properties) {
        if (properties.getDjl().isEnabled()) {
            Pipeline pipeline = new Pipeline();
            if (properties.getDjl().isDefaultImagePipelineCenterCrop()) {
                pipeline.add((Transform)new CenterCrop());
            }
            return pipeline.add((Transform)new Resize(properties.getDjl().getDefaultImagePipelineResizeWidth(), properties.getDjl().getDefaultImagePipelineResizeHeight())).add((Transform)new ToTensor());
        }
        return null;
    }

    @Bean(name={"djlSentenceTokenizer"})
    public HuggingFaceTokenizer sentenceTokenizer(RedisOMProperties properties) {
        if (properties.getDjl().isEnabled()) {
            Map<String, String> options = Map.of("maxLength", properties.getDjl().getSentenceTokenizerMaxLength(), "modelMaxLength", properties.getDjl().getSentenceTokenizerModelMaxLength());
            try {
                InetAddress.getByName("www.huggingface.co").isReachable(5000);
                return HuggingFaceTokenizer.newInstance((String)properties.getDjl().getSentenceTokenizerModel(), options);
            }
            catch (IOException ioe) {
                logger.warn((Object)"Error retrieving default DJL sentence tokenizer");
                return null;
            }
        }
        return null;
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenAiEmbeddingModel openAITextVectorizer(RedisOMProperties properties, @Value(value="${spring.ai.openai.api-key:}") String apiKey) {
        if (!(StringUtils.hasText((String)apiKey) || StringUtils.hasText((String)(apiKey = properties.getOpenAi().getApiKey())) || StringUtils.hasText((String)(apiKey = System.getenv("OPENAI_API_KEY"))))) {
            apiKey = System.getProperty("SPRING_AI_OPENAI_API_KEY");
        }
        if (StringUtils.hasText((String)apiKey)) {
            properties.getOpenAi().setApiKey(apiKey);
        }
        if (StringUtils.hasText((String)apiKey)) {
            OpenAiApi openAiApi = new OpenAiApi(apiKey);
            return new OpenAiEmbeddingModel(openAiApi, MetadataMode.EMBED, OpenAiEmbeddingOptions.builder().withModel("text-embedding-ada-002").build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
        }
        return null;
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenAIClient azureOpenAIClient(RedisOMProperties properties, @Value(value="${spring.ai.azure.openai.api-key:}") String apiKey, @Value(value="${spring.ai.azure.openai.endpoint:}") String endpoint) {
        if (!(StringUtils.hasText((String)apiKey) || StringUtils.hasText((String)(apiKey = properties.getAzureOpenAi().getApiKey())) || StringUtils.hasText((String)(apiKey = System.getenv("AZURE_OPENAI_API_KEY"))))) {
            apiKey = System.getProperty("SPRING_AI_AZURE_OPENAI_API_KEY");
        }
        if (!StringUtils.hasText((String)endpoint)) {
            endpoint = properties.getAzureOpenAi().getEndPoint();
            if (!StringUtils.hasText((String)apiKey)) {
                endpoint = System.getenv("AZURE_OPENAI_ENDPOINT");
                if (!StringUtils.hasText((String)apiKey)) {
                    endpoint = System.getProperty("SPRING_AI_AZURE_OPENAI_ENDPOINT");
                }
            }
        }
        if (StringUtils.hasText((String)apiKey) && StringUtils.hasText((String)endpoint)) {
            return new OpenAIClientBuilder().credential((KeyCredential)new AzureKeyCredential(apiKey)).endpoint(endpoint).buildClient();
        }
        return null;
    }

    @ConditionalOnMissingBean
    @Bean
    VertexAiPaLm2EmbeddingModel vertexAiPaLm2EmbeddingModel(RedisOMProperties properties, @Value(value="${spring.ai.vertex.ai.api-key:}") String apiKey, @Value(value="${spring.ai.vertex.ai.ai.base-url:}") String baseUrl) {
        if (!(StringUtils.hasText((String)apiKey) || StringUtils.hasText((String)(apiKey = properties.getVertexAi().getApiKey())) || StringUtils.hasText((String)(apiKey = System.getenv("VERTEX_AI_API_KEY"))))) {
            apiKey = System.getProperty("SPRING_AI_VERTEX_AI_API_KEY");
        }
        if (!StringUtils.hasText((String)baseUrl)) {
            baseUrl = properties.getVertexAi().getEndPoint();
            if (!StringUtils.hasText((String)apiKey)) {
                baseUrl = System.getenv("VERTEX_AI_ENDPOINT");
                if (!StringUtils.hasText((String)apiKey)) {
                    baseUrl = System.getProperty("SPRING_AI_VERTEX_AI_ENDPOINT");
                }
            }
        }
        if (StringUtils.hasText((String)apiKey) && StringUtils.hasText((String)baseUrl)) {
            VertexAiPaLm2Api vertexAiApi = new VertexAiPaLm2Api(baseUrl, apiKey, "chat-bison-001", "embedding-gecko-001", RestClient.builder());
            return new VertexAiPaLm2EmbeddingModel(vertexAiApi);
        }
        return null;
    }

    @ConditionalOnMissingBean
    @Bean
    BedrockCohereEmbeddingModel bedrockCohereEmbeddingModel(RedisOMProperties properties, @Value(value="${spring.ai.bedrock.aws.region:}") String region, @Value(value="${spring.ai.bedrock.aws.access-key:}") String accessKey, @Value(value="${spring.ai.bedrock.aws.secret-key:}") String secretKey, @Value(value="${spring.ai.bedrock.cohere.embedding.model:}") String model) {
        if (!StringUtils.hasText((String)region) && !StringUtils.hasText((String)(region = properties.getBedrockCohere().getRegion()))) {
            region = System.getenv("AWS_REGION");
            if (!StringUtils.hasText((String)region)) {
                region = System.getProperty("SPRING_AI_AWS_REGION");
            }
            properties.getBedrockCohere().setRegion(region);
        }
        if (!StringUtils.hasText((String)secretKey)) {
            region = Region.US_EAST_1.id();
        }
        if (!StringUtils.hasText((String)accessKey) && !StringUtils.hasText((String)(accessKey = properties.getBedrockCohere().getAccessKey()))) {
            accessKey = System.getenv("AWS_ACCESS_KEY_ID");
            if (!StringUtils.hasText((String)accessKey)) {
                accessKey = System.getProperty("SPRING_AI_AWS_ACCESS_KEY_ID");
            }
            properties.getBedrockCohere().setAccessKey(accessKey);
        }
        if (!StringUtils.hasText((String)secretKey) && !StringUtils.hasText((String)(secretKey = properties.getBedrockCohere().getSecretKey()))) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
            if (!StringUtils.hasText((String)secretKey)) {
                secretKey = System.getProperty("SPRING_AI_AWS_SECRET_ACCESS_KEY");
            }
            properties.getBedrockCohere().setSecretKey(secretKey);
        }
        if (!StringUtils.hasText((String)model) && !StringUtils.hasText((String)(model = properties.getBedrockCohere().getModel()))) {
            model = CohereEmbeddingBedrockApi.CohereEmbeddingModel.COHERE_EMBED_MULTILINGUAL_V1.id();
            properties.getBedrockCohere().setModel(model);
        }
        if (StringUtils.hasText((String)accessKey) && StringUtils.hasText((String)secretKey)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            CohereEmbeddingBedrockApi cohereEmbeddingApi = new CohereEmbeddingBedrockApi(model, (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials), region, ModelOptionsUtils.OBJECT_MAPPER);
            return new BedrockCohereEmbeddingModel(cohereEmbeddingApi);
        }
        return null;
    }

    @ConditionalOnMissingBean
    @Bean
    BedrockTitanEmbeddingModel bedrockTitanEmbeddingModel(RedisOMProperties properties, @Value(value="${spring.ai.bedrock.aws.region:}") String region, @Value(value="${spring.ai.bedrock.aws.access-key:}") String accessKey, @Value(value="${spring.ai.bedrock.aws.secret-key:}") String secretKey, @Value(value="${spring.ai.bedrock.titan.embedding.model:}") String model) {
        if (!StringUtils.hasText((String)region) && !StringUtils.hasText((String)(region = properties.getBedrockCohere().getRegion()))) {
            region = System.getenv("AWS_REGION");
            if (!StringUtils.hasText((String)region)) {
                region = System.getProperty("SPRING_AI_AWS_REGION");
            }
            properties.getBedrockCohere().setRegion(region);
        }
        if (!StringUtils.hasText((String)secretKey)) {
            region = Region.US_EAST_1.id();
        }
        if (!StringUtils.hasText((String)accessKey) && !StringUtils.hasText((String)(accessKey = properties.getBedrockTitan().getAccessKey()))) {
            accessKey = System.getenv("AWS_ACCESS_KEY_ID");
            if (!StringUtils.hasText((String)accessKey)) {
                accessKey = System.getProperty("SPRING_AI_AWS_ACCESS_KEY_ID");
            }
            properties.getBedrockTitan().setAccessKey(accessKey);
        }
        if (!StringUtils.hasText((String)secretKey) && !StringUtils.hasText((String)(secretKey = properties.getBedrockTitan().getSecretKey()))) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
            if (!StringUtils.hasText((String)secretKey)) {
                secretKey = System.getProperty("SPRING_AI_AWS_SECRET_ACCESS_KEY");
            }
            properties.getBedrockTitan().setSecretKey(secretKey);
        }
        if (!StringUtils.hasText((String)model) && !StringUtils.hasText((String)(model = properties.getBedrockTitan().getModel()))) {
            model = TitanEmbeddingBedrockApi.TitanEmbeddingModel.TITAN_EMBED_IMAGE_V1.id();
            properties.getBedrockTitan().setModel(model);
        }
        if (StringUtils.hasText((String)accessKey) && StringUtils.hasText((String)secretKey)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            TitanEmbeddingBedrockApi titanEmbeddingApi = new TitanEmbeddingBedrockApi(model, (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials), region, ModelOptionsUtils.OBJECT_MAPPER, Duration.ofMinutes(5L));
            return new BedrockTitanEmbeddingModel(titanEmbeddingApi);
        }
        return null;
    }

    @Bean(name={"featureExtractor"})
    public Embedder featureExtractor(@Nullable @Qualifier(value="djlImageEmbeddingModel") ZooModel<Image, byte[]> imageEmbeddingModel, @Nullable @Qualifier(value="djlFaceEmbeddingModel") ZooModel<Image, float[]> faceEmbeddingModel, @Nullable @Qualifier(value="djlImageFactory") ImageFactory imageFactory, @Nullable @Qualifier(value="djlDefaultImagePipeline") Pipeline defaultImagePipeline, @Nullable @Qualifier(value="djlSentenceTokenizer") HuggingFaceTokenizer sentenceTokenizer, @Nullable OpenAiEmbeddingModel openAITextVectorizer, @Nullable OpenAIClient azureOpenAIClient, @Nullable VertexAiPaLm2EmbeddingModel vertexAiPaLm2EmbeddingModel, @Nullable BedrockCohereEmbeddingModel bedrockCohereEmbeddingModel, @Nullable BedrockTitanEmbeddingModel bedrockTitanEmbeddingModel, RedisOMProperties properties, ApplicationContext ac) {
        return properties.getDjl().isEnabled() ? new DefaultEmbedder(ac, imageEmbeddingModel, faceEmbeddingModel, imageFactory, defaultImagePipeline, sentenceTokenizer, openAITextVectorizer, azureOpenAIClient, vertexAiPaLm2EmbeddingModel, bedrockCohereEmbeddingModel, bedrockTitanEmbeddingModel, properties) : new NoopEmbedder();
    }

    @Bean(name={"redisJSONKeyValueAdapter"})
    RedisJSONKeyValueAdapter getRedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, RediSearchIndexer indexer, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder, RedisOMProperties properties, @Nullable @Qualifier(value="featureExtractor") Embedder embedder) {
        return new RedisJSONKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, gsonBuilder, embedder, properties);
    }

    @Bean(name={"redisJSONKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getRedisJSONKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, RediSearchIndexer indexer, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder, RedisOMProperties properties, @Nullable @Qualifier(value="featureExtractor") Embedder embedder) {
        return new CustomRedisKeyValueTemplate(new RedisJSONKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, gsonBuilder, embedder, properties), mappingContext);
    }

    @Bean(name={"redisCustomKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, RediSearchIndexer indexer, RedisOMProperties properties, @Nullable @Qualifier(value="featureExtractor") Embedder embedder) {
        return new CustomRedisKeyValueTemplate(new RedisEnhancedKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, embedder, properties), mappingContext);
    }

    @Bean(name={"streamingQueryBuilder"})
    EntityStream streamingQueryBuilder(RedisModulesOperations<?> redisModulesOperations, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder, RediSearchIndexer indexer) {
        return new EntityStreamImpl(redisModulesOperations, gsonBuilder, indexer);
    }

    @Bean(name={"redisOMCacheManager"})
    public CacheManager getCacheManager() {
        return new ConcurrentMapCacheManager();
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void ensureIndexesAreCreated(ContextRefreshedEvent cre) {
        logger.info((Object)"Creating Indexes......");
        ApplicationContext ac = cre.getApplicationContext();
        RediSearchIndexer indexer = (RediSearchIndexer)ac.getBean("rediSearchIndexer");
        indexer.createIndicesFor(Document.class);
        indexer.createIndicesFor(RedisHash.class);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void processBloom(ContextRefreshedEvent cre) {
        ApplicationContext ac = cre.getApplicationContext();
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        Set<BeanDefinition> beanDefs = ObjectUtils.getBeanDefinitionsFor(ac, Document.class, RedisHash.class);
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                for (Field field : ObjectUtils.getDeclaredFieldsTransitively(cl)) {
                    if (!field.isAnnotationPresent(Bloom.class)) continue;
                    Bloom bloom = field.getAnnotation(Bloom.class);
                    BloomOperations<String> ops = rmo.opsForBloom();
                    String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bloom.name()) ? bloom.name() : String.format("bf:%s:%s", cl.getSimpleName(), field.getName());
                    ops.createFilter(filterName, bloom.capacity(), bloom.errorRate());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Error during processing of @Bloom annotation: ", (Throwable)e);
            }
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void processCuckoo(ContextRefreshedEvent cre) {
        ApplicationContext ac = cre.getApplicationContext();
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        Set<BeanDefinition> beanDefs = ObjectUtils.getBeanDefinitionsFor(ac, Document.class, RedisHash.class);
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                for (Field field : ObjectUtils.getDeclaredFieldsTransitively(cl)) {
                    if (!field.isAnnotationPresent(Cuckoo.class)) continue;
                    Cuckoo cuckoo = field.getAnnotation(Cuckoo.class);
                    CuckooFilterOperations ops = rmo.opsForCuckoFilter();
                    String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)cuckoo.name()) ? cuckoo.name() : String.format("cf:%s:%s", cl.getSimpleName(), field.getName());
                    CFReserveParams params = CFReserveParams.reserveParams().bucketSize((long)cuckoo.bucketSize()).expansion(cuckoo.expansion()).maxIterations(cuckoo.maxIterations());
                    ops.createFilter(filterName, cuckoo.capacity(), params);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Error during processing of @Bloom annotation: ", (Throwable)e);
            }
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void registerReferenceSerializer(ContextRefreshedEvent cre) {
        logger.info((Object)"Registering Reference Serializers......");
        ApplicationContext ac = cre.getApplicationContext();
        GsonBuilder gsonBuilder = (GsonBuilder)ac.getBean("omGsonBuilder");
        GsonReferenceSerializerRegistrar registrar = new GsonReferenceSerializerRegistrar(gsonBuilder, ac);
        registrar.registerReferencesFor(Document.class);
        registrar.registerReferencesFor(RedisHash.class);
    }
}

