/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.indexing.SearchField;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.jedis.JedisValues;
import com.redis.om.spring.util.ObjectUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Example;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.expression.spel.SpelEvaluationException;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;
import redis.clients.jedis.search.schemafields.GeoField;
import redis.clients.jedis.search.schemafields.NumericField;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TagField;
import redis.clients.jedis.search.schemafields.TextField;
import redis.clients.jedis.search.schemafields.VectorField;

public class ExampleToNodeConverter<E> {
    private final RediSearchIndexer indexer;
    private final double defaultDistance;
    private final Metrics defaultDistanceMetric;

    public ExampleToNodeConverter(RediSearchIndexer indexer) {
        this.indexer = indexer;
        this.defaultDistance = indexer.getProperties().getRepository().getQuery().getDefaultDistance();
        this.defaultDistanceMetric = indexer.getProperties().getRepository().getQuery().getDefaultDistanceMetrics();
    }

    private static Optional<String> getAliasForSchemaField(SchemaField schemaField) {
        String alias = schemaField.getFieldName().getAttribute();
        return Optional.ofNullable(alias);
    }

    public Node processExample(Example<E> example, Node rootNode) {
        Class entityClass = example.getProbeType();
        List<SearchField> schemaFields = this.indexer.getSchemaFor(entityClass);
        boolean matchingAll = example.getMatcher().isAllMatching();
        Set toIgnore = example.getMatcher().getIgnoredPaths();
        for (SearchField searchField : schemaFields) {
            Object value;
            SchemaField schemaField = searchField.getSchemaField();
            Optional<String> maybeAlias = ExampleToNodeConverter.getAliasForSchemaField(schemaField);
            String fieldName = maybeAlias.orElseGet(() -> searchField.getField().getName().replace("$.", ""));
            if (toIgnore.contains(fieldName)) continue;
            try {
                value = ObjectUtils.getValueByPath(example.getProbe(), schemaField.getName());
            }
            catch (SpelEvaluationException see) {
                value = ObjectUtils.getValueByPath(example.getProbe(), searchField.getField().getName());
            }
            fieldName = QueryUtils.escape(fieldName);
            if (value == null) continue;
            Class<?> cls = value.getClass();
            if (schemaField instanceof TagField) {
                if (Iterable.class.isAssignableFrom(value.getClass())) {
                    Iterable values = (Iterable)value;
                    if (!(values = (Iterable)StreamSupport.stream(values.spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList())).iterator().hasNext()) continue;
                    QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
                    for (Object v : values) {
                        if (v.toString().isBlank()) continue;
                        and.add(fieldName, new String[]{"{" + String.valueOf(v) + "}"});
                    }
                    if (matchingAll) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode, and});
                        continue;
                    }
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode, and});
                    continue;
                }
                if (matchingAll) {
                    rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"{" + String.valueOf(QueryUtils.escape(value)) + "}"});
                    continue;
                }
                rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"{" + String.valueOf(QueryUtils.escape(value)) + "}"});
                continue;
            }
            if (schemaField instanceof TextField) {
                switch (example.getMatcher().getDefaultStringMatcher()) {
                    case DEFAULT: 
                    case EXACT: {
                        rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{QueryUtils.escape(value.toString(), false)}) : rootNode;
                        break;
                    }
                    case STARTING: {
                        rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{QueryUtils.escape(value.toString(), false) + "*"}) : rootNode;
                        break;
                    }
                    case ENDING: {
                        rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"*" + QueryUtils.escape(value.toString(), false)}) : rootNode;
                        break;
                    }
                    case CONTAINING: {
                        rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"*" + QueryUtils.escape(value.toString(), false) + "*"}) : rootNode;
                        break;
                    }
                }
                continue;
            }
            if (schemaField instanceof GeoField) {
                if (cls == Point.class) {
                    Point point = (Point)value;
                    double x = point.getX();
                    double y = point.getY();
                    if (matchingAll) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s %s %s]", x, y, this.defaultDistance, this.defaultDistanceMetric.getAbbreviation())});
                        continue;
                    }
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s %s %s]", x, y, this.defaultDistance, this.defaultDistanceMetric.getAbbreviation())});
                    continue;
                }
                if (!CharSequence.class.isAssignableFrom(cls)) continue;
                String[] coordinates = value.toString().split(",");
                double x = Double.parseDouble(coordinates[0]);
                double y = Double.parseDouble(coordinates[1]);
                if (matchingAll) {
                    rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s %s %s]", x, y, this.defaultDistance, this.defaultDistanceMetric.getAbbreviation())});
                    continue;
                }
                rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s %s %s]", x, y, this.defaultDistance, this.defaultDistanceMetric.getAbbreviation())});
                continue;
            }
            if (schemaField instanceof NumericField) {
                if (Iterable.class.isAssignableFrom(value.getClass())) {
                    Iterable values = (Iterable)value;
                    if (!(values = (Iterable)StreamSupport.stream(values.spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList())).iterator().hasNext()) continue;
                    Class<?> elementClass = values.iterator().next().getClass();
                    QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
                    for (Object v : values) {
                        if (matchingAll) {
                            if (elementClass == LocalDate.class) {
                                and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)v)})});
                                continue;
                            }
                            if (elementClass == Date.class) {
                                and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)v)})});
                                continue;
                            }
                            if (elementClass == LocalDateTime.class) {
                                and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)v)})});
                                continue;
                            }
                            if (elementClass == Instant.class) {
                                and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)v)})});
                                continue;
                            }
                            if (elementClass == Integer.class) {
                                and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(v.toString()))})});
                                continue;
                            }
                            if (elementClass == Long.class) {
                                and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(v.toString()))})});
                                continue;
                            }
                            if (elementClass != Double.class) continue;
                            and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(v.toString()))})});
                            continue;
                        }
                        if (elementClass == LocalDate.class) {
                            and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)v)})});
                            continue;
                        }
                        if (elementClass == Date.class) {
                            and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)v)})});
                            continue;
                        }
                        if (elementClass == LocalDateTime.class) {
                            and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)v)})});
                            continue;
                        }
                        if (elementClass == Instant.class) {
                            and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)v)})});
                            continue;
                        }
                        if (elementClass == Integer.class) {
                            and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(v.toString()))})});
                            continue;
                        }
                        if (elementClass == Long.class) {
                            and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(v.toString()))})});
                            continue;
                        }
                        if (elementClass != Double.class) continue;
                        and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(v.toString()))})});
                    }
                    if (matchingAll) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode, and});
                        continue;
                    }
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode, and});
                    continue;
                }
                if (matchingAll) {
                    if (cls == LocalDate.class) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)value)});
                        continue;
                    }
                    if (cls == Date.class) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)value)});
                        continue;
                    }
                    if (cls == LocalDateTime.class) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)value)});
                        continue;
                    }
                    if (cls == Instant.class) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)value)});
                        continue;
                    }
                    if (cls == Integer.class) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(value.toString()))});
                        continue;
                    }
                    if (cls == Long.class) {
                        rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(value.toString()))});
                        continue;
                    }
                    if (cls != Double.class) continue;
                    rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
                    continue;
                }
                if (cls == LocalDate.class) {
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)value)});
                    continue;
                }
                if (cls == Date.class) {
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)value)});
                    continue;
                }
                if (cls == LocalDateTime.class) {
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)value)});
                    continue;
                }
                if (cls == Instant.class) {
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)value)});
                    continue;
                }
                if (cls == Integer.class) {
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(value.toString()))});
                    continue;
                }
                if (cls == Long.class) {
                    rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(value.toString()))});
                    continue;
                }
                if (cls != Double.class) continue;
                rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
                continue;
            }
            if (!(schemaField instanceof VectorField)) continue;
        }
        return rootNode;
    }
}

