/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class SentinelConfig {
    @Bean
    public JedisConnectionFactory jedisConnectionFactory(Environment env) {
        String master = env.getProperty("spring.redis.sentinel.master", "localhost");
        String nodes = env.getProperty("spring.redis.sentinel.nodes");
        Set sentinelNodes = StringUtils.commaDelimitedListToSet((String)nodes);
        Set redisNodes = sentinelNodes.stream().map(RedisNode::fromString).collect(Collectors.toSet());
        RedisSentinelConfiguration sentinelConfig = new RedisSentinelConfiguration().master(master);
        sentinelConfig.setSentinels(redisNodes);
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(30000L));
        poolConfig.setNumTestsPerEvictionRun(-1);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setTestOnReturn(false);
        poolConfig.setTestOnBorrow(false);
        int timeout = 10000;
        JedisClientConfiguration jedisClientConfiguration = JedisClientConfiguration.builder().connectTimeout(Duration.ofMillis(10000L)).readTimeout(Duration.ofMillis(10000L)).usePooling().poolConfig((GenericObjectPoolConfig)poolConfig).build();
        return new JedisConnectionFactory(sentinelConfig, jedisClientConfiguration);
    }

    @Bean
    public StringRedisTemplate redisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(connectionFactory);
        return template;
    }
}

