/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.countmin;

import com.redis.om.spring.annotations.CountMin;
import com.redis.om.spring.ops.pds.CountMinSketchOperations;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.util.ObjectUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CountMinAspect
implements Ordered {
    private static final Log logger = LogFactory.getLog(CountMinAspect.class);
    private final CountMinSketchOperations<String> ops;
    private final StringRedisTemplate stringRedisTemplate;

    public CountMinAspect(CountMinSketchOperations<String> ops, StringRedisTemplate stringRedisTemplate) {
        this.ops = ops;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.save(..))")
    public void inCrudRepositorySave() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.save(..))")
    public void inRedisDocumentRepositorySave() {
    }

    @Pointcut(value="inCrudRepositorySave() || inRedisDocumentRepositorySave()")
    private void inSaveOperation() {
    }

    @AfterReturning(value="inSaveOperation() && args(entity,..)")
    public void addToCountMin(JoinPoint jp, Object entity) {
        for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entity.getClass())) {
            if (!field.isAnnotationPresent(CountMin.class)) continue;
            CountMin countMin = field.getAnnotation(CountMin.class);
            String sketchName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)countMin.name()) ? countMin.name() : String.format("cms:%s:%s", entity.getClass().getSimpleName(), field.getName());
            try {
                Pair pair;
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                Object fieldValue = pd.getReadMethod().invoke(entity, new Object[0]);
                if (fieldValue == null) continue;
                this.initializeCountMinSketch(sketchName, countMin);
                if (fieldValue instanceof Pair && (pair = (Pair)fieldValue).getFirst() instanceof String && pair.getSecond() instanceof Number) {
                    this.ops.cmsIncrBy(sketchName, (String)pair.getFirst(), ((Number)pair.getSecond()).longValue());
                    continue;
                }
                if (fieldValue instanceof Iterable) {
                    Iterable iterable = (Iterable)fieldValue;
                    for (Object item : iterable) {
                        Pair p;
                        if (item instanceof Pair && (p = (Pair)item).getFirst() instanceof String && p.getSecond() instanceof Number) {
                            this.ops.cmsIncrBy(sketchName, (String)p.getFirst(), ((Number)p.getSecond()).longValue());
                            continue;
                        }
                        this.ops.cmsIncrBy(sketchName, item.toString(), 1L);
                    }
                    continue;
                }
                this.ops.cmsIncrBy(sketchName, fieldValue.toString(), 1L);
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error((Object)String.format("Could not add value to Count-min Sketch %s", sketchName), (Throwable)e);
            }
        }
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.saveAll(..))")
    public void inCrudRepositorySaveAll() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.saveAll(..))")
    public void inRedisDocumentRepositorySaveAll() {
    }

    @Pointcut(value="inCrudRepositorySaveAll() || inRedisDocumentRepositorySaveAll()")
    private void inSaveAllOperation() {
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.deleteAll())")
    public void inCrudRepositoryDeleteAllNoArgs() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAll())")
    public void inRedisDocumentRepositoryDeleteAllNoArgs() {
    }

    @Pointcut(value="inCrudRepositoryDeleteAllNoArgs() || inRedisDocumentRepositoryDeleteAllNoArgs()")
    private void inDeleteAllNoArgsOperation() {
    }

    @AfterReturning(value="inSaveAllOperation() && args(entities,..)")
    public void addAllToCountMin(JoinPoint jp, List<Object> entities) {
        for (Object entity : entities) {
            for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entity.getClass())) {
                if (!field.isAnnotationPresent(CountMin.class)) continue;
                CountMin countMin = field.getAnnotation(CountMin.class);
                String sketchName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)countMin.name()) ? countMin.name() : String.format("cms:%s:%s", entity.getClass().getSimpleName(), field.getName());
                try {
                    Pair pair;
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                    Object fieldValue = pd.getReadMethod().invoke(entity, new Object[0]);
                    if (fieldValue == null) continue;
                    this.initializeCountMinSketch(sketchName, countMin);
                    if (fieldValue instanceof Pair && (pair = (Pair)fieldValue).getFirst() instanceof String && pair.getSecond() instanceof Number) {
                        this.ops.cmsIncrBy(sketchName, (String)pair.getFirst(), ((Number)pair.getSecond()).longValue());
                        continue;
                    }
                    if (fieldValue instanceof Iterable) {
                        Iterable iterable = (Iterable)fieldValue;
                        for (Object item : iterable) {
                            Pair p;
                            if (item instanceof Pair && (p = (Pair)item).getFirst() instanceof String && p.getSecond() instanceof Number) {
                                this.ops.cmsIncrBy(sketchName, (String)p.getFirst(), ((Number)p.getSecond()).longValue());
                                continue;
                            }
                            this.ops.cmsIncrBy(sketchName, item.toString(), 1L);
                        }
                        continue;
                    }
                    this.ops.cmsIncrBy(sketchName, fieldValue.toString(), 1L);
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    logger.error((Object)String.format("Could not add value to Count-min Sketch %s", sketchName), (Throwable)e);
                }
            }
        }
    }

    private void initializeCountMinSketch(String sketchName, CountMin countMin) {
        try {
            this.ops.cmsInfo(sketchName);
        }
        catch (Exception e) {
            if (countMin.initMode() == CountMin.InitMode.DIMENSIONS) {
                if (countMin.width() > 0L && countMin.depth() > 0L) {
                    this.ops.cmsInitByDim(sketchName, countMin.width(), countMin.depth());
                } else {
                    logger.error((Object)String.format("Invalid dimensions for Count-min Sketch %s: width=%d, depth=%d", sketchName, countMin.width(), countMin.depth()));
                }
            }
            this.ops.cmsInitByProb(sketchName, countMin.errorRate(), countMin.probability());
        }
    }

    @AfterReturning(value="inDeleteAllNoArgsOperation()")
    public void deleteCMSOnDeleteAll(JoinPoint jp) {
        Object target = jp.getTarget();
        Class<?> entityClass = this.resolveEntityClassFromRepository(target.getClass());
        if (entityClass == null) {
            logger.warn((Object)("Could not determine entity class for repository: " + String.valueOf(target.getClass())));
            return;
        }
        for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entityClass)) {
            if (!field.isAnnotationPresent(CountMin.class)) continue;
            CountMin countMin = field.getAnnotation(CountMin.class);
            String sketchName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)countMin.name()) ? countMin.name() : String.format("cms:%s:%s", entityClass.getSimpleName(), field.getName());
            try {
                this.stringRedisTemplate.delete((Object)sketchName);
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Failed to delete Count-Min Sketch %s", sketchName), (Throwable)e);
            }
        }
    }

    private boolean isKeyValueRepositoryInterface(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == KeyValueRepository.class) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!this.isKeyValueRepositoryInterface(iface)) continue;
            return true;
        }
        return false;
    }

    private Class<?> resolveEntityClassFromRepository(Class<?> repoClass) {
        for (Type genericInterface : repoClass.getGenericInterfaces()) {
            Class rawInterface;
            Class<?> found;
            if (genericInterface instanceof ParameterizedType) {
                Type type;
                Type[] typeArgs;
                Class rawClass;
                ParameterizedType pType = (ParameterizedType)genericInterface;
                Type raw = pType.getRawType();
                if (!(raw instanceof Class) || !this.isKeyValueRepositoryInterface(rawClass = (Class)raw) || (typeArgs = pType.getActualTypeArguments()).length <= 0 || !((type = typeArgs[0]) instanceof Class)) continue;
                Class entityClass = (Class)type;
                return entityClass;
            }
            if (!(genericInterface instanceof Class) || (found = this.resolveEntityClassFromRepository(rawInterface = (Class)genericInterface)) == null) continue;
            return found;
        }
        Class<?> superClass = repoClass.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return this.resolveEntityClassFromRepository(superClass);
        }
        return null;
    }

    public int getOrder() {
        return 1;
    }
}

