/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.id;

import com.github.f4b6a3.ulid.Ulid;
import com.github.f4b6a3.ulid.UlidCreator;
import com.redis.om.spring.id.SecureRandom;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

public enum ULIDIdentifierGenerator implements IdentifierGenerator
{
    INSTANCE;


    public <T> T generateIdentifierOfType(TypeInformation<T> identifierType) {
        Class type = identifierType.getType();
        if (ClassUtils.isAssignable(Ulid.class, (Class)type)) {
            return (T)UlidCreator.getMonotonicUlid();
        }
        if (ClassUtils.isAssignable(String.class, (Class)type)) {
            return (T)UlidCreator.getMonotonicUlid().toString();
        }
        if (ClassUtils.isAssignable(Integer.class, (Class)type)) {
            return (T)Integer.valueOf(SecureRandom.getSecureRandom().nextInt());
        }
        if (ClassUtils.isAssignable(Long.class, (Class)type)) {
            return (T)Long.valueOf(SecureRandom.getSecureRandom().nextLong());
        }
        throw new InvalidDataAccessApiUsageException(String.format("Identifier cannot be generated for %s. Supported types are: ULID, String, Integer, and Long.", identifierType.getType().getName()));
    }
}

