/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.mapping;

import com.redis.om.spring.annotations.RedisKey;
import com.redis.om.spring.util.ObjectUtils;
import jakarta.persistence.IdClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.mapping.BasicRedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class RedisEnhancedPersistentEntity<T>
extends BasicRedisPersistentEntity<T>
implements RedisPersistentEntity<T> {
    private final List<RedisPersistentProperty> idProperties = new ArrayList<RedisPersistentProperty>();
    private final boolean hasIdClass;
    private volatile Optional<Field> redisKeyField = null;

    public RedisEnhancedPersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver keySpaceResolver, TimeToLiveAccessor timeToLiveAccessor) {
        super(information, keySpaceResolver, timeToLiveAccessor);
        this.hasIdClass = information.getType().isAnnotationPresent(IdClass.class);
    }

    public void addPersistentProperty(RedisPersistentProperty property) {
        if (property.isIdProperty()) {
            if (this.hasIdClass) {
                this.idProperties.add(property);
            } else {
                RedisPersistentProperty existingIdProperty = this.getIdProperty();
                if (existingIdProperty != null) {
                    throw new MappingException(String.format("Attempt to add explicit id property %s but already have a property %s registered as explicit id; Check your mapping configuration", property.getField(), existingIdProperty.getField()));
                }
            }
        }
        super.addPersistentProperty((PersistentProperty)property);
    }

    protected RedisPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(RedisPersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (this.hasIdClass) {
            return property;
        }
        return super.returnPropertyIfBetterIdPropertyCandidateOrNull(property);
    }

    @Nullable
    public RedisPersistentProperty getIdProperty() {
        return this.idProperties.isEmpty() ? (RedisPersistentProperty)super.getIdProperty() : this.idProperties.get(0);
    }

    public List<RedisPersistentProperty> getIdProperties() {
        return this.idProperties;
    }

    public boolean isIdClassComposite() {
        return this.hasIdClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Field> getRedisKeyField() {
        if (this.redisKeyField == null) {
            RedisEnhancedPersistentEntity redisEnhancedPersistentEntity = this;
            synchronized (redisEnhancedPersistentEntity) {
                if (this.redisKeyField == null) {
                    this.redisKeyField = this.findRedisKeyField();
                }
            }
        }
        return this.redisKeyField;
    }

    public <E> E populateRedisKey(E entity, String redisKey) {
        if (entity == null || redisKey == null) {
            return entity;
        }
        Optional<Field> fieldOpt = this.getRedisKeyField();
        if (fieldOpt.isPresent()) {
            try {
                fieldOpt.get().set(entity, redisKey);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set @RedisKey field", e);
            }
        }
        return entity;
    }

    private Optional<Field> findRedisKeyField() {
        List<Field> fields = ObjectUtils.getDeclaredFieldsTransitively(this.getType());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(RedisKey.class)) continue;
            field.setAccessible(true);
            return Optional.of(field);
        }
        return Optional.empty();
    }
}

