/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.mapping;

import com.redis.om.spring.mapping.RedisEnhancedMappingContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RedisEnhancedTimeToLiveAccessor
implements TimeToLiveAccessor {
    private final Map<Class<?>, Long> defaultTimeouts = new HashMap();
    private final Map<Class<?>, PersistentProperty<?>> timeoutProperties = new HashMap();
    private final Map<Class<?>, Method> timeoutMethods = new HashMap();
    private final KeyspaceConfiguration keyspaceConfig;
    private final RedisEnhancedMappingContext mappingContext;

    public RedisEnhancedTimeToLiveAccessor(KeyspaceConfiguration keyspaceConfig, RedisEnhancedMappingContext mappingContext) {
        Assert.notNull((Object)keyspaceConfig, (String)"KeyspaceConfiguration must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null");
        this.keyspaceConfig = keyspaceConfig;
        this.mappingContext = mappingContext;
    }

    public Long getTimeToLive(Object source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Class type = source instanceof Class ? (Class)source : (source instanceof PartialUpdate ? ((PartialUpdate)source).getTarget() : source.getClass());
        Long defaultTimeout = this.resolveDefaultTimeOut(type);
        TimeUnit unit = TimeUnit.SECONDS;
        PersistentProperty<?> ttlProperty = this.resolveTtlProperty(type);
        if (ttlProperty != null && ttlProperty.isAnnotationPresent(TimeToLive.class)) {
            unit = ((TimeToLive)ttlProperty.getRequiredAnnotation(TimeToLive.class)).unit();
        }
        if (source instanceof PartialUpdate) {
            PartialUpdate update = (PartialUpdate)source;
            if (ttlProperty != null && !update.getPropertyUpdates().isEmpty()) {
                for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                    if (!PartialUpdate.UpdateCommand.SET.equals((Object)pUpdate.getCmd()) || !ttlProperty.getName().equals(pUpdate.getPropertyPath())) continue;
                    return TimeUnit.SECONDS.convert((Long)NumberUtils.convertNumberToTargetClass((Number)((Number)pUpdate.getValue()), Long.class), unit);
                }
            }
        } else if (ttlProperty != null) {
            RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Object ttlPropertyValue = entity.getPropertyAccessor(source).getProperty(ttlProperty);
            if (ttlPropertyValue != null) {
                return TimeUnit.SECONDS.convert(((Number)ttlPropertyValue).longValue(), unit);
            }
        } else {
            Method timeoutMethod = this.resolveTimeMethod(type);
            if (timeoutMethod != null) {
                ReflectionUtils.makeAccessible((Method)timeoutMethod);
                TimeToLive ttl = (TimeToLive)AnnotationUtils.findAnnotation((Method)timeoutMethod, TimeToLive.class);
                try {
                    Number timeout = (Number)timeoutMethod.invoke(source, new Object[0]);
                    if (timeout != null && ttl != null) {
                        return TimeUnit.SECONDS.convert(timeout.longValue(), ttl.unit());
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new IllegalStateException(String.format("Cannot access method '%s': %s", timeoutMethod.getName(), ex.getMessage()), ex);
                }
            }
        }
        return defaultTimeout;
    }

    public boolean isExpiringEntity(Class<?> type) {
        Long defaultTimeOut = this.resolveDefaultTimeOut(type);
        if (defaultTimeOut != null && defaultTimeOut > 0L) {
            return true;
        }
        if (this.resolveTtlProperty(type) != null) {
            return true;
        }
        return this.resolveTimeMethod(type) != null;
    }

    @Nullable
    private Long resolveDefaultTimeOut(Class<?> type) {
        RedisHash hash;
        if (this.defaultTimeouts.containsKey(type)) {
            return this.defaultTimeouts.get(type);
        }
        Long defaultTimeout = null;
        if (this.keyspaceConfig.hasSettingsFor(type)) {
            defaultTimeout = this.keyspaceConfig.getKeyspaceSettings(type).getTimeToLive();
        }
        if ((hash = (RedisHash)((RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type)).findAnnotation(RedisHash.class)) != null && hash.timeToLive() > 0L) {
            defaultTimeout = hash.timeToLive();
        }
        this.defaultTimeouts.put(type, defaultTimeout);
        return defaultTimeout;
    }

    @Nullable
    private PersistentProperty<?> resolveTtlProperty(Class<?> type) {
        KeyspaceConfiguration.KeyspaceSettings settings;
        if (this.timeoutProperties.containsKey(type)) {
            return this.timeoutProperties.get(type);
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        PersistentProperty ttlProperty = entity.getPersistentProperty(TimeToLive.class);
        if (ttlProperty != null) {
            this.timeoutProperties.put(type, ttlProperty);
            return ttlProperty;
        }
        if (this.keyspaceConfig.hasSettingsFor(type) && StringUtils.hasText((String)(settings = this.keyspaceConfig.getKeyspaceSettings(type)).getTimeToLivePropertyName()) && (ttlProperty = entity.getPersistentProperty(settings.getTimeToLivePropertyName())) != null) {
            this.timeoutProperties.put(type, ttlProperty);
            return ttlProperty;
        }
        this.timeoutProperties.put(type, null);
        return null;
    }

    @Nullable
    private Method resolveTimeMethod(Class<?> type) {
        if (this.timeoutMethods.containsKey(type)) {
            return this.timeoutMethods.get(type);
        }
        this.timeoutMethods.put(type, null);
        ReflectionUtils.doWithMethods(type, method -> this.timeoutMethods.put(type, method), method -> ClassUtils.isAssignable(Number.class, method.getReturnType()) && AnnotationUtils.findAnnotation((Method)method, TimeToLive.class) != null);
        return this.timeoutMethods.get(type);
    }
}

