/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel;

import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class MetamodelUtils {
    private MetamodelUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static MetamodelField<?, ?> getMetamodelForIdField(Class<?> entityClass) {
        Optional<Field> idField = ObjectUtils.getIdFieldForEntityClass(entityClass);
        if (idField.isPresent()) {
            try {
                Class<?> metamodel = Class.forName(entityClass.getName() + "$");
                String metamodelField = ObjectUtils.staticField(idField.get().getName());
                Field field = metamodel.getField(metamodelField);
                return (MetamodelField)field.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static List<MetamodelField<?, ?>> getMetamodelFieldsForProperties(Class<?> entityClass, Collection<String> properties) {
        ArrayList result = new ArrayList();
        String metamodelClassName = MetamodelUtils.getMetamodelClassName(entityClass);
        try {
            Class<?> metamodel = Class.forName(metamodelClassName);
            for (String property : properties) {
                try {
                    result.add((MetamodelField)metamodel.getField(ObjectUtils.staticField(property)).get(null));
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private static String getMetamodelClassName(Class<?> entityClass) {
        if (entityClass.isMemberClass()) {
            Class<?> enclosingClass = entityClass.getEnclosingClass();
            String enclosingClassName = enclosingClass.getSimpleName();
            String entityClassName = entityClass.getSimpleName();
            return entityClass.getPackage().getName() + "." + enclosingClassName + "_" + entityClassName + "$";
        }
        return entityClass.getName() + "$";
    }
}

