/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel.indexed;

import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.actions.NumIncrByAction;
import com.redis.om.spring.search.stream.predicates.numeric.BetweenPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.EqualPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.GreaterThanOrEqualPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.GreaterThanPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.InPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.LessThanOrEqualPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.LessThanPredicate;
import com.redis.om.spring.search.stream.predicates.numeric.NotEqualPredicate;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class NumericField<E, T>
extends MetamodelField<E, T> {
    public NumericField(SearchFieldAccessor field, boolean indexed) {
        super(field, indexed);
    }

    public NumericField(Class<E> targetClass, String fieldName) {
        super(targetClass, fieldName);
    }

    public EqualPredicate<E, T> eq(T value) {
        return new EqualPredicate(this.searchFieldAccessor, value);
    }

    public NotEqualPredicate<E, T> notEq(T value) {
        return new NotEqualPredicate(this.searchFieldAccessor, value);
    }

    public GreaterThanPredicate<E, T> gt(T value) {
        return new GreaterThanPredicate(this.searchFieldAccessor, value);
    }

    public GreaterThanOrEqualPredicate<E, T> ge(T value) {
        return new GreaterThanOrEqualPredicate(this.searchFieldAccessor, value);
    }

    public LessThanPredicate<E, T> lt(T value) {
        return new LessThanPredicate(this.searchFieldAccessor, value);
    }

    public LessThanOrEqualPredicate<E, T> le(T value) {
        return new LessThanOrEqualPredicate(this.searchFieldAccessor, value);
    }

    public BetweenPredicate<E, T> between(T min, T max) {
        return new BetweenPredicate(this.searchFieldAccessor, min, max);
    }

    public InPredicate<E, ?> in(T value) {
        return new InPredicate(this.searchFieldAccessor, List.of(value));
    }

    public InPredicate<E, ?> in(T ... values) {
        return new InPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }

    public Consumer<E> incrBy(Long value) {
        return new NumIncrByAction(this.searchFieldAccessor, value);
    }

    public Consumer<E> decrBy(Long value) {
        return new NumIncrByAction(this.searchFieldAccessor, -value.longValue());
    }

    public InPredicate<E, ?> containsDouble(Double ... values) {
        return new InPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }

    public InPredicate<E, ?> containsLong(Long ... values) {
        return new InPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }

    public InPredicate<E, ?> containsInt(Integer ... values) {
        return new InPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }
}

