/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.pds;

import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.pds.TopKOperations;
import java.util.List;
import java.util.Map;

public class TopKOperationsImpl<K>
implements TopKOperations<K> {
    final RedisModulesClient client;

    public TopKOperationsImpl(RedisModulesClient client) {
        this.client = client;
    }

    @Override
    public String createFilter(K key, long topk) {
        return this.client.clientForTopK().topkReserve(key.toString(), topk);
    }

    @Override
    public String createFilter(K key, long topk, long width, long depth, double decay) {
        return this.client.clientForTopK().topkReserve(key.toString(), topk, width, depth, decay);
    }

    @Override
    public List<String> add(K key, String ... items) {
        return this.client.clientForTopK().topkAdd(key.toString(), items);
    }

    @Override
    public String incrementBy(K key, String item, long increment) {
        return this.client.clientForTopK().topkIncrBy(key.toString(), item, increment);
    }

    @Override
    public List<String> incrementBy(K key, Map<String, Long> itemIncrementMap) {
        return this.client.clientForTopK().topkIncrBy(key.toString(), itemIncrementMap);
    }

    @Override
    public List<Boolean> query(K key, String ... items) {
        return this.client.clientForTopK().topkQuery(key.toString(), items);
    }

    @Override
    public List<String> list(K key) {
        return this.client.clientForTopK().topkList(key.toString());
    }

    @Override
    public Map<String, Long> listWithCount(K key) {
        return this.client.clientForTopK().topkListWithCount(key.toString());
    }

    @Override
    public Map<String, Object> info(K key) {
        return this.client.clientForTopK().topkInfo(key.toString());
    }
}

