/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.gson.GsonBuilder;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.mapping.RedisEnhancedMappingContext;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.repository.support.RedisDocumentRepositoryFactory;
import com.redis.om.spring.vectorize.Embedder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactoryBean;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.MappingConfiguration;
import org.springframework.data.redis.core.index.ConfigurableIndexDefinitionProvider;
import org.springframework.data.redis.core.index.IndexConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisDocumentRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends KeyValueRepositoryFactoryBean<T, S, ID> {
    @Autowired
    @Nullable
    private RedisModulesOperations<String> rmo;
    @Autowired
    @Nullable
    private RediSearchIndexer indexer;
    @Autowired
    @Nullable
    private RedisMappingContext mappingContext;
    @Autowired
    private GsonBuilder gsonBuilder;
    @Autowired
    @Nullable
    private Embedder embedder;
    @Autowired
    private RedisOMProperties properties;

    public RedisDocumentRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected final RedisDocumentRepositoryFactory createRepositoryFactory(KeyValueOperations operations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        return new RedisDocumentRepositoryFactory(operations, this.rmo, this.indexer, queryCreator, repositoryQueryType, this.mappingContext, this.gsonBuilder, this.embedder, this.properties);
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        MappingConfiguration mappingConfiguration = new MappingConfiguration((ConfigurableIndexDefinitionProvider)new IndexConfiguration(), new KeyspaceConfiguration());
        RedisEnhancedMappingContext enhancedContext = new RedisEnhancedMappingContext(mappingConfiguration);
        super.setMappingContext((MappingContext)enhancedContext);
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.rmo, (String)"RedisModulesOperations must not be null!");
        super.afterPropertiesSet();
    }
}

