/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.annotations.Dialect;
import com.redis.om.spring.audit.EntityAuditor;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.IdentifierFilter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.indexing.LexicographicIndexer;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.mapping.RedisEnhancedPersistentEntity;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.MetamodelUtils;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.RedisDocumentRepository;
import com.redis.om.spring.repository.support.UpdateOperation;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.search.stream.RedisFluentQueryByExample;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.serialization.gson.GsonListOfType;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import jakarta.persistence.IdClass;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Version;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.json.JsonProtocol;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.SafeEncoder;

public class SimpleRedisDocumentRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisDocumentRepository<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleRedisDocumentRepository.class);
    protected final RedisModulesOperations<String> modulesOperations;
    protected final EntityInformation<T, ID> metadata;
    protected final KeyValueOperations operations;
    protected final RediSearchIndexer indexer;
    protected final MappingRedisOMConverter mappingConverter;
    protected final EntityAuditor auditor;
    protected final Embedder embedder;
    private final GsonBuilder gsonBuilder;
    private final ULIDIdentifierGenerator generator;
    private final RedisOMProperties properties;
    private final RedisMappingContext mappingContext;
    private final EntityStream entityStream;
    private final LexicographicIndexer lexicographicIndexer;

    public SimpleRedisDocumentRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, RediSearchIndexer indexer, RedisMappingContext mappingContext, GsonBuilder gsonBuilder, Embedder embedder, RedisOMProperties properties) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.indexer = indexer;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl((RedisOperations)this.modulesOperations.template()));
        this.generator = ULIDIdentifierGenerator.INSTANCE;
        this.gsonBuilder = gsonBuilder;
        this.mappingContext = mappingContext;
        this.auditor = new EntityAuditor((RedisOperations<?, ?>)this.modulesOperations.template());
        this.embedder = embedder;
        this.properties = properties;
        this.entityStream = new EntityStreamImpl(this.modulesOperations, this.modulesOperations.gsonBuilder(), indexer);
        this.lexicographicIndexer = new LexicographicIndexer((RedisTemplate<String, String>)this.modulesOperations.template(), indexer);
    }

    @Override
    public Iterable<ID> getIds() {
        Gson gson = this.gsonBuilder.create();
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(this.metadata.getJavaType());
        String idField = maybeIdField.map(Field::getName).orElse("id");
        Query query = new Query("*");
        query.limit(Integer.valueOf(0), Integer.valueOf(this.properties.getRepository().getQuery().getLimit()));
        query.returnFields(new String[]{idField});
        SearchResult searchResult = this.getSearchOps().search(query);
        return searchResult.getDocuments().stream().map(d -> gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get(idField))), this.metadata.getIdType())).toList();
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        ArrayList ids = Lists.newArrayList(this.getIds());
        int fromIndex = Math.toIntExact(pageable.getOffset());
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void deleteById(ID id, Path2 path) {
        this.modulesOperations.opsForJSON().del(this.getKey(id), path);
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        this.modulesOperations.opsForJSON().set(this.getKey(Objects.requireNonNull(this.metadata.getId(entity))), value, Path2.of((String)field.getJSONPath()));
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(Path2.of((String)field.getJSONPath()), List.class, (K[])keys).stream().flatMap(Collection::stream).toList();
    }

    @Override
    public Long getExpiration(ID id) {
        StringRedisTemplate template = this.modulesOperations.template();
        return template.getExpire((Object)this.getKey(id));
    }

    @Override
    public boolean setExpiration(ID id, Long expiration, TimeUnit timeUnit) {
        StringRedisTemplate template = this.modulesOperations.template();
        return Boolean.TRUE.equals(template.expire((Object)this.getKey(id), expiration.longValue(), timeUnit));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(entity.getClass());
        if (lexicographicFields != null && !lexicographicFields.isEmpty()) {
            Iterable result = this.saveAll(Collections.singletonList(entity));
            return result.isEmpty() ? null : (S)result.get(0);
        }
        return (S)super.save(entity);
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        ArrayList<String> entityIds = new ArrayList<String>();
        this.embedder.processEntities(entities);
        try (Jedis jedis = this.modulesOperations.client().getJedis().get();){
            long failedCount;
            Pipeline pipeline = jedis.pipelined();
            Gson gson = this.gsonBuilder.create();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(Objects.requireNonNull((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : keyValueEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)Objects.requireNonNull((KeyValuePersistentProperty)keyValueEntity.getIdProperty()));
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String idAsString = this.validateKeyForWriting(id, entity);
                entityIds.add(idAsString);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, idAsString);
                this.auditor.processEntity(entity, isNew);
                Optional<Long> maybeTtl = this.getTTLForEntity(entity);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                rdo.setId(idAsString);
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(objectKey);
                args.add(SafeEncoder.encode((String)Path2.ROOT_PATH.toString()));
                args.add(SafeEncoder.encode((String)gson.toJson(entity)));
                pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                this.processReferenceAnnotations(objectKey, entity, pipeline);
                Object keyspaceWithColon = keyspace.endsWith(":") ? keyspace : keyspace + ":";
                this.lexicographicIndexer.processEntity(entity, idAsString, isNew, (String)keyspaceWithColon);
                maybeTtl.ifPresent(ttl -> {
                    if (ttl > 0L) {
                        pipeline.expire(objectKey, ttl.longValue());
                    }
                });
                saved.add(entity);
            }
            List responses = pipeline.syncAndReturnAll();
            if (responses != null && !responses.isEmpty() && (failedCount = IntStream.range(0, Math.min(responses.size(), entityIds.size())).filter(i -> responses.get(i) instanceof JedisDataException).peek(i -> logger.warn("Failed JSON.SET command for entity with id: {} Error: {}", entityIds.get(i), (Object)((JedisDataException)((Object)((Object)responses.get(i)))).getMessage())).count()) > 0L) {
                logger.warn("Total failed JSON.SET commands: {}", (Object)failedCount);
            }
        }
        return saved;
    }

    @Override
    public Iterable<T> bulkLoad(String file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(file, new String[0]));){
            Gson gson = this.gsonBuilder.create();
            List entities = (List)gson.fromJson((Reader)reader, new GsonListOfType(this.metadata.getJavaType()));
            Iterable iterable = this.saveAll((Iterable)entities);
            return iterable;
        }
    }

    @Override
    public <S extends T> S update(S entity) {
        return (S)this.operations.update(this.metadata.getRequiredId(entity), entity);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        this.checkVersion(entity);
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(entity.getClass());
        if (lexicographicFields != null && !lexicographicFields.isEmpty()) {
            Object id = this.metadata.getRequiredId(entity);
            String idAsString = this.validateKeyForWriting(id, entity);
            KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
            String keyspace = keyValueEntity.getKeySpace();
            Object keyspaceWithColon = keyspace.endsWith(":") ? keyspace : keyspace + ":";
            this.lexicographicIndexer.processEntityDeletion(entity, idAsString, (String)keyspaceWithColon);
        }
        this.operations.delete(entity);
    }

    public void deleteById(ID id) {
        Optional entity;
        Assert.notNull(id, (String)"The given id must not be null");
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(this.metadata.getJavaType());
        if (lexicographicFields != null && !lexicographicFields.isEmpty() && (entity = this.findById(id)).isPresent()) {
            this.delete(entity.get());
            return;
        }
        super.deleteById(id);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        entities.forEach(this::delete);
    }

    public List<T> findAllById(Iterable<ID> ids) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(this.metadata.getJavaType(), (K[])keys).stream().toList();
    }

    @Override
    public String getKeyspace() {
        return this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    private String getKey(Object id) {
        String stringId = this.asStringValue(id);
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(this.metadata.getJavaType());
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            stringId = filter.filter(stringId);
        }
        return this.getKeyspace() + stringId;
    }

    public byte[] createKey(String keyspace, String id) {
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(keyspace);
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            id = filter.filter(id);
        }
        return this.mappingConverter.toBytes(keyspace.endsWith(":") ? keyspace + id : keyspace + ":" + id);
    }

    private void processReferenceAnnotations(byte[] objectKey, Object entity, Pipeline pipeline) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(entity.getClass(), Reference.class);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
            fields.forEach(arg_0 -> this.lambda$processReferenceAnnotations$7((PropertyAccessor)accessor, objectKey, pipeline, arg_0));
        }
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
        if (keyspaceConfig.hasSettingsFor(entity.getClass())) {
            KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entity.getClass());
            if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                try {
                    Field fld = ReflectionUtils.findField(entity.getClass(), (String)settings.getTimeToLivePropertyName());
                    Method ttlGetter = ObjectUtils.getGetterForField(entity.getClass(), Objects.requireNonNull(fld));
                    long ttlPropertyValue = ((Number)Objects.requireNonNull(ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity))).longValue();
                    ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity);
                    TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                    if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                        return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                    }
                    return Optional.of(ttlPropertyValue);
                }
                catch (IllegalArgumentException | SecurityException e) {
                    return Optional.empty();
                }
            }
            if (settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                return Optional.of(settings.getTimeToLive());
            }
        }
        return Optional.empty();
    }

    private void checkVersion(T entity) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(entity.getClass(), Version.class);
        if (fields.size() == 1) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
            Field versionField = fields.get(0);
            String property = versionField.getName();
            if (versionField.getType() == Integer.class || ObjectUtils.isPrimitiveOfType(versionField.getType(), Integer.class) || versionField.getType() == Long.class || ObjectUtils.isPrimitiveOfType(versionField.getType(), Long.class)) {
                Number version = (Number)wrapper.getPropertyValue(property);
                Number dbVersion = this.getEntityVersion(this.getKey(this.metadata.getRequiredId(entity)), property);
                if (dbVersion != null && version != null && dbVersion.longValue() != version.longValue()) {
                    throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s as it is outdated", entity, version));
                }
            }
        }
    }

    private Number getEntityVersion(String key, String versionProperty) {
        Class type;
        JSONOperations<String> ops = this.modulesOperations.opsForJSON();
        Long[] dbVersionArray = (Long[])ops.get(key, type = new TypeToken<Long[]>(){}.getRawType(), Path2.of((String)("$." + versionProperty)));
        return dbVersionArray != null ? dbVersionArray[0] : null;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Iterable<S> result = this.findAll(example);
        int size = Iterables.size(result);
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("Query returned non unique result", 1);
        }
        return StreamSupport.stream(result.spliterator(), false).findFirst();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).dialect(Dialect.TWO.getValue()).filter(example).collect(Collectors.toList());
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.entityStream.of(example.getProbeType()).dialect(Dialect.TWO.getValue()).filter(example).sorted(sort).collect(Collectors.toList());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        SearchStream<S> stream = this.entityStream.of(example.getProbeType());
        int offset = pageable.getPageNumber() * pageable.getPageSize();
        int limit = pageable.getPageSize();
        Page page = stream.filter(example).dialect(Dialect.TWO.getValue()).loadAll().limit(limit, Math.toIntExact(offset)).toList(pageable, stream.getEntityClass());
        return page;
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll(pageable.getSort());
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        if (this.indexer.indexDefinitionExistsFor(this.metadata.getJavaType())) {
            String searchIndex = this.indexer.getIndexName(this.metadata.getJavaType());
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
            Query query = new Query("*");
            query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
            for (Sort.Order order : pageable.getSort()) {
                query.setSortBy(order.getProperty(), order.isAscending());
            }
            SearchResult searchResult = searchOps.search(query);
            Gson gson = this.gsonBuilder.create();
            if (searchResult.getTotalResults() > 0L) {
                List<Object> content = searchResult.getDocuments().stream().map(d -> {
                    Object entity = gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), this.metadata.getJavaType());
                    return ObjectUtils.populateRedisKey(entity, d.getId());
                }).toList();
                return new PageImpl(content, pageable, searchResult.getTotalResults());
            }
            return Page.empty();
        }
        return super.findAll(pageable);
    }

    public List<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.properties.getRepository().getQuery().getLimit(), (Sort)sort);
        return this.findAll((Pageable)pageRequest).toList();
    }

    public <S extends T> long count(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).count();
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new RedisFluentQueryByExample(example, example.getProbeType(), this.entityStream, this.getSearchOps(), this.mappingConverter.getMappingContext()));
    }

    @Override
    public <S extends T> S update(Example<S> example) {
        Object probe = example.getProbe();
        ExampleMatcher matcher = example.getMatcher();
        Object id = this.metadata.getId(probe);
        if (id == null) {
            throw new IllegalArgumentException("Example object must have an ID");
        }
        String key = this.getKey(id);
        Class entityType = this.metadata.getJavaType();
        ArrayList<UpdateOperation> updateOperations = new ArrayList<UpdateOperation>();
        List<MetamodelField<?, ?>> metamodelFields = MetamodelUtils.getMetamodelFieldsForProperties(entityType, ObjectUtils.getAllProperties(entityType));
        for (MetamodelField<?, ?> metamodelField : metamodelFields) {
            Object value;
            String propertyName = metamodelField.getSearchAlias();
            if (!ObjectUtils.shouldIncludeProperty(matcher, propertyName) || (value = ObjectUtils.getPropertyValue(probe, propertyName)) == null) continue;
            updateOperations.add(new UpdateOperation(key, metamodelField, value));
        }
        this.executePipelinedUpdates(updateOperations);
        return (S)this.getJSONOperations().get(key, entityType);
    }

    @Override
    public <S extends T> void updateAll(Iterable<Example<S>> examples) {
        if (!examples.iterator().hasNext()) {
            return;
        }
        ArrayList<UpdateOperation> updateOperations = new ArrayList<UpdateOperation>();
        Class entityType = this.metadata.getJavaType();
        List<MetamodelField<?, ?>> metamodelFields = MetamodelUtils.getMetamodelFieldsForProperties(entityType, ObjectUtils.getAllProperties(entityType));
        for (Example<S> example : examples) {
            Object probe = example.getProbe();
            ExampleMatcher matcher = example.getMatcher();
            Object id = this.metadata.getId(probe);
            if (id == null) {
                throw new IllegalArgumentException("Example object must have an ID");
            }
            String key = this.getKey(id);
            for (MetamodelField<?, ?> metamodelField : metamodelFields) {
                Object value;
                String propertyName = metamodelField.getSearchAlias();
                if (!ObjectUtils.shouldIncludeProperty(matcher, propertyName) || (value = ObjectUtils.getPropertyValue(probe, propertyName)) == null) continue;
                updateOperations.add(new UpdateOperation(key, metamodelField, value));
            }
        }
        this.executePipelinedUpdates(updateOperations);
    }

    @Override
    public String getKeyFor(T entity) {
        String stringId;
        RedisEnhancedPersistentEntity persistentEntity = (RedisEnhancedPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        if (persistentEntity.isIdClassComposite()) {
            DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
            ArrayList<String> idParts = new ArrayList<String>();
            for (RedisPersistentProperty idProperty : persistentEntity.getIdProperties()) {
                Object propertyValue = wrapper.getPropertyValue(idProperty.getName());
                if (propertyValue == null) continue;
                idParts.add(propertyValue.toString());
            }
            stringId = String.join((CharSequence)":", idParts);
        } else {
            Object id = ObjectUtils.getIdFieldForEntity(entity);
            stringId = (String)this.mappingConverter.getConversionService().convert(id, String.class);
        }
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(this.metadata.getJavaType());
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            stringId = filter.filter(stringId);
        }
        return this.getKeyspace() + stringId;
    }

    private JSONOperations<String> getJSONOperations() {
        return this.modulesOperations.opsForJSON();
    }

    private void executePipelinedUpdates(List<UpdateOperation> updateOperations) {
        try (Jedis jedis = this.modulesOperations.client().getJedis().get();){
            Pipeline pipeline = jedis.pipelined();
            for (UpdateOperation op : updateOperations) {
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(SafeEncoder.encode((String)op.key));
                args.add(SafeEncoder.encode((String)Path2.of((String)op.field.getJSONPath()).toString()));
                args.add(SafeEncoder.encode((String)new Gson().toJson(op.value)));
                args.add(SafeEncoder.encode((String)"XX"));
                pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[0][]));
            }
            pipeline.sync();
        }
    }

    private SearchOperations<String> getSearchOps() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        String searchIndex = this.indexer.getIndexName(keyspace);
        return this.modulesOperations.opsForSearch(searchIndex);
    }

    private String validateKeyForWriting(Object id, Object item) {
        RedisEnhancedPersistentEntity entity = (RedisEnhancedPersistentEntity)this.mappingContext.getRequiredPersistentEntity(item.getClass());
        if (entity.isIdClassComposite()) {
            DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(item);
            ArrayList<String> idParts = new ArrayList<String>();
            for (RedisPersistentProperty idProperty : entity.getIdProperties()) {
                Object propertyValue = wrapper.getPropertyValue(idProperty.getName());
                if (propertyValue == null) continue;
                idParts.add(propertyValue.toString());
            }
            return String.join((CharSequence)":", idParts);
        }
        return (String)this.mappingConverter.getConversionService().convert(id, String.class);
    }

    private String asStringValue(Object value) {
        if (value != null) {
            for (RedisPersistentEntity entity : this.mappingContext.getPersistentEntities()) {
                IdClass idClassAnn = entity.getType().getAnnotation(IdClass.class);
                if (idClassAnn == null || !idClassAnn.value().equals(value.getClass())) continue;
                DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(value);
                RedisEnhancedPersistentEntity enhancedEntity = (RedisEnhancedPersistentEntity)entity;
                ArrayList<String> idParts = new ArrayList<String>();
                for (RedisPersistentProperty idProperty : enhancedEntity.getIdProperties()) {
                    Object propertyValue = wrapper.getPropertyValue(idProperty.getName());
                    if (propertyValue == null) continue;
                    idParts.add(propertyValue.toString());
                }
                return String.join((CharSequence)":", idParts);
            }
        }
        return (String)this.mappingConverter.getConversionService().convert(value, String.class);
    }

    private /* synthetic */ void lambda$processReferenceAnnotations$7(PropertyAccessor accessor, byte[] objectKey, Pipeline pipeline, Field f) {
        Object referencedValue = accessor.getPropertyValue(f.getName());
        if (referencedValue != null) {
            Gson gson = this.gsonBuilder.create();
            if (referencedValue instanceof Collection) {
                Collection referenceValues = (Collection)referencedValue;
                ArrayList referenceKeys = new ArrayList();
                referenceValues.forEach(r -> {
                    Object id = ObjectUtils.getIdFieldForEntity(r);
                    if (id != null) {
                        String referenceKey = this.indexer.getKeyspaceForEntityClass(r.getClass()) + String.valueOf(id);
                        referenceKeys.add(referenceKey);
                    }
                });
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(objectKey);
                args.add(SafeEncoder.encode((String)Path2.of((String)("$." + f.getName())).toString()));
                args.add(SafeEncoder.encode((String)gson.toJson(referenceKeys)));
                pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
            } else {
                Object id = ObjectUtils.getIdFieldForEntity(referencedValue);
                if (id != null) {
                    String referenceKey = this.indexer.getKeyspaceForEntityClass(f.getType()) + String.valueOf(id);
                    ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                    args.add(objectKey);
                    args.add(SafeEncoder.encode((String)Path2.of((String)("$." + f.getName())).toString()));
                    args.add(SafeEncoder.encode((String)gson.toJson((Object)referenceKey)));
                    pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                }
            }
        }
    }
}

