/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.audit.EntityAuditor;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.IdentifierFilter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.indexing.LexicographicIndexer;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.mapping.RedisEnhancedPersistentEntity;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.MetamodelUtils;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.RedisEnhancedRepository;
import com.redis.om.spring.repository.support.UpdateOperation;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.search.stream.RedisFluentQueryByExample;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.SafeEncoder;

public class SimpleRedisEnhancedRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisEnhancedRepository<T, ID> {
    protected final RedisModulesOperations<String> modulesOperations;
    protected final EntityInformation<T, ID> metadata;
    protected final KeyValueOperations operations;
    protected final RediSearchIndexer indexer;
    protected final MappingRedisOMConverter mappingConverter;
    protected final RedisEnhancedKeyValueAdapter enhancedKeyValueAdapter;
    protected final EntityAuditor auditor;
    protected final Embedder embedder;
    protected final LexicographicIndexer lexicographicIndexer;
    private final ULIDIdentifierGenerator generator;
    private final RedisOMProperties properties;
    private final EntityStream entityStream;

    public SimpleRedisEnhancedRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, RediSearchIndexer indexer, Embedder embedder, RedisOMProperties properties) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.indexer = indexer;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl((RedisOperations)this.modulesOperations.template()));
        this.enhancedKeyValueAdapter = new RedisEnhancedKeyValueAdapter((RedisOperations<?, ?>)rmo.template(), rmo, indexer, embedder, properties);
        this.generator = ULIDIdentifierGenerator.INSTANCE;
        this.auditor = new EntityAuditor((RedisOperations<?, ?>)this.modulesOperations.template());
        this.embedder = embedder;
        this.properties = properties;
        this.lexicographicIndexer = new LexicographicIndexer((RedisTemplate<String, String>)this.modulesOperations.template(), indexer);
        this.entityStream = new EntityStreamImpl(this.modulesOperations, this.modulesOperations.gsonBuilder(), indexer);
    }

    @Override
    public Iterable<ID> getIds() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(this.metadata.getJavaType());
        String idField = maybeIdField.map(Field::getName).orElse("id");
        Query query = new Query("*");
        query.limit(Integer.valueOf(0), Integer.valueOf(this.properties.getRepository().getQuery().getLimit()));
        query.returnFields(new String[]{idField});
        SearchResult searchResult = searchOps.search(query);
        return searchResult.getDocuments().stream().map(d -> ObjectUtils.documentToObject(d, this.metadata.getJavaType(), this.mappingConverter)).map(e -> ObjectUtils.getIdFieldForEntity((Field)maybeIdField.get(), e)).toList();
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        ArrayList ids = Lists.newArrayList(this.getIds());
        int fromIndex = Long.valueOf(pageable.getOffset()).intValue();
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        PartialUpdate update = new PartialUpdate((Object)this.metadata.getId(entity).toString(), this.metadata.getJavaType()).set(field.getSearchAlias(), value);
        this.enhancedKeyValueAdapter.update(update);
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        StringRedisTemplate template = this.modulesOperations.template();
        List<String> keys = StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toList();
        return keys.stream().map(arg_0 -> SimpleRedisEnhancedRepository.lambda$getFieldsByIds$2((RedisTemplate)template, field, arg_0)).collect(Collectors.toList());
    }

    @Override
    public Long getExpiration(ID id) {
        StringRedisTemplate template = this.modulesOperations.template();
        return template.getExpire((Object)this.getKey(id));
    }

    @Override
    public boolean setExpiration(ID id, Long expiration, TimeUnit timeUnit) {
        StringRedisTemplate template = this.modulesOperations.template();
        return Boolean.TRUE.equals(template.expire((Object)this.getKey(id), expiration.longValue(), timeUnit));
    }

    public List<T> findAll() {
        return IterableConverter.toList((Iterable)this.operations.findAll(this.metadata.getJavaType()));
    }

    public List<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.properties.getRepository().getQuery().getLimit(), (Sort)sort);
        return this.findAll((Pageable)pageRequest).toList();
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        if (this.indexer.indexDefinitionExistsFor(this.metadata.getJavaType())) {
            String searchIndex = this.indexer.getIndexName(this.metadata.getJavaType());
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
            Query query = new Query("*");
            query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
            pageable.getSort();
            for (Sort.Order order : pageable.getSort()) {
                query.setSortBy(order.getProperty(), order.isAscending());
            }
            SearchResult searchResult = searchOps.search(query);
            if (searchResult.getTotalResults() > 0L) {
                List<Object> content = searchResult.getDocuments().stream().map(d -> {
                    Object entity = ObjectUtils.documentToObject(d, this.metadata.getJavaType(), this.mappingConverter);
                    return ObjectUtils.populateRedisKey(entity, d.getId());
                }).toList();
                return new PageImpl(content, pageable, searchResult.getTotalResults());
            }
            return Page.empty();
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.metadata.getJavaType());
        return new PageImpl(IterableConverter.toList((Iterable)content), pageable, this.operations.count(this.metadata.getJavaType()));
    }

    @Override
    public String getKeyspace() {
        return this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    @Override
    public <S extends T> S update(Example<S> example) {
        Object probe = example.getProbe();
        ExampleMatcher matcher = example.getMatcher();
        Object id = this.metadata.getId(probe);
        if (id == null) {
            throw new IllegalArgumentException("Example object must have an ID");
        }
        String key = this.getKey(id);
        Class entityType = this.metadata.getJavaType();
        ArrayList<UpdateOperation> updateOperations = new ArrayList<UpdateOperation>();
        List<MetamodelField<?, ?>> metamodelFields = MetamodelUtils.getMetamodelFieldsForProperties(entityType, ObjectUtils.getAllProperties(entityType));
        for (MetamodelField<?, ?> metamodelField : metamodelFields) {
            Object value;
            String propertyName = metamodelField.getSearchAlias();
            if (propertyName.equals("id") || !ObjectUtils.shouldIncludeProperty(matcher, propertyName) || (value = ObjectUtils.getPropertyValue(probe, propertyName)) == null) continue;
            updateOperations.add(new UpdateOperation(key, metamodelField, value));
        }
        if (!updateOperations.isEmpty()) {
            this.executePipelinedUpdates(updateOperations);
        }
        return (S)this.findById(id).orElseThrow(() -> new RuntimeException("Failed to fetch updated entity"));
    }

    @Override
    public <S extends T> void updateAll(Iterable<Example<S>> examples) {
        if (!examples.iterator().hasNext()) {
            return;
        }
        ArrayList<UpdateOperation> updateOperations = new ArrayList<UpdateOperation>();
        Class entityType = this.metadata.getJavaType();
        List<MetamodelField<?, ?>> metamodelFields = MetamodelUtils.getMetamodelFieldsForProperties(entityType, ObjectUtils.getAllProperties(entityType));
        for (Example<S> example : examples) {
            Object probe = example.getProbe();
            ExampleMatcher matcher = example.getMatcher();
            Object id = this.metadata.getId(probe);
            if (id == null) {
                throw new IllegalArgumentException("Example object must have an ID");
            }
            String key = this.getKey(id);
            for (MetamodelField<?, ?> metamodelField : metamodelFields) {
                Object value;
                String propertyName = metamodelField.getSearchAlias();
                if (!ObjectUtils.shouldIncludeProperty(matcher, propertyName) || (value = ObjectUtils.getPropertyValue(probe, propertyName)) == null) continue;
                updateOperations.add(new UpdateOperation(key, metamodelField, value));
            }
        }
        this.executePipelinedUpdates(updateOperations);
    }

    @Override
    public String getKeyFor(T entity) {
        String stringId;
        RedisEnhancedPersistentEntity persistentEntity = (RedisEnhancedPersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(entity.getClass());
        if (persistentEntity.isIdClassComposite()) {
            DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
            ArrayList<String> idParts = new ArrayList<String>();
            for (RedisPersistentProperty idProperty : persistentEntity.getIdProperties()) {
                Object propertyValue = wrapper.getPropertyValue(idProperty.getName());
                if (propertyValue == null) continue;
                idParts.add(propertyValue.toString());
            }
            stringId = String.join((CharSequence)":", idParts);
        } else {
            Object id = ObjectUtils.getIdFieldForEntity(entity);
            stringId = (String)this.mappingConverter.getConversionService().convert(id, String.class);
        }
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(this.metadata.getJavaType());
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            stringId = filter.filter(stringId);
        }
        return this.getKeyspace() + stringId;
    }

    private String getKey(Object id) {
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(this.metadata.getJavaType());
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            id = filter.filter(id.toString());
        }
        return this.getKeyspace() + id.toString();
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        this.embedder.processEntities(entities);
        try (Jedis jedis = this.modulesOperations.client().getJedis().get();){
            Pipeline pipeline = jedis.pipelined();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : keyValueEntity.getPropertyAccessor(entity).getProperty(keyValueEntity.getIdProperty());
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String idAsString = this.validateKeyForWriting(id, entity);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, idAsString);
                this.auditor.processEntity(entity, isNew);
                Object keyspaceWithColon = keyspace.endsWith(":") ? keyspace : keyspace + ":";
                this.lexicographicIndexer.processEntity(entity, idAsString, isNew, (String)keyspaceWithColon);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                pipeline.hmset(objectKey, rdo.getBucket().rawMap());
                if (this.expires(rdo)) {
                    pipeline.expire(objectKey, rdo.getTimeToLive().longValue());
                }
                saved.add(entity);
            }
            pipeline.sync();
        }
        return saved;
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(entity.getClass());
        if (lexicographicFields != null && !lexicographicFields.isEmpty()) {
            Object id = this.metadata.getRequiredId(entity);
            String idAsString = this.validateKeyForWriting(id, entity);
            KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
            String keyspace = keyValueEntity.getKeySpace();
            Object keyspaceWithColon = keyspace.endsWith(":") ? keyspace : keyspace + ":";
            this.lexicographicIndexer.processEntityDeletion(entity, idAsString, (String)keyspaceWithColon);
        }
        super.delete(entity);
    }

    public void deleteById(ID id) {
        Optional entity;
        Assert.notNull(id, (String)"The given id must not be null");
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(this.metadata.getJavaType());
        if (lexicographicFields != null && !lexicographicFields.isEmpty() && (entity = this.findById(id)).isPresent()) {
            this.delete(entity.get());
            return;
        }
        super.deleteById(id);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        entities.forEach(this::delete);
    }

    public byte[] createKey(String keyspace, String id) {
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(keyspace);
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            id = filter.filter(id);
        }
        return this.mappingConverter.toBytes(keyspace.endsWith(":") ? keyspace + id : keyspace + ":" + id);
    }

    private boolean expires(RedisData data) {
        return data.getTimeToLive() != null && data.getTimeToLive() > 0L;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Iterable<S> result = this.findAll(example);
        int size = Iterables.size(result);
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("Query returned non unique result", 1);
        }
        return StreamSupport.stream(result.spliterator(), false).findFirst();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).collect(Collectors.toList());
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.entityStream.of(example.getProbeType()).filter(example).sorted(sort).collect(Collectors.toList());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        SearchStream<S> stream = this.entityStream.of(example.getProbeType());
        int offset = pageable.getPageNumber() * pageable.getPageSize();
        int limit = pageable.getPageSize();
        Page page = stream.filter(example).loadAll().limit(limit, Math.toIntExact(offset)).toList(pageable, stream.getEntityClass());
        return page;
    }

    public <S extends T> long count(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).count();
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new RedisFluentQueryByExample(example, example.getProbeType(), this.entityStream, this.getSearchOps(), this.mappingConverter.getMappingContext()));
    }

    private void executePipelinedUpdates(List<UpdateOperation> updateOperations) {
        try (Jedis jedis = this.modulesOperations.client().getJedis().get();){
            Pipeline pipeline = jedis.pipelined();
            HashMap<String, Map> updates = new HashMap<String, Map>();
            for (UpdateOperation updateOperation : updateOperations) {
                byte[] value = this.convertToBinary(updateOperation.field, updateOperation.value);
                if (value == null || value.length <= 0) continue;
                updates.computeIfAbsent(updateOperation.key, k -> new HashMap()).put(SafeEncoder.encode((String)updateOperation.field.getSearchAlias()), value);
            }
            for (Map.Entry entry : updates.entrySet()) {
                if (((Map)entry.getValue()).isEmpty()) continue;
                pipeline.hmset(SafeEncoder.encode((String)((String)entry.getKey())), (Map)entry.getValue());
            }
            pipeline.sync();
        }
    }

    private byte[] convertToBinary(MetamodelField<?, ?> field, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return SafeEncoder.encode((String)((String)value));
        }
        RedisData redisData = new RedisData();
        this.mappingConverter.write(value, redisData);
        byte[] binaryValue = redisData.getBucket().get(field.getSearchAlias());
        return binaryValue != null && binaryValue.length > 0 ? binaryValue : null;
    }

    private SearchOperations<String> getSearchOps() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        String searchIndex = this.indexer.getIndexName(keyspace);
        return this.modulesOperations.opsForSearch(searchIndex);
    }

    private String validateKeyForWriting(Object id, Object item) {
        RedisEnhancedPersistentEntity entity = (RedisEnhancedPersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(item.getClass());
        if (entity.isIdClassComposite()) {
            DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(item);
            ArrayList<String> idParts = new ArrayList<String>();
            for (RedisPersistentProperty idProperty : entity.getIdProperties()) {
                Object propertyValue = wrapper.getPropertyValue(idProperty.getName());
                if (propertyValue == null) continue;
                idParts.add(propertyValue.toString());
            }
            return String.join((CharSequence)":", idParts);
        }
        return (String)this.mappingConverter.getConversionService().convert(id, String.class);
    }

    private static /* synthetic */ Object lambda$getFieldsByIds$2(RedisTemplate template, MetamodelField field, String key) {
        return template.opsForHash().get((Object)key, (Object)field.getSearchAlias());
    }
}

