/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.redis.om.spring.annotations.Dialect;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.MetamodelUtils;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;

public class RedisFluentQueryByExample<T, S extends T, R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Example<S> example;
    private final Sort sort;
    private final Class<?> domainType;
    private final Class<R> resultType;
    private final SearchOperations<String> searchOps;
    private final SearchStream<R> searchStream;
    private SearchStream<?> parentSearchStream;
    private final EntityStream entityStream;
    private boolean isProjection = false;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final RedisMappingContext mappingContext;
    private final EntityInstantiators entityInstantiators = new EntityInstantiators();
    private Function<Object, R> conversionFunction;

    public RedisFluentQueryByExample(Example<S> example, Class<R> resultType, EntityStream entityStream, SearchOperations<String> searchOps, RedisMappingContext mappingContext) {
        this(example, Sort.unsorted(), resultType, resultType, entityStream, searchOps, mappingContext);
    }

    public RedisFluentQueryByExample(Example<S> example, Sort sort, Class<?> domainType, Class<R> resultType, EntityStream entityStream, SearchOperations<String> searchOps, SearchStream<?> searchStream, RedisMappingContext mappingContext) {
        this.example = example;
        this.sort = sort;
        this.domainType = domainType;
        this.resultType = resultType;
        this.entityStream = entityStream;
        this.searchOps = searchOps;
        this.searchStream = null;
        this.parentSearchStream = searchStream;
        this.isProjection = true;
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.mappingContext = mappingContext;
        this.conversionFunction = this.getConversionFunction(domainType, resultType);
    }

    public RedisFluentQueryByExample(Example<S> example, Sort sort, Class<?> domainType, Class<R> resultType, EntityStream entityStream, SearchOperations<String> searchOps, RedisMappingContext mappingContext) {
        this.example = example;
        this.sort = sort;
        this.domainType = domainType;
        this.resultType = resultType;
        this.entityStream = entityStream;
        this.searchOps = searchOps;
        this.searchStream = entityStream.of(resultType);
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.mappingContext = mappingContext;
        this.searchStream.dialect(Dialect.TWO.getValue());
        this.searchStream.filter(example);
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        this.searchStream.sorted(sort);
        return this;
    }

    public <R1> FluentQuery.FetchableFluentQuery<R1> as(Class<R1> resultType) {
        return new RedisFluentQueryByExample<T, S, R1>(this.example, this.sort, this.domainType, resultType, this.entityStream, this.searchOps, this.searchStream, this.mappingContext);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        List<MetamodelField<?, ?>> metamodelFields = MetamodelUtils.getMetamodelFieldsForProperties(this.resultType, properties);
        metamodelFields.forEach(mmf -> this.searchStream.project(mmf));
        return this;
    }

    @Nullable
    public R oneValue() {
        Iterator iterator = !this.isProjection ? this.searchStream.iterator() : this.parentSearchStream.iterator();
        Object result = null;
        if (iterator.hasNext()) {
            result = iterator.next();
            if (iterator.hasNext()) {
                throw new IncorrectResultSizeDataAccessException("Query returned non unique result", 1);
            }
        }
        return (R)(!this.isProjection ? result : (Object)this.conversionFunction.apply(result));
    }

    @Nullable
    public R firstValue() {
        Object result = !this.isProjection ? this.searchStream.findFirst().orElse(null) : this.parentSearchStream.findFirst().orElse(null);
        return (R)(!this.isProjection ? result : (Object)this.conversionFunction.apply(result));
    }

    public List<R> all() {
        if (!this.isProjection) {
            return this.searchStream.collect(Collectors.toList());
        }
        return this.parentSearchStream.collect(Collectors.toList()).stream().map(this.conversionFunction).toList();
    }

    public Page<R> page(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        long count = -1L;
        if (!this.searchStream.backingQuery().isBlank()) {
            Query query = new Query(this.searchStream.backingQuery());
            query.dialect(Dialect.TWO.getValue());
            query.limit(Integer.valueOf(0), Integer.valueOf(0));
            SearchResult searchResult = this.searchOps.search(query);
            count = searchResult.getTotalResults();
        } else {
            Map<String, Object> info = this.searchOps.getInfo();
            count = (Long)info.get("num_docs");
        }
        List pageContents = this.searchStream.limit(pageable.getPageSize()).skip(pageable.getOffset()).collect(Collectors.toList());
        return new PageImpl(pageContents, pageable, count);
    }

    public Stream<R> stream() {
        return this.all().stream();
    }

    public long count() {
        return this.searchStream.count();
    }

    public boolean exists() {
        return this.count() > 0L;
    }

    private <P> Function<Object, P> getConversionFunction(Class<?> inputType, Class<P> targetType) {
        if (targetType.isAssignableFrom(inputType)) {
            return Function.identity();
        }
        if (targetType.isInterface()) {
            return o -> this.projectionFactory.createProjection(targetType, o);
        }
        DtoInstantiatingConverter converter = new DtoInstantiatingConverter(targetType, (MappingContext)this.mappingContext, this.entityInstantiators);
        return o -> converter.convert(o);
    }
}

