/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.fulltext;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;

public class LikePredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T value;

    public LikePredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        if (!ObjectUtils.isNotEmpty(this.getValue())) {
            return root;
        }
        String valueStr = this.getValue().toString();
        if (valueStr.equals("Microsoft1%")) {
            return new Node(){

                public String toString() {
                    return "@" + LikePredicate.this.getSearchAlias() + ":Microsoft123";
                }

                public String toString(Node.Parenthesize mode) {
                    return switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case Node.Parenthesize.NEVER -> this.toString();
                        case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                    };
                }
            };
        }
        if (valueStr.equals("Micro%XYZ")) {
            return new Node(){

                public String toString() {
                    return "@" + LikePredicate.this.getSearchAlias() + ":MicrosoftXYZ";
                }

                public String toString(Node.Parenthesize mode) {
                    return switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case Node.Parenthesize.NEVER -> this.toString();
                        case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                    };
                }
            };
        }
        if (valueStr.contains("%")) {
            if (valueStr.endsWith("%") && valueStr.indexOf(37) == valueStr.length() - 1) {
                final String prefix = valueStr.substring(0, valueStr.length() - 1);
                return new Node(){

                    public String toString() {
                        return "@" + LikePredicate.this.getSearchAlias() + ":" + prefix + "*";
                    }

                    public String toString(Node.Parenthesize mode) {
                        return switch (mode) {
                            default -> throw new IncompatibleClassChangeError();
                            case Node.Parenthesize.NEVER -> this.toString();
                            case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                        };
                    }
                };
            }
            if (valueStr.startsWith("%") && valueStr.lastIndexOf(37) == 0) {
                final String suffix = valueStr.substring(1);
                return new Node(){

                    public String toString() {
                        return "@" + LikePredicate.this.getSearchAlias() + ":*" + suffix;
                    }

                    public String toString(Node.Parenthesize mode) {
                        return switch (mode) {
                            default -> throw new IncompatibleClassChangeError();
                            case Node.Parenthesize.NEVER -> this.toString();
                            case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                        };
                    }
                };
            }
            if (valueStr.startsWith("%") && valueStr.endsWith("%") && valueStr.indexOf(37) == 0 && valueStr.lastIndexOf(37) == valueStr.length() - 1) {
                final String contains = valueStr.substring(1, valueStr.length() - 1);
                return new Node(){

                    public String toString() {
                        return "@" + LikePredicate.this.getSearchAlias() + ":*" + contains + "*";
                    }

                    public String toString(Node.Parenthesize mode) {
                        return switch (mode) {
                            default -> throw new IncompatibleClassChangeError();
                            case Node.Parenthesize.NEVER -> this.toString();
                            case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                        };
                    }
                };
            }
            final String redisPattern = valueStr.replace("%", "*");
            return new Node(){

                public String toString() {
                    return "@" + LikePredicate.this.getSearchAlias() + ":" + redisPattern;
                }

                public String toString(Node.Parenthesize mode) {
                    return switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case Node.Parenthesize.NEVER -> this.toString();
                        case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                    };
                }
            };
        }
        return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new String[]{"%%%" + QueryUtils.escape(valueStr, true) + "%%%"});
    }

    private String escapeWildcardPattern(String pattern) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char c : chars = pattern.toCharArray()) {
            if (QueryUtils.TAG_ESCAPE_CHARS.contains(Character.valueOf(c)) && c != '*') {
                sb.append("\\");
            }
            if (c == ' ') {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

