/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.lexicographic;

import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.redis.connection.RedisZSetCommands;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;

public class LexicographicBetweenPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T min;
    private final T max;
    private final RedisModulesOperations<String> rmo;
    private final RediSearchIndexer indexer;

    public LexicographicBetweenPredicate(SearchFieldAccessor field, T min, T max, RedisModulesOperations<String> rmo, RediSearchIndexer indexer) {
        super(field);
        this.min = min;
        this.max = max;
        this.rmo = rmo;
        this.indexer = indexer;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getMin()) || ObjectUtils.isEmpty(this.getMax())) {
            return root;
        }
        Class<?> entityClass = this.getSearchFieldAccessor().getDeclaringClass();
        String fieldName = this.getSearchFieldAccessor().getField().getName();
        String entityPrefix = this.indexer.getKeyspaceForEntityClass(entityClass);
        if (entityPrefix == null) {
            return root;
        }
        String sortedSetKey = entityPrefix + fieldName + ":lex";
        String minParam = this.min.toString() + "#";
        String maxParam = this.max.toString() + "\uffff";
        Set matches = this.rmo.template().opsForZSet().rangeByLex((Object)sortedSetKey, RedisZSetCommands.Range.range().gte((Object)minParam).lte((Object)maxParam), RedisZSetCommands.Limit.unlimited());
        if (matches == null || matches.isEmpty()) {
            if (root == null || root.toString().isEmpty()) {
                return QueryBuilders.intersect((Node[])new Node[0]).add("id", new String[]{"{__NOMATCH__}"});
            }
            return QueryBuilders.intersect((Node[])new Node[]{root}).add("id", new String[]{"{__NOMATCH__}"});
        }
        Set entityIds = matches.stream().map(match -> {
            int hashIndex = match.lastIndexOf(35);
            return hashIndex >= 0 ? match.substring(hashIndex + 1) : null;
        }).filter(id -> id != null).collect(Collectors.toSet());
        if (entityIds.isEmpty()) {
            if (root == null || root.toString().isEmpty()) {
                return QueryBuilders.intersect((Node[])new Node[0]).add("id", new String[]{"{__NOMATCH__}"});
            }
            return QueryBuilders.intersect((Node[])new Node[]{root}).add("id", new String[]{"{__NOMATCH__}"});
        }
        String idQuery = entityIds.stream().collect(Collectors.joining(" | "));
        if (root == null || root.toString().isEmpty()) {
            return QueryBuilders.intersect((Node[])new Node[0]).add("id", new String[]{"{" + idQuery + "}"});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root}).add("id", new String[]{"{" + idQuery + "}"});
    }
}

