/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.search.stream.predicates.jedis.JedisValues;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class BetweenPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T min;
    private final T max;

    public BetweenPredicate(SearchFieldAccessor field, T min, T max) {
        super(field);
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public Node apply(Node root) {
        boolean paramsPresent;
        boolean bl = paramsPresent = ObjectUtils.isNotEmpty(this.getMin()) && ObjectUtils.isNotEmpty(this.getMax());
        if (!paramsPresent) {
            return root;
        }
        Class<?> cls = this.min.getClass();
        if (cls == LocalDate.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.between((LocalDate)this.min, (LocalDate)this.max)});
        }
        if (cls == Date.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.between((Date)this.min, (Date)this.max)});
        }
        if (cls == LocalDateTime.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.between((LocalDateTime)this.min, (LocalDateTime)this.max)});
        }
        if (cls == Instant.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.between((Instant)this.min, (Instant)this.max)});
        }
        if (cls == Integer.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((int)Integer.parseInt(this.getMin().toString()), (int)Integer.parseInt(this.getMax().toString()))});
        }
        if (cls == Long.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)Long.parseLong(this.getMin().toString()), (double)Long.parseLong(this.getMax().toString()))});
        }
        if (cls == Double.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)Double.parseDouble(this.getMin().toString()), (double)Double.parseDouble(this.getMax().toString()))});
        }
        if (cls == BigDecimal.class) {
            BigDecimal min = (BigDecimal)this.getMin();
            BigDecimal max = (BigDecimal)this.getMax();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)min.doubleValue(), (double)max.doubleValue())});
        }
        return root;
    }
}

