/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.StringTokenizer;
import org.springframework.data.geo.Point;

public class PointTypeAdapter
implements JsonSerializer<Point>,
JsonDeserializer<Point> {
    public static PointTypeAdapter getInstance() {
        return new PointTypeAdapter();
    }

    public JsonElement serialize(Point src, Type typeOfSrc, JsonSerializationContext context) {
        String lonlat = src.getX() + "," + src.getY();
        return new JsonPrimitive(lonlat);
    }

    public Point deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String lat;
        String lon;
        if (json.isJsonArray()) {
            JsonArray latlon = json.getAsJsonArray();
            lon = latlon.get(0).getAsString();
            lat = latlon.get(1).getAsString();
        } else {
            String latlon = json.getAsString();
            StringTokenizer st = new StringTokenizer(latlon, ",");
            lon = st.nextToken();
            lat = st.nextToken();
        }
        return new Point(Double.parseDouble(lon), Double.parseDouble(lat));
    }
}

