/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthTypeAdapter
implements JsonSerializer<YearMonth>,
JsonDeserializer<YearMonth> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");

    public static YearMonthTypeAdapter getInstance() {
        return new YearMonthTypeAdapter();
    }

    public JsonElement serialize(YearMonth yearMonth, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(yearMonth.format(this.formatter));
    }

    public YearMonth deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return YearMonth.parse(json.getAsString(), this.formatter);
    }
}

