/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.util;

import com.google.gson.Gson;
import com.redis.om.spring.util.ObjectUtils;
import java.util.Date;
import java.util.StringTokenizer;
import org.springframework.data.geo.Point;
import redis.clients.jedis.util.SafeEncoder;

public class SearchResultRawResponseToObjectConverter {
    private SearchResultRawResponseToObjectConverter() {
    }

    public static Object process(Object rawValue, Class<?> targetClass, Gson gson) {
        String value = rawValue != null ? SafeEncoder.encode((byte[])((byte[])rawValue)) : null;
        Object processValue = null;
        if (value != null) {
            if (targetClass == Date.class) {
                processValue = new Date(Long.parseLong(value.toString()));
            } else if (targetClass == Point.class) {
                StringTokenizer st = new StringTokenizer(value.toString(), ",");
                String lon = st.nextToken();
                String lat = st.nextToken();
                processValue = new Point(Double.parseDouble(lon), Double.parseDouble(lat));
            } else {
                processValue = targetClass == String.class ? value.toString() : (targetClass == Boolean.class || ObjectUtils.isPrimitiveOfType(targetClass, Boolean.class) ? Boolean.valueOf(value.toString().equals("1")) : gson.fromJson(value.toString(), targetClass));
            }
        }
        return processValue;
    }
}

