/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.github.f4b6a3.ulid.Ulid;
import com.google.gson.ExclusionStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.redis.om.spring.CustomRedisKeyValueTemplate;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.RedisJSONKeyValueAdapter;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.annotations.Bloom;
import com.redis.om.spring.annotations.Cuckoo;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.mapping.RedisEnhancedMappingContext;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.pds.BloomOperations;
import com.redis.om.spring.ops.pds.CountMinSketchOperations;
import com.redis.om.spring.ops.pds.CuckooFilterOperations;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.serialization.gson.DateTypeAdapter;
import com.redis.om.spring.serialization.gson.GsonReferenceSerializerRegistrar;
import com.redis.om.spring.serialization.gson.GsonReferencesSerializationExclusionStrategy;
import com.redis.om.spring.serialization.gson.InstantTypeAdapter;
import com.redis.om.spring.serialization.gson.LocalDateTimeTypeAdapter;
import com.redis.om.spring.serialization.gson.LocalDateTypeAdapter;
import com.redis.om.spring.serialization.gson.MapBooleanTypeAdapterFactory;
import com.redis.om.spring.serialization.gson.OffsetDateTimeTypeAdapter;
import com.redis.om.spring.serialization.gson.PointTypeAdapter;
import com.redis.om.spring.serialization.gson.UlidTypeAdapter;
import com.redis.om.spring.serialization.gson.YearMonthTypeAdapter;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import com.redis.om.spring.vectorize.NoopEmbedder;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.gson.GsonBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.Nullable;
import redis.clients.jedis.bloom.CFReserveParams;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class, RedisOMProperties.class})
@EnableAspectJAutoProxy
@ComponentScans(value={@ComponentScan(value={"com.redis.om.spring.bloom"}), @ComponentScan(value={"com.redis.om.spring.cuckoo"}), @ComponentScan(value={"com.redis.om.spring.autocomplete"}), @ComponentScan(value={"com.redis.om.spring.metamodel"}), @ComponentScan(value={"com.redis.om.spring.util"})})
public class RedisModulesConfiguration {
    private static final Log logger = LogFactory.getLog(RedisModulesConfiguration.class);

    @Bean(name={"redisEnhancedMappingContext"})
    @Primary
    @ConditionalOnMissingBean(name={"redisEnhancedMappingContext"})
    public RedisEnhancedMappingContext redisMappingContext() {
        return new RedisEnhancedMappingContext();
    }

    @Bean(name={"omGsonBuilder"})
    public GsonBuilder gsonBuilder(List<GsonBuilderCustomizer> customizers) {
        GsonBuilder builder = new GsonBuilder();
        customizers.forEach(c -> c.customize(builder));
        builder.registerTypeAdapter(Point.class, (Object)PointTypeAdapter.getInstance());
        builder.registerTypeAdapter(Date.class, (Object)DateTypeAdapter.getInstance());
        builder.registerTypeAdapter(LocalDate.class, (Object)LocalDateTypeAdapter.getInstance());
        builder.registerTypeAdapter(LocalDateTime.class, (Object)LocalDateTimeTypeAdapter.getInstance());
        builder.registerTypeAdapter(Ulid.class, (Object)UlidTypeAdapter.getInstance());
        builder.registerTypeAdapter(Instant.class, (Object)InstantTypeAdapter.getInstance());
        builder.registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter());
        builder.registerTypeAdapter(YearMonth.class, (Object)new YearMonthTypeAdapter());
        builder.addSerializationExclusionStrategy((ExclusionStrategy)GsonReferencesSerializationExclusionStrategy.INSTANCE);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)MapBooleanTypeAdapterFactory.getInstance());
        return builder;
    }

    @Bean(name={"redisModulesClient"})
    @Lazy
    RedisModulesClient redisModulesClient(JedisConnectionFactory jedisConnectionFactory, @Qualifier(value="omGsonBuilder") GsonBuilder builder) {
        return new RedisModulesClient(jedisConnectionFactory, builder);
    }

    @Bean(name={"redisModulesOperations"})
    @Primary
    @ConditionalOnMissingBean
    @Lazy
    RedisModulesOperations<?> redisModulesOperations(RedisModulesClient rmc, StringRedisTemplate template, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder) {
        return new RedisModulesOperations(rmc, template, gsonBuilder);
    }

    @Bean(name={"redisJSONOperations"})
    JSONOperations<?> redisJSONOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForJSON();
    }

    @Bean(name={"redisBloomOperations"})
    BloomOperations<?> redisBloomOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForBloom();
    }

    @Bean(name={"redisCuckooOperations"})
    CuckooFilterOperations<?> redisCuckooFilterOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForCuckoFilter();
    }

    @Bean(name={"redisCountminOperations"})
    CountMinSketchOperations<?> redisCountMinOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForCountMinSketch();
    }

    @Bean(name={"redisOmTemplate"})
    @Primary
    public RedisTemplate<?, ?> redisTemplate(JedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setDefaultSerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory((RedisConnectionFactory)connectionFactory);
        return template;
    }

    @Bean(name={"rediSearchIndexer"})
    public RediSearchIndexer redisearchIndexer(ApplicationContext ac, RedisOMProperties properties, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder) {
        return new RediSearchIndexer(ac, properties, gsonBuilder);
    }

    @Bean(name={"redisJSONKeyValueAdapter"})
    RedisJSONKeyValueAdapter getRedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, @Qualifier(value="redisEnhancedMappingContext") RedisMappingContext mappingContext, RediSearchIndexer indexer, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder, RedisOMProperties properties, @Nullable @Qualifier(value="featureExtractor") Embedder embedder) {
        return new RedisJSONKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, gsonBuilder, embedder, properties);
    }

    @Bean(name={"redisJSONKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getRedisJSONKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, @Qualifier(value="redisEnhancedMappingContext") RedisMappingContext mappingContext, RediSearchIndexer indexer, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder, RedisOMProperties properties, @Nullable @Qualifier(value="featureExtractor") Embedder embedder) {
        return new CustomRedisKeyValueTemplate(new RedisJSONKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, gsonBuilder, embedder, properties), mappingContext);
    }

    @Bean(name={"redisCustomKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, @Qualifier(value="redisEnhancedMappingContext") RedisMappingContext mappingContext, RediSearchIndexer indexer, RedisOMProperties properties, @Nullable @Qualifier(value="featureExtractor") Embedder embedder) {
        return new CustomRedisKeyValueTemplate(new RedisEnhancedKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, embedder, properties), mappingContext);
    }

    @Bean(name={"streamingQueryBuilder"})
    EntityStream streamingQueryBuilder(RedisModulesOperations<?> redisModulesOperations, @Qualifier(value="omGsonBuilder") GsonBuilder gsonBuilder, RediSearchIndexer indexer) {
        return new EntityStreamImpl(redisModulesOperations, gsonBuilder, indexer);
    }

    @Bean(name={"redisOMCacheManager"})
    public CacheManager getCacheManager() {
        return new ConcurrentMapCacheManager();
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void ensureIndexesAreCreated(ContextRefreshedEvent cre) {
        logger.info((Object)"Creating Indexes......");
        ApplicationContext ac = cre.getApplicationContext();
        RediSearchIndexer indexer = (RediSearchIndexer)ac.getBean("rediSearchIndexer");
        indexer.createIndicesFor(Document.class);
        indexer.createIndicesFor(RedisHash.class);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void processBloom(ContextRefreshedEvent cre) {
        ApplicationContext ac = cre.getApplicationContext();
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        Set<BeanDefinition> beanDefs = ObjectUtils.getBeanDefinitionsFor(ac, Document.class, RedisHash.class);
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                for (Field field : ObjectUtils.getDeclaredFieldsTransitively(cl)) {
                    if (!field.isAnnotationPresent(Bloom.class)) continue;
                    Bloom bloom = field.getAnnotation(Bloom.class);
                    BloomOperations<String> ops = rmo.opsForBloom();
                    String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bloom.name()) ? bloom.name() : String.format("bf:%s:%s", cl.getSimpleName(), field.getName());
                    ops.createFilter(filterName, bloom.capacity(), bloom.errorRate());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Error during processing of @Bloom annotation: ", (Throwable)e);
            }
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void processCuckoo(ContextRefreshedEvent cre) {
        ApplicationContext ac = cre.getApplicationContext();
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        Set<BeanDefinition> beanDefs = ObjectUtils.getBeanDefinitionsFor(ac, Document.class, RedisHash.class);
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                for (Field field : ObjectUtils.getDeclaredFieldsTransitively(cl)) {
                    if (!field.isAnnotationPresent(Cuckoo.class)) continue;
                    Cuckoo cuckoo = field.getAnnotation(Cuckoo.class);
                    CuckooFilterOperations ops = rmo.opsForCuckoFilter();
                    String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)cuckoo.name()) ? cuckoo.name() : String.format("cf:%s:%s", cl.getSimpleName(), field.getName());
                    CFReserveParams params = CFReserveParams.reserveParams().bucketSize((long)cuckoo.bucketSize()).expansion(cuckoo.expansion()).maxIterations(cuckoo.maxIterations());
                    ops.createFilter(filterName, cuckoo.capacity(), params);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Error during processing of @Cuckoo annotation: ", (Throwable)e);
            }
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void registerReferenceSerializer(ContextRefreshedEvent cre) {
        logger.info((Object)"Registering Reference Serializers......");
        ApplicationContext ac = cre.getApplicationContext();
        GsonBuilder gsonBuilder = (GsonBuilder)ac.getBean("omGsonBuilder");
        GsonReferenceSerializerRegistrar registrar = new GsonReferenceSerializerRegistrar(gsonBuilder, ac);
        registrar.registerReferencesFor(Document.class);
        registrar.registerReferencesFor(RedisHash.class);
    }

    @ConditionalOnProperty(name={"redis.om.spring.ai.enabled"}, havingValue="false", matchIfMissing=true)
    @Bean(name={"featureExtractor"})
    public Embedder featureExtractor() {
        return new NoopEmbedder();
    }
}

