/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.geo.Metrics;

@ConfigurationProperties(prefix="redis.om.spring", ignoreInvalidFields=true)
public class RedisOMProperties {
    public static final String ROMS_VERSION = "1.0.0-RC.1";
    public static final int MAX_SEARCH_RESULTS = 10000;
    public static final double DEFAULT_DISTANCE = 5.0E-4;
    public static final Metrics DEFAULT_DISTANCE_METRIC = Metrics.MILES;
    private final Repository repository = new Repository();
    private final References references = new References();
    private final Authentication authentication = new Authentication();

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public References getReferences() {
        return this.references;
    }

    public static class Repository {
        private final Query query = new Query();
        private boolean dropAndRecreateIndexOnDeleteAll = false;
        private int deleteBatchSize = 500;
        private boolean throwOnSaveAllFailure = false;

        public Query getQuery() {
            return this.query;
        }

        public boolean isDropAndRecreateIndexOnDeleteAll() {
            return this.dropAndRecreateIndexOnDeleteAll;
        }

        public void setDropAndRecreateIndexOnDeleteAll(boolean dropAndRecreateIndexOnDeleteAll) {
            this.dropAndRecreateIndexOnDeleteAll = dropAndRecreateIndexOnDeleteAll;
        }

        public int getDeleteBatchSize() {
            return this.deleteBatchSize;
        }

        public void setDeleteBatchSize(int deleteBatchSize) {
            this.deleteBatchSize = deleteBatchSize;
        }

        public boolean isThrowOnSaveAllFailure() {
            return this.throwOnSaveAllFailure;
        }

        public void setThrowOnSaveAllFailure(boolean throwOnSaveAllFailure) {
            this.throwOnSaveAllFailure = throwOnSaveAllFailure;
        }

        public static class Query {
            private int limit = 10000;
            private double defaultDistance = 5.0E-4;
            private Metrics defaultDistanceMetric = DEFAULT_DISTANCE_METRIC;

            public int getLimit() {
                return this.limit;
            }

            public void setLimit(int limit) {
                this.limit = limit;
            }

            public double getDefaultDistance() {
                return this.defaultDistance;
            }

            public void setDefaultDistance(double defaultDistance) {
                this.defaultDistance = defaultDistance;
            }

            public Metrics getDefaultDistanceMetrics() {
                return this.defaultDistanceMetric;
            }

            public void setDefaultDistanceMetric(Metrics defaultDistanceMetric) {
                this.defaultDistanceMetric = defaultDistanceMetric;
            }
        }
    }

    public static class References {
        private String cacheName = "roms-reference-cache";
        private List<String> cachedReferenceClasses = new ArrayList<String>();

        public String getCacheName() {
            return this.cacheName;
        }

        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        public List<String> getCachedReferenceClasses() {
            return this.cachedReferenceClasses;
        }

        public void setCachedReferenceClasses(List<String> cachedReferenceClasses) {
            this.cachedReferenceClasses = cachedReferenceClasses;
        }
    }

    public static class Authentication {
        private EntraId entraId = new EntraId();

        public EntraId getEntraId() {
            return this.entraId;
        }

        public void setEntraId(EntraId entraId) {
            this.entraId = entraId;
        }
    }

    public static class EntraId {
        private boolean enabled = false;
        private String tenantId;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }
    }
}

