/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.indexing;

import com.redis.om.spring.indexing.RediSearchIndexer;
import java.lang.reflect.Field;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ReflectionUtils;

public class LexicographicIndexer {
    private static final Log logger = LogFactory.getLog(LexicographicIndexer.class);
    private final RedisTemplate<String, String> redisTemplate;
    private final RediSearchIndexer indexer;

    public LexicographicIndexer(RedisTemplate<String, String> redisTemplate, RediSearchIndexer indexer) {
        this.redisTemplate = redisTemplate;
        this.indexer = indexer;
    }

    public void processEntity(Object entity, String entityId, boolean isNew, String entityPrefix) {
        Class<?> entityClass = entity.getClass();
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(entityClass);
        logger.debug((Object)String.format("Processing entity %s with ID %s, isNew=%s, entityPrefix=%s", entityClass.getSimpleName(), entityId, isNew, entityPrefix));
        logger.debug((Object)String.format("Lexicographic fields: %s", lexicographicFields));
        if (lexicographicFields == null || lexicographicFields.isEmpty()) {
            logger.debug((Object)"No lexicographic fields found, skipping processing");
            return;
        }
        for (String fieldName : lexicographicFields) {
            Field field = ReflectionUtils.findField(entityClass, (String)fieldName);
            if (field == null) {
                logger.warn((Object)String.format("Lexicographic field %s not found on class %s", fieldName, entityClass.getName()));
                continue;
            }
            field.setAccessible(true);
            Object fieldValue = ReflectionUtils.getField((Field)field, (Object)entity);
            if (fieldValue == null) continue;
            String sortedSetKey = entityPrefix + fieldName + ":lex";
            String member = fieldValue.toString() + "#" + entityId;
            logger.debug((Object)String.format("Processing field %s, value=%s, member=%s, isNew=%s", fieldName, fieldValue, member, isNew));
            if (!isNew) {
                this.removeOldEntry(sortedSetKey, entityId);
            }
            Boolean added = this.redisTemplate.opsForZSet().add((Object)sortedSetKey, (Object)member, 0.0);
            logger.debug((Object)String.format("Added entry %s to sorted set %s (result: %s)", member, sortedSetKey, added));
        }
    }

    public void processEntityDeletion(Object entity, String entityId, String entityPrefix) {
        Class<?> entityClass = entity.getClass();
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(entityClass);
        if (lexicographicFields == null || lexicographicFields.isEmpty()) {
            return;
        }
        for (String fieldName : lexicographicFields) {
            String sortedSetKey = entityPrefix + fieldName + ":lex";
            this.removeOldEntry(sortedSetKey, entityId);
        }
    }

    public void processEntityDeletionById(Class<?> entityClass, String entityId, String entityPrefix) {
        Set<String> lexicographicFields = this.indexer.getLexicographicFields(entityClass);
        if (lexicographicFields == null || lexicographicFields.isEmpty()) {
            return;
        }
        for (String fieldName : lexicographicFields) {
            String sortedSetKey = entityPrefix + fieldName + ":lex";
            this.removeOldEntry(sortedSetKey, entityId);
        }
    }

    private void removeOldEntry(String sortedSetKey, String entityId) {
        Set members = this.redisTemplate.opsForZSet().range((Object)sortedSetKey, 0L, -1L);
        logger.debug((Object)String.format("Removing old entries for entityId %s from %s", entityId, sortedSetKey));
        logger.debug((Object)String.format("Current members: %s", members));
        if (members != null) {
            String suffix = "#" + entityId;
            logger.debug((Object)String.format("Looking for entries ending with: %s", suffix));
            for (String member : members) {
                if (!member.endsWith(suffix)) continue;
                Long removed = this.redisTemplate.opsForZSet().remove((Object)sortedSetKey, new Object[]{member});
                logger.debug((Object)String.format("Removed entry %s from sorted set %s (result: %s)", member, sortedSetKey, removed));
            }
        }
    }
}

