/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;

public class ClassLoaderAwareKeyspaceResolver {
    private final KeyspaceConfiguration keyspaceConfiguration;
    private final Map<String, KeyspaceConfiguration.KeyspaceSettings> settingsByClassName = new ConcurrentHashMap<String, KeyspaceConfiguration.KeyspaceSettings>();

    public ClassLoaderAwareKeyspaceResolver(KeyspaceConfiguration keyspaceConfiguration) {
        this.keyspaceConfiguration = keyspaceConfiguration;
    }

    public void addKeyspaceSettings(Class<?> entityClass, KeyspaceConfiguration.KeyspaceSettings settings) {
        this.settingsByClassName.put(entityClass.getName(), settings);
        this.keyspaceConfiguration.addKeyspaceSettings(settings);
    }

    public boolean hasSettingsFor(Class<?> entityClass) {
        if (this.keyspaceConfiguration.hasSettingsFor(entityClass)) {
            return true;
        }
        return this.settingsByClassName.containsKey(entityClass.getName());
    }

    public KeyspaceConfiguration.KeyspaceSettings getKeyspaceSettings(Class<?> entityClass) {
        if (this.keyspaceConfiguration.hasSettingsFor(entityClass)) {
            return this.keyspaceConfiguration.getKeyspaceSettings(entityClass);
        }
        return this.settingsByClassName.get(entityClass.getName());
    }

    public KeyspaceConfiguration getKeyspaceConfiguration() {
        return this.keyspaceConfiguration;
    }
}

