/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query;

import com.github.f4b6a3.ulid.Ulid;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.annotations.Aggregation;
import com.redis.om.spring.annotations.Dialect;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.Query;
import com.redis.om.spring.annotations.SchemaFieldType;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.annotations.UseDialect;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.repository.query.RediSearchQueryType;
import com.redis.om.spring.repository.query.SearchLanguage;
import com.redis.om.spring.repository.query.autocomplete.AutoCompleteQueryExecutor;
import com.redis.om.spring.repository.query.bloom.BloomQueryExecutor;
import com.redis.om.spring.repository.query.clause.QueryClause;
import com.redis.om.spring.repository.query.countmin.CountMinQueryExecutor;
import com.redis.om.spring.repository.query.cuckoo.CuckooQueryExecutor;
import com.redis.om.spring.repository.query.lexicographic.LexicographicQueryExecutor;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Point;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Pair;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.aggr.Group;
import redis.clients.jedis.search.aggr.Reducer;
import redis.clients.jedis.search.aggr.Reducers;
import redis.clients.jedis.search.aggr.SortedField;
import redis.clients.jedis.util.SafeEncoder;

public class RediSearchQuery
implements RepositoryQuery {
    private static final Log logger = LogFactory.getLog(RediSearchQuery.class);
    private static final Set<QueryClause> LEXICOGRAPHIC_QUERY_CLAUSES = Set.of(QueryClause.TEXT_GREATER_THAN, QueryClause.TEXT_LESS_THAN, QueryClause.TEXT_GREATER_THAN_EQUAL, QueryClause.TEXT_LESS_THAN_EQUAL, QueryClause.TEXT_BETWEEN, QueryClause.TAG_GREATER_THAN, QueryClause.TAG_LESS_THAN, QueryClause.TAG_GREATER_THAN_EQUAL, QueryClause.TAG_LESS_THAN_EQUAL, QueryClause.TAG_BETWEEN);
    private static final Set<Part.Type> LEXICOGRAPHIC_PART_TYPES = Set.of(Part.Type.GREATER_THAN, Part.Type.LESS_THAN, Part.Type.GREATER_THAN_EQUAL, Part.Type.LESS_THAN_EQUAL, Part.Type.BETWEEN);
    private final QueryMethod queryMethod;
    private final RedisOMProperties redisOMProperties;
    private final boolean hasLanguageParameter;
    private final List<Map.Entry<String, String>> aggregationLoad = new ArrayList<Map.Entry<String, String>>();
    private final List<Map.Entry<String, String>> aggregationApply = new ArrayList<Map.Entry<String, String>>();
    private final List<Group> aggregationGroups = new ArrayList<Group>();
    private final List<SortedField> aggregationSortedFields = new ArrayList<SortedField>();
    private final List<List<Pair<String, QueryClause>>> queryOrParts = new ArrayList<List<Pair<String, QueryClause>>>();
    private final List<String> paramNames = new ArrayList<String>();
    private final Class<?> domainType;
    private final RedisModulesOperations<String> modulesOperations;
    private final boolean isANDQuery;
    private final BloomQueryExecutor bloomQueryExecutor;
    private final CuckooQueryExecutor cuckooQueryExecutor;
    private final CountMinQueryExecutor countMinQueryExecutor;
    private final AutoCompleteQueryExecutor autoCompleteQueryExecutor;
    private final LexicographicQueryExecutor lexicographicQueryExecutor;
    private final GsonBuilder gsonBuilder;
    private final RediSearchIndexer indexer;
    private RediSearchQueryType type;
    private String value;
    private String[] returnFields;
    private Integer offset;
    private Integer limit;
    private String sortBy;
    private Boolean sortAscending;
    private String[] aggregationFilter;
    private Integer aggregationSortByMax;
    private Long aggregationTimeout;
    private Boolean aggregationVerbatim;
    private Gson gson;
    private boolean isNullParamQuery;
    private boolean isMapContainsQuery;
    private Dialect dialect = Dialect.TWO;

    private static Schema.FieldType getRedisFieldType(Class<?> fieldType) {
        if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType == UUID.class || fieldType == Ulid.class || fieldType.isEnum()) {
            return Schema.FieldType.TAG;
        }
        if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || fieldType == LocalDate.class || fieldType == Date.class || fieldType == Instant.class || fieldType == OffsetDateTime.class) {
            return Schema.FieldType.NUMERIC;
        }
        if (fieldType == Point.class) {
            return Schema.FieldType.GEO;
        }
        return null;
    }

    private static Schema.FieldType getRedisFieldTypeForMapValue(Class<?> fieldType) {
        if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == UUID.class || fieldType == Ulid.class || fieldType.isEnum()) {
            return Schema.FieldType.TAG;
        }
        if (Number.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType == LocalDateTime.class || fieldType == LocalDate.class || fieldType == Date.class || fieldType == Instant.class || fieldType == OffsetDateTime.class) {
            return Schema.FieldType.NUMERIC;
        }
        if (fieldType == Point.class || "org.springframework.data.geo.Point".equals(fieldType.getName())) {
            return Schema.FieldType.GEO;
        }
        return null;
    }

    public RediSearchQuery(QueryMethod queryMethod, RepositoryMetadata metadata, RediSearchIndexer indexer, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, GsonBuilder gsonBuilder, RedisOMProperties redisOMProperties) {
        logger.info((Object)String.format("Creating %s query method", queryMethod.getName()));
        this.modulesOperations = rmo;
        this.indexer = indexer;
        this.queryMethod = queryMethod;
        this.domainType = this.queryMethod.getEntityInformation().getJavaType();
        this.gsonBuilder = gsonBuilder;
        this.redisOMProperties = redisOMProperties;
        this.bloomQueryExecutor = new BloomQueryExecutor(this, this.modulesOperations);
        this.cuckooQueryExecutor = new CuckooQueryExecutor(this, this.modulesOperations);
        this.countMinQueryExecutor = new CountMinQueryExecutor(this, this.modulesOperations);
        this.autoCompleteQueryExecutor = new AutoCompleteQueryExecutor(this, this.modulesOperations);
        this.lexicographicQueryExecutor = new LexicographicQueryExecutor(this, this.modulesOperations, indexer);
        Class repoClass = metadata.getRepositoryInterface();
        Object[] params = (Class[])queryMethod.getParameters().stream().map(Parameter::getType).toArray(Class[]::new);
        this.hasLanguageParameter = Arrays.stream(params).anyMatch(c -> c.isAssignableFrom(SearchLanguage.class));
        this.isANDQuery = QueryClause.hasContainingAllClause(queryMethod.getName());
        this.isMapContainsQuery = QueryClause.hasMapContainsClause(queryMethod.getName());
        String methodName = queryMethod.getName();
        if (this.isANDQuery) {
            methodName = QueryClause.getPostProcessMethodName(methodName);
        }
        if (this.isMapContainsQuery) {
            methodName = QueryClause.processMapContainsMethodName(methodName);
        }
        try {
            Method method = repoClass.getMethod(queryMethod.getName(), (Class<?>[])params);
            if (method.isAnnotationPresent(UseDialect.class)) {
                UseDialect dialectAnnotation = method.getAnnotation(UseDialect.class);
                this.dialect = dialectAnnotation.dialect();
            }
            if (method.isAnnotationPresent(Query.class)) {
                Query queryAnnotation = method.getAnnotation(Query.class);
                this.type = RediSearchQueryType.QUERY;
                this.value = queryAnnotation.value();
                this.returnFields = queryAnnotation.returnFields();
                this.offset = queryAnnotation.offset();
                this.limit = queryAnnotation.limit();
                this.sortBy = queryAnnotation.sortBy();
                this.sortAscending = queryAnnotation.sortAscending();
            } else if (method.isAnnotationPresent(Aggregation.class)) {
                Aggregation aggregation = method.getAnnotation(Aggregation.class);
                this.type = RediSearchQueryType.AGGREGATION;
                this.value = aggregation.value();
                Arrays.stream(aggregation.load()).forEach(load -> this.aggregationLoad.add(new AbstractMap.SimpleEntry<String, String>(load.property(), load.alias())));
                Arrays.stream(aggregation.apply()).forEach(apply -> this.aggregationApply.add(new AbstractMap.SimpleEntry<String, String>(apply.alias(), apply.expression())));
                this.aggregationFilter = aggregation.filter();
                this.aggregationTimeout = aggregation.timeout() > Long.MIN_VALUE ? Long.valueOf(aggregation.timeout()) : null;
                this.aggregationVerbatim = aggregation.verbatim() ? Boolean.valueOf(true) : null;
                this.aggregationSortByMax = aggregation.sortByMax() > Integer.MIN_VALUE ? Integer.valueOf(aggregation.sortByMax()) : null;
                this.limit = aggregation.limit() > Integer.MIN_VALUE ? Integer.valueOf(aggregation.limit()) : null;
                this.offset = aggregation.offset() > Integer.MIN_VALUE ? Integer.valueOf(aggregation.offset()) : null;
                Arrays.stream(aggregation.groupBy()).forEach(groupBy -> {
                    Group group = new Group(groupBy.properties());
                    Arrays.stream(groupBy.reduce()).forEach(reducer -> {
                        String alias = reducer.alias();
                        String arg0 = reducer.args().length > 0 ? reducer.args()[0] : null;
                        Reducer r = null;
                        switch (reducer.func()) {
                            case COUNT: {
                                r = Reducers.count();
                                break;
                            }
                            case COUNT_DISTINCT: {
                                r = Reducers.count_distinct((String)arg0);
                                break;
                            }
                            case COUNT_DISTINCTISH: {
                                r = Reducers.count_distinctish((String)arg0);
                                break;
                            }
                            case SUM: {
                                r = Reducers.sum((String)arg0);
                                break;
                            }
                            case MIN: {
                                r = Reducers.min((String)arg0);
                                break;
                            }
                            case MAX: {
                                r = Reducers.max((String)arg0);
                                break;
                            }
                            case AVG: {
                                r = Reducers.avg((String)arg0);
                                break;
                            }
                            case STDDEV: {
                                r = Reducers.stddev((String)arg0);
                                break;
                            }
                            case QUANTILE: {
                                double percentile = Double.parseDouble(reducer.args()[1]);
                                r = Reducers.quantile((String)arg0, (double)percentile);
                                break;
                            }
                            case TOLIST: {
                                r = Reducers.to_list((String)arg0);
                                break;
                            }
                            case FIRST_VALUE: {
                                if (reducer.args().length > 1) {
                                    String arg1 = reducer.args()[1];
                                    String arg2 = reducer.args().length > 2 ? reducer.args()[2] : null;
                                    SortedField.SortOrder order = arg2 != null && arg2.equalsIgnoreCase("ASC") ? SortedField.SortOrder.ASC : SortedField.SortOrder.DESC;
                                    SortedField sortedField = new SortedField(arg1, order);
                                    r = Reducers.first_value((String)arg0, (SortedField)sortedField);
                                    break;
                                }
                                r = Reducers.first_value((String)arg0);
                                break;
                            }
                            case RANDOM_SAMPLE: {
                                int sampleSize = Integer.parseInt(reducer.args()[1]);
                                r = Reducers.random_sample((String)arg0, (int)sampleSize);
                            }
                        }
                        if (r != null && alias != null && !alias.isBlank()) {
                            r.as(alias);
                        }
                        group.reduce(r);
                    });
                    this.aggregationGroups.add(group);
                });
                Arrays.stream(aggregation.sortBy()).forEach(sb -> {
                    SortedField sortedField = sb.direction().isAscending() ? SortedField.asc((String)sb.field()) : SortedField.desc((String)sb.field());
                    this.aggregationSortedFields.add(sortedField);
                });
            } else if (queryMethod.getName().equalsIgnoreCase("search")) {
                this.type = RediSearchQueryType.QUERY;
                ArrayList<Pair> orPartParts = new ArrayList<Pair>();
                orPartParts.add(Pair.of((Object)"__ALL__", (Object)((Object)QueryClause.TEXT_ALL)));
                this.queryOrParts.add(orPartParts);
                this.returnFields = new String[0];
            } else if (queryMethod.getName().startsWith("getAll")) {
                this.type = RediSearchQueryType.TAGVALS;
                this.value = ObjectUtils.toLowercaseFirstCharacter(queryMethod.getName().substring(6));
            } else if (queryMethod.getName().startsWith("autoComplete")) {
                this.type = RediSearchQueryType.AUTOCOMPLETE;
            } else {
                PartTree pt = new PartTree(methodName, metadata.getDomainType());
                ArrayList<String> nullParamNames = new ArrayList<String>();
                ArrayList<String> notNullParamNames = new ArrayList<String>();
                pt.getParts().forEach(part -> {
                    if (part.getType() == Part.Type.IS_NULL) {
                        nullParamNames.add(part.getProperty().getSegment());
                    } else if (part.getType() == Part.Type.IS_NOT_NULL) {
                        notNullParamNames.add(part.getProperty().getSegment());
                    }
                });
                this.isNullParamQuery = !nullParamNames.isEmpty() || !notNullParamNames.isEmpty();
                this.type = queryMethod.getName().matches("(?:remove|delete).*") ? RediSearchQueryType.DELETE : RediSearchQueryType.QUERY;
                this.returnFields = new String[0];
                this.processPartTree(pt, nullParamNames, notNullParamNames);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug((Object)String.format("Could not resolved query method %s(%s): %s", queryMethod.getName(), Arrays.toString(params), e.getMessage()));
        }
    }

    private void processPartTree(PartTree pt, List<String> nullParamNames, List<String> notNullParamNames) {
        pt.stream().forEach(orPart -> {
            ArrayList orPartParts = new ArrayList();
            orPart.iterator().forEachRemaining(part -> {
                PropertyPath propertyPath = part.getProperty();
                List<PropertyPath> path = StreamSupport.stream(propertyPath.spliterator(), false).toList();
                String paramName = ((PropertyPath)path.get(path.size() - 1)).getSegment();
                if (nullParamNames.contains(paramName)) {
                    orPartParts.add(Pair.of((Object)paramName, (Object)((Object)QueryClause.IS_NULL)));
                } else if (notNullParamNames.contains(paramName)) {
                    orPartParts.add(Pair.of((Object)paramName, (Object)((Object)QueryClause.IS_NOT_NULL)));
                } else {
                    orPartParts.addAll(this.extractQueryFields(this.domainType, (Part)part, path));
                }
            });
            this.queryOrParts.add(orPartParts);
        });
        Optional maybeOrder = pt.getSort().stream().findFirst();
        if (maybeOrder.isPresent()) {
            Sort.Order order = (Sort.Order)maybeOrder.get();
            this.sortBy = order.getProperty();
            this.sortAscending = order.isAscending();
        }
        if (pt.isLimiting()) {
            this.limit = pt.getMaxResults();
        }
    }

    private List<Pair<String, QueryClause>> extractQueryFields(Class<?> type, Part part, List<PropertyPath> path) {
        return this.extractQueryFields(type, part, path, 0);
    }

    private List<Pair<String, QueryClause>> extractQueryFields(Class<?> type, Part part, List<PropertyPath> path, int level) {
        ArrayList<Pair<String, QueryClause>> qf = new ArrayList<Pair<String, QueryClause>>();
        String property = path.get(level).getSegment();
        String key = part.getProperty().toDotPath().replace(".", "_");
        Field field = ReflectionUtils.findField(type, (String)property);
        if (field == null) {
            logger.info((Object)String.format("Did not find a field named %s", key));
            return qf;
        }
        if (field.isAnnotationPresent(TextIndexed.class)) {
            TextIndexed indexAnnotation = field.getAnnotation(TextIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TEXT, part.getType()))));
        } else if (field.isAnnotationPresent(Searchable.class)) {
            Searchable indexAnnotation = field.getAnnotation(Searchable.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            QueryClause clause = indexAnnotation.lexicographic() && this.isLexicographicPartType(part.getType()) ? this.getLexicographicQueryClause(Schema.FieldType.TEXT, part.getType()) : QueryClause.get(Schema.FieldType.TEXT, part.getType());
            logger.debug((Object)String.format("Searchable field %s: lexicographic=%s, partType=%s, clause=%s", new Object[]{actualKey, indexAnnotation.lexicographic(), part.getType(), clause}));
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)clause)));
        } else if (field.isAnnotationPresent(TagIndexed.class)) {
            TagIndexed indexAnnotation = field.getAnnotation(TagIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TAG, part.getType()))));
        } else if (field.isAnnotationPresent(GeoIndexed.class)) {
            GeoIndexed indexAnnotation = field.getAnnotation(GeoIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.GEO, part.getType()))));
        } else if (field.isAnnotationPresent(NumericIndexed.class)) {
            NumericIndexed indexAnnotation = field.getAnnotation(NumericIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.NUMERIC, part.getType()))));
        } else if (field.isAnnotationPresent(Indexed.class)) {
            Indexed indexAnnotation = field.getAnnotation(Indexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            Class fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
            Schema.FieldType redisFieldType = RediSearchQuery.getRedisFieldType(fieldType);
            if (redisFieldType == Schema.FieldType.TAG) {
                QueryClause clause = indexAnnotation.lexicographic() && this.isLexicographicPartType(part.getType()) ? this.getLexicographicQueryClause(Schema.FieldType.TAG, part.getType()) : QueryClause.get(Schema.FieldType.TAG, part.getType());
                logger.debug((Object)String.format("Indexed TAG field %s: lexicographic=%s, partType=%s, clause=%s", new Object[]{actualKey, indexAnnotation.lexicographic(), part.getType(), clause}));
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)clause)));
            } else if (redisFieldType == Schema.FieldType.NUMERIC) {
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.NUMERIC, part.getType()))));
            } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(field);
                if (maybeCollectionType.isPresent()) {
                    Class<?> collectionType = maybeCollectionType.get();
                    if (indexAnnotation.schemaFieldType() == SchemaFieldType.NESTED) {
                        String nestedFieldName;
                        String string = nestedFieldName = path.size() > level + 1 ? path.get(level + 1).getSegment() : "";
                        if (!nestedFieldName.isEmpty()) {
                            String nestedKey = field.getName() + "_" + nestedFieldName;
                            logger.debug((Object)String.format("Processing nested array field query: %s -> %s", key, nestedKey));
                            Field nestedField = ReflectionUtils.findField(collectionType, (String)nestedFieldName);
                            if (nestedField != null) {
                                String alias = QueryUtils.searchIndexFieldAliasFor(nestedField, field.getName());
                                String actualNestedKey = alias != null && !alias.isEmpty() ? alias : nestedKey;
                                Class nestedFieldType = ClassUtils.resolvePrimitiveIfNecessary(nestedField.getType());
                                Schema.FieldType nestedRedisFieldType = RediSearchQuery.getRedisFieldType(nestedFieldType);
                                if (nestedRedisFieldType != null) {
                                    qf.add((Pair<String, QueryClause>)Pair.of((Object)actualNestedKey, (Object)((Object)QueryClause.get(nestedRedisFieldType, part.getType()))));
                                }
                            }
                        }
                    } else if (Number.class.isAssignableFrom(collectionType)) {
                        if (this.isANDQuery) {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.NUMERIC_CONTAINING_ALL)));
                        } else {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.NUMERIC, part.getType()))));
                        }
                    } else if (collectionType == Point.class) {
                        if (this.isANDQuery) {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.GEO_CONTAINING_ALL)));
                        } else {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.GEO, part.getType()))));
                        }
                    } else if (RediSearchQuery.getRedisFieldType(collectionType) == Schema.FieldType.TAG) {
                        if (this.isANDQuery) {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.TAG_CONTAINING_ALL)));
                        } else {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TAG, part.getType()))));
                        }
                    } else {
                        qf.addAll(this.extractQueryFields(collectionType, part, path, level + 1));
                    }
                }
            } else if (Map.class.isAssignableFrom(fieldType)) {
                Class<?> valueType;
                Schema.FieldType valueFieldType;
                String mapValueKey = key + "_values";
                Optional<Class<?>> maybeValueType = ObjectUtils.getMapValueClass(field);
                if (maybeValueType.isPresent() && (valueFieldType = RediSearchQuery.getRedisFieldTypeForMapValue(valueType = maybeValueType.get())) != null) {
                    qf.add((Pair<String, QueryClause>)Pair.of((Object)mapValueKey, (Object)((Object)QueryClause.get(valueFieldType, part.getType()))));
                }
            } else if (redisFieldType == Schema.FieldType.GEO) {
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.GEO, part.getType()))));
            } else {
                qf.addAll(this.extractQueryFields(fieldType, part, path, level + 1));
            }
        }
        return qf;
    }

    public Object execute(Object[] parameters) {
        Optional<String> maybeBloomFilter = this.bloomQueryExecutor.getBloomFilter();
        Optional<String> maybeCuckooFilter = this.cuckooQueryExecutor.getCuckooFilter();
        Optional<String> maybeCountMinFilter = this.countMinQueryExecutor.getCountMinSketch();
        if (maybeBloomFilter.isPresent()) {
            return this.bloomQueryExecutor.executeBloomQuery(parameters, maybeBloomFilter.get());
        }
        if (maybeCuckooFilter.isPresent()) {
            return this.cuckooQueryExecutor.executeCuckooQuery(parameters, maybeCuckooFilter.get());
        }
        if (maybeCountMinFilter.isPresent()) {
            return this.countMinQueryExecutor.executeCountMinQuery(parameters, maybeCountMinFilter.get());
        }
        if (this.type == RediSearchQueryType.QUERY) {
            return !this.isNullParamQuery ? this.executeQuery(parameters) : this.executeNullQuery(parameters);
        }
        if (this.type == RediSearchQueryType.AGGREGATION) {
            return this.executeAggregation(parameters);
        }
        if (this.type == RediSearchQueryType.DELETE) {
            return this.executeDeleteQuery(parameters);
        }
        if (this.type == RediSearchQueryType.TAGVALS) {
            return this.executeFtTagVals();
        }
        if (this.type == RediSearchQueryType.AUTOCOMPLETE) {
            Optional<String> maybeAutoCompleteDictionaryKey = this.autoCompleteQueryExecutor.getAutoCompleteDictionaryKey();
            return maybeAutoCompleteDictionaryKey.map(s -> this.autoCompleteQueryExecutor.executeAutoCompleteQuery(parameters, (String)s)).orElse(null);
        }
        return null;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private Object executeQuery(Object[] parameters) {
        boolean canPerformQueryOptimization;
        String preparedQuery;
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String indexName = this.indexer.getIndexName(this.domainType);
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(indexName);
        boolean excludeNullParams = !this.isNullParamQuery;
        boolean allLexicographic = true;
        block0: for (List<Pair<String, QueryClause>> orPartParts : this.queryOrParts) {
            for (Pair<String, QueryClause> pair : orPartParts) {
                QueryClause clause = (QueryClause)((Object)pair.getSecond());
                logger.debug((Object)String.format("Checking clause: %s, is lexicographic: %s", new Object[]{clause, this.isLexicographicClause(clause)}));
                if (this.isLexicographicClause(clause)) continue;
                allLexicographic = false;
                continue block0;
            }
        }
        if (allLexicographic && !this.queryOrParts.isEmpty()) {
            logger.debug((Object)"Processing as lexicographic query");
            preparedQuery = this.lexicographicQueryExecutor.processLexicographicQuery(this.queryOrParts, parameters, this.domainType);
            logger.debug((Object)String.format("Lexicographic query returned: %s", preparedQuery));
            if (preparedQuery == null) {
                preparedQuery = "*";
            }
        } else {
            preparedQuery = this.prepareQuery(parameters, excludeNullParams);
        }
        redis.clients.jedis.search.Query query = new redis.clients.jedis.search.Query(preparedQuery);
        query.dialect(2);
        ReturnedType returnedType = processor.getReturnedType();
        boolean isProjecting = returnedType.isProjecting() && returnedType.getReturnedType() != SearchResult.class;
        boolean isOpenProjecting = Arrays.stream(returnedType.getReturnedType().getMethods()).anyMatch(m -> m.isAnnotationPresent(Value.class));
        boolean bl = canPerformQueryOptimization = isProjecting && !isOpenProjecting;
        if (canPerformQueryOptimization) {
            query.returnFields((FieldName[])returnedType.getInputProperties().stream().map(inputProperty -> new FieldName("$." + inputProperty, inputProperty)).toArray(FieldName[]::new));
        } else {
            query.returnFields(this.returnFields);
        }
        Optional<Object> maybePageable = Optional.empty();
        boolean needsLimit = true;
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable;
            maybePageable = Arrays.stream(parameters).filter(Pageable.class::isInstance).map(Pageable.class::cast).findFirst();
            if (maybePageable.isPresent() && !(pageable = (Pageable)maybePageable.get()).isUnpaged()) {
                query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
                needsLimit = false;
                for (Sort.Order order : pageable.getSort()) {
                    String alias = QueryUtils.escape(this.indexer.getAlias(this.domainType, order.getProperty()));
                    query.setSortBy(alias, order.isAscending());
                }
            }
        }
        if (needsLimit) {
            if (this.limit != null && this.limit != Integer.MIN_VALUE || this.offset != null && this.offset != Integer.MIN_VALUE) {
                query.limit(Integer.valueOf(this.offset != null ? this.offset : 0), Integer.valueOf(this.limit != null ? this.limit.intValue() : this.redisOMProperties.getRepository().getQuery().getLimit()));
            } else {
                query.limit(Integer.valueOf(0), Integer.valueOf(this.redisOMProperties.getRepository().getQuery().getLimit()));
            }
        }
        if (this.sortBy != null && !this.sortBy.isBlank()) {
            String alias = this.indexer.getAlias(this.domainType, this.sortBy);
            query.setSortBy(alias, this.sortAscending.booleanValue());
        }
        if (this.hasLanguageParameter) {
            Optional<SearchLanguage> maybeSearchLanguage = Arrays.stream(parameters).filter(SearchLanguage.class::isInstance).map(SearchLanguage.class::cast).findFirst();
            maybeSearchLanguage.ifPresent(searchLanguage -> query.setLanguage(searchLanguage.getValue()));
        }
        if (this.queryMethod.isCollectionQuery() && !this.queryMethod.getParameters().isEmpty()) {
            List emptyCollectionParams = Arrays.stream(parameters).filter(Collection.class::isInstance).map(p -> (Collection)p).filter(Collection::isEmpty).collect(Collectors.toList());
            if (!emptyCollectionParams.isEmpty()) {
                return Collections.emptyList();
            }
        }
        query.dialect(this.dialect.getValue());
        SearchResult searchResult = ops.search(query);
        Object result = null;
        if (processor.getReturnedType().getReturnedType() == Boolean.TYPE || processor.getReturnedType().getReturnedType() == Boolean.class) {
            result = searchResult.getTotalResults() > 0L;
        } else if (this.queryMethod.getReturnedObjectType() == SearchResult.class) {
            result = searchResult;
        } else if (this.queryMethod.isPageQuery()) {
            List<Object> content = searchResult.getDocuments().stream().map(this::parseDocumentResult).toList();
            if (maybePageable.isPresent()) {
                Pageable pageable = (Pageable)maybePageable.get();
                result = new PageImpl(content, pageable, searchResult.getTotalResults());
            }
        } else if (!this.queryMethod.isCollectionQuery()) {
            if (!searchResult.getDocuments().isEmpty()) {
                Document doc = (Document)searchResult.getDocuments().get(0);
                result = this.parseDocumentResult(doc);
            }
        } else if (this.queryMethod.isCollectionQuery() || this.type == RediSearchQueryType.DELETE) {
            result = searchResult.getDocuments().stream().map(this::parseDocumentResult).toList();
        }
        return processor.processResult(result);
    }

    private Object parseDocumentResult(Document doc) {
        if (doc == null || doc.get("$") == null) {
            return null;
        }
        Gson gsonInstance = this.getGson();
        Object entity = switch (this.dialect) {
            default -> throw new IncompatibleClassChangeError();
            case Dialect.ONE, Dialect.TWO -> gsonInstance.fromJson(SafeEncoder.encode((byte[])((byte[])doc.get("$"))), this.domainType);
            case Dialect.THREE -> gsonInstance.fromJson(((JsonArray)gsonInstance.fromJson(SafeEncoder.encode((byte[])((byte[])doc.get("$"))), JsonArray.class)).get(0), this.domainType);
        };
        return ObjectUtils.populateRedisKey(entity, doc.getId());
    }

    private Object executeDeleteQuery(Object[] parameters) {
        String indexName = this.indexer.getIndexName(this.domainType);
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(indexName);
        String baseQuery = this.prepareQuery(parameters, true);
        AggregationBuilder aggregation = new AggregationBuilder(baseQuery);
        String[] fields = (String[])Stream.concat(Stream.of("@__key"), this.queryOrParts.stream().flatMap(Collection::stream).filter(pair -> pair.getSecond() == QueryClause.IS_NULL || pair.getSecond() == QueryClause.IS_NOT_NULL).map(pair -> String.format("@%s", pair.getFirst()))).toArray(String[]::new);
        aggregation.load(fields);
        for (List<Pair<String, QueryClause>> orPartParts : this.queryOrParts) {
            for (Pair<String, QueryClause> pair2 : orPartParts) {
                if (pair2.getSecond() == QueryClause.IS_NULL) {
                    if (this.hasIndexMissing((String)pair2.getFirst())) {
                        aggregation.filter("ismissing(@" + (String)pair2.getFirst() + ")");
                        continue;
                    }
                    aggregation.filter("!exists(@" + (String)pair2.getFirst() + ")");
                    continue;
                }
                if (pair2.getSecond() != QueryClause.IS_NOT_NULL) continue;
                if (this.hasIndexMissing((String)pair2.getFirst())) {
                    aggregation.filter("!ismissing(@" + (String)pair2.getFirst() + ")");
                    continue;
                }
                aggregation.filter("exists(@" + (String)pair2.getFirst() + ")");
            }
        }
        aggregation.sortBy(this.aggregationSortedFields.toArray(new SortedField[0]));
        aggregation.limit(0, this.redisOMProperties.getRepository().getQuery().getLimit());
        aggregation.dialect(this.dialect.getValue());
        AggregationResult aggregationResult = ops.aggregate(aggregation);
        List<String> keys = aggregationResult.getResults().stream().map(d -> d.get("__key").toString()).toList();
        Class returnType = this.queryMethod.getReturnedObjectType();
        if (Number.class.isAssignableFrom(returnType) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Short.TYPE)) {
            if (keys.isEmpty()) {
                return 0;
            }
            return this.modulesOperations.template().delete(keys);
        }
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        List<?> entities = this.modulesOperations.opsForJSON().mget(this.domainType, (K[])keys.toArray(new String[0]));
        this.modulesOperations.template().delete(keys);
        return entities;
    }

    private Object executeAggregation(Object[] parameters) {
        String indexName = this.indexer.getIndexName(this.domainType);
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(indexName);
        String preparedQuery = this.prepareQuery(parameters, true);
        AggregationBuilder aggregation = new AggregationBuilder(preparedQuery);
        if (this.aggregationTimeout != null) {
            aggregation.timeout(this.aggregationTimeout.longValue());
        }
        if (this.aggregationVerbatim != null) {
            aggregation.verbatim();
        }
        for (Map.Entry<String, String> apply : this.aggregationLoad) {
            if (apply.getValue().isBlank()) {
                aggregation.load(new String[]{apply.getKey()});
                continue;
            }
            aggregation.load(new String[]{apply.getKey(), "AS", apply.getValue()});
        }
        this.aggregationGroups.forEach(arg_0 -> ((AggregationBuilder)aggregation).groupBy(arg_0));
        if (this.aggregationFilter != null) {
            for (String filter : this.aggregationFilter) {
                aggregation.filter(filter);
            }
        }
        Optional<Object> maybePageable = Optional.empty();
        boolean needsLimit = true;
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable;
            maybePageable = Arrays.stream(parameters).filter(Pageable.class::isInstance).map(Pageable.class::cast).findFirst();
            if (maybePageable.isPresent() && !(pageable = (Pageable)maybePageable.get()).isUnpaged()) {
                aggregation.limit(Math.toIntExact(pageable.getOffset()), pageable.getPageSize());
                needsLimit = false;
                pageable.getSort();
                for (Sort.Order order : pageable.getSort()) {
                    String alias = this.indexer.getAlias(this.domainType, order.getProperty());
                    if (order.isAscending()) {
                        aggregation.sortByAsc(alias);
                        continue;
                    }
                    aggregation.sortByDesc(alias);
                }
            }
        }
        if (this.sortBy != null && !this.sortBy.isBlank()) {
            String alias = this.indexer.getAlias(this.domainType, this.sortBy);
            aggregation.sortByAsc(alias);
        } else if (!this.aggregationSortedFields.isEmpty()) {
            if (this.aggregationSortByMax != null) {
                aggregation.sortBy(this.aggregationSortByMax.intValue(), this.aggregationSortedFields.toArray(new SortedField[0]));
            } else {
                aggregation.sortBy(this.aggregationSortedFields.toArray(new SortedField[0]));
            }
        }
        for (Map.Entry<String, String> apply : this.aggregationApply) {
            aggregation.apply(apply.getValue(), apply.getKey());
        }
        if (needsLimit) {
            if (this.limit != null || this.offset != null) {
                aggregation.limit(this.offset != null ? this.offset : 0, this.limit != null ? this.limit : 0);
            } else {
                aggregation.limit(0, this.redisOMProperties.getRepository().getQuery().getLimit());
            }
        }
        aggregation.dialect(this.dialect.getValue());
        AggregationResult aggregationResult = ops.aggregate(aggregation);
        AggregationResult result = null;
        if (this.queryMethod.getReturnedObjectType() == AggregationResult.class) {
            result = aggregationResult;
        } else if (this.queryMethod.getReturnedObjectType() == Map.class) {
            List<Object> content = List.of();
            if (this.queryMethod.getReturnedObjectType() == Map.class) {
                content = aggregationResult.getResults().stream().map(m -> m.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), e.getValue() != null ? e.getValue().toString() : "")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))).collect(Collectors.toList());
            }
            if (this.queryMethod.isPageQuery() && maybePageable.isPresent()) {
                Pageable pageable = (Pageable)maybePageable.get();
                result = new PageImpl(content, pageable, aggregationResult.getTotalResults());
            }
        }
        return result;
    }

    private Object executeFtTagVals() {
        String indexName = this.indexer.getIndexName(this.domainType);
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(indexName);
        return ops.tagVals(this.value);
    }

    private String prepareQuery(Object[] parameters, boolean excludeNullParams) {
        logger.debug((Object)String.format("parameters: %s", Arrays.toString(parameters)));
        logger.info((Object)String.format("Preparing query for method: %s, isMapContainsQuery: %s", this.queryMethod.getName(), this.isMapContainsQuery));
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(parameters));
        StringBuilder preparedQuery = new StringBuilder();
        boolean multipleOrParts = this.queryOrParts.size() > 1;
        logger.debug((Object)String.format("queryOrParts: %s", this.queryOrParts.size()));
        logger.info((Object)String.format("queryOrParts details: %s", this.queryOrParts));
        if (!this.queryOrParts.isEmpty()) {
            preparedQuery.append(this.queryOrParts.stream().map(qop -> {
                Object orPart = multipleOrParts ? "(" : "";
                orPart = (String)orPart + qop.stream().map(fieldClauses -> {
                    if (excludeNullParams && (fieldClauses.getSecond() == QueryClause.IS_NULL || fieldClauses.getSecond() == QueryClause.IS_NOT_NULL)) {
                        return "";
                    }
                    String fieldName = QueryUtils.escape((String)fieldClauses.getFirst());
                    QueryClause queryClause = (QueryClause)((Object)((Object)((Object)fieldClauses.getSecond())));
                    logger.info((Object)String.format("Processing field: %s with queryClause: %s", new Object[]{fieldName, queryClause}));
                    int paramsCnt = queryClause.getClauseTemplate().getNumberOfArguments();
                    Object[] ps = params.subList(0, paramsCnt).toArray();
                    params.subList(0, paramsCnt).clear();
                    return queryClause.prepareQuery(fieldName, ps);
                }).collect(Collectors.joining(" "));
                orPart = (String)orPart + (multipleOrParts ? ")" : "");
                return orPart;
            }).collect(Collectors.joining(" | ")));
        } else {
            Iterator iterator = this.queryMethod.getParameters().iterator();
            int index = 0;
            if (this.value != null && !this.value.isBlank()) {
                preparedQuery.append(this.value);
            }
            while (iterator.hasNext()) {
                String key;
                Parameter p = (Parameter)iterator.next();
                Optional maybeKey = p.getName();
                if (maybeKey.isPresent()) {
                    key = (String)maybeKey.get();
                } else {
                    String string = key = this.paramNames.size() > index ? this.paramNames.get(index) : "";
                }
                if (!key.isBlank()) {
                    String v;
                    Object object = parameters[index];
                    if (object instanceof Collection) {
                        Collection c = (Collection)object;
                        v = c.stream().map(Object::toString).collect(Collectors.joining(" | "));
                    } else {
                        v = parameters[index].toString();
                    }
                    String regex = "(\\$" + Pattern.quote(key) + "(?![a-zA-Z0-9_]))(\\W+|\\*|\\+|$)?";
                    preparedQuery = new StringBuilder(preparedQuery.toString().replaceAll(regex, v + "$2"));
                }
                ++index;
            }
        }
        if (preparedQuery.toString().isBlank()) {
            preparedQuery.append("*");
        }
        logger.info((Object)String.format("Final query string: %s", preparedQuery));
        logger.debug((Object)String.format("query: %s", preparedQuery));
        return preparedQuery.toString();
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = this.gsonBuilder.create();
        }
        return this.gson;
    }

    private Object executeNullQuery(Object[] parameters) {
        String indexName = this.indexer.getIndexName(this.domainType);
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(indexName);
        String baseQuery = this.prepareQuery(parameters, true);
        AggregationBuilder aggregation = new AggregationBuilder(baseQuery);
        String[] fields = (String[])Stream.concat(Stream.of("@__key"), this.queryOrParts.stream().flatMap(Collection::stream).filter(pair -> pair.getSecond() == QueryClause.IS_NULL || pair.getSecond() == QueryClause.IS_NOT_NULL).map(pair -> String.format("@%s", pair.getFirst()))).toArray(String[]::new);
        aggregation.load(fields);
        for (List<Pair<String, QueryClause>> orPartParts : this.queryOrParts) {
            for (Pair<String, QueryClause> pair2 : orPartParts) {
                if (pair2.getSecond() == QueryClause.IS_NULL) {
                    if (this.hasIndexMissing((String)pair2.getFirst())) {
                        aggregation.filter("ismissing(@" + (String)pair2.getFirst() + ")");
                        continue;
                    }
                    aggregation.filter("!exists(@" + (String)pair2.getFirst() + ")");
                    continue;
                }
                if (pair2.getSecond() != QueryClause.IS_NOT_NULL) continue;
                if (this.hasIndexMissing((String)pair2.getFirst())) {
                    aggregation.filter("!ismissing(@" + (String)pair2.getFirst() + ")");
                    continue;
                }
                aggregation.filter("exists(@" + (String)pair2.getFirst() + ")");
            }
        }
        boolean needsLimit = true;
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable;
            Optional<Pageable> maybePageable = Arrays.stream(parameters).filter(Pageable.class::isInstance).map(Pageable.class::cast).findFirst();
            if (maybePageable.isPresent() && !(pageable = maybePageable.get()).isUnpaged()) {
                aggregation.limit(Math.toIntExact(pageable.getOffset()), pageable.getPageSize());
                needsLimit = false;
                pageable.getSort();
                for (Sort.Order order : pageable.getSort()) {
                    String alias = this.indexer.getAlias(this.domainType, order.getProperty());
                    if (order.isAscending()) {
                        aggregation.sortByAsc(alias);
                        continue;
                    }
                    aggregation.sortByDesc(alias);
                }
            }
        }
        if (this.sortBy != null && !this.sortBy.isBlank()) {
            String alias = this.indexer.getAlias(this.domainType, this.sortBy);
            aggregation.sortByAsc(alias);
        } else if (!this.aggregationSortedFields.isEmpty()) {
            if (this.aggregationSortByMax != null) {
                aggregation.sortBy(this.aggregationSortByMax.intValue(), this.aggregationSortedFields.toArray(new SortedField[0]));
            } else {
                aggregation.sortBy(this.aggregationSortedFields.toArray(new SortedField[0]));
            }
        }
        if (needsLimit) {
            if (this.limit != null || this.offset != null) {
                aggregation.limit(this.offset != null ? this.offset : 0, this.limit != null ? this.limit : 0);
            } else {
                aggregation.limit(0, this.redisOMProperties.getRepository().getQuery().getLimit());
            }
        }
        aggregation.dialect(this.dialect.getValue());
        AggregationResult aggregationResult = ops.aggregate(aggregation);
        String[] stringArray = (String[])aggregationResult.getResults().stream().map(d -> d.get("__key").toString()).toArray(String[]::new);
        List<?> entities = this.modulesOperations.opsForJSON().mget(this.domainType, (K[])stringArray);
        if (!this.queryMethod.isCollectionQuery()) {
            return entities.isEmpty() ? null : entities.get(0);
        }
        return entities;
    }

    private boolean hasIndexMissing(String fieldName) {
        try {
            Field field = ReflectionUtils.findField(this.domainType, (String)fieldName);
            if (field == null) {
                return false;
            }
            if (field.isAnnotationPresent(Indexed.class)) {
                Indexed indexed = field.getAnnotation(Indexed.class);
                return indexed.indexMissing();
            }
            if (field.isAnnotationPresent(Searchable.class)) {
                Searchable searchable = field.getAnnotation(Searchable.class);
                return searchable.indexMissing();
            }
            return false;
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to check indexMissing for field: " + fieldName), (Throwable)e);
            return false;
        }
    }

    private boolean isLexicographicQueryType(Part.Type type) {
        return LEXICOGRAPHIC_PART_TYPES.contains(type);
    }

    private boolean isLexicographicClause(QueryClause clause) {
        return LEXICOGRAPHIC_QUERY_CLAUSES.contains((Object)clause);
    }

    private boolean isLexicographicPartType(Part.Type partType) {
        return LEXICOGRAPHIC_PART_TYPES.contains(partType);
    }

    private QueryClause getLexicographicQueryClause(Schema.FieldType fieldType, Part.Type partType) {
        if (fieldType == Schema.FieldType.TEXT) {
            switch (partType) {
                case GREATER_THAN: {
                    return QueryClause.TEXT_GREATER_THAN;
                }
                case LESS_THAN: {
                    return QueryClause.TEXT_LESS_THAN;
                }
                case GREATER_THAN_EQUAL: {
                    return QueryClause.TEXT_GREATER_THAN_EQUAL;
                }
                case LESS_THAN_EQUAL: {
                    return QueryClause.TEXT_LESS_THAN_EQUAL;
                }
                case BETWEEN: {
                    return QueryClause.TEXT_BETWEEN;
                }
            }
            return QueryClause.get(fieldType, partType);
        }
        if (fieldType == Schema.FieldType.TAG) {
            switch (partType) {
                case GREATER_THAN: {
                    return QueryClause.TAG_GREATER_THAN;
                }
                case LESS_THAN: {
                    return QueryClause.TAG_LESS_THAN;
                }
                case GREATER_THAN_EQUAL: {
                    return QueryClause.TAG_GREATER_THAN_EQUAL;
                }
                case LESS_THAN_EQUAL: {
                    return QueryClause.TAG_LESS_THAN_EQUAL;
                }
                case BETWEEN: {
                    return QueryClause.TAG_BETWEEN;
                }
            }
            return QueryClause.get(fieldType, partType);
        }
        return QueryClause.get(fieldType, partType);
    }
}

