/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query.lexicographic;

import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.repository.query.RediSearchQuery;
import com.redis.om.spring.repository.query.clause.QueryClause;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.util.Pair;
import org.springframework.util.ReflectionUtils;

public class LexicographicQueryExecutor {
    private static final Log logger = LogFactory.getLog(LexicographicQueryExecutor.class);
    private static final Set<QueryClause> LEXICOGRAPHIC_QUERY_CLAUSES = Set.of(QueryClause.TEXT_GREATER_THAN, QueryClause.TEXT_LESS_THAN, QueryClause.TEXT_GREATER_THAN_EQUAL, QueryClause.TEXT_LESS_THAN_EQUAL, QueryClause.TEXT_BETWEEN, QueryClause.TAG_GREATER_THAN, QueryClause.TAG_LESS_THAN, QueryClause.TAG_GREATER_THAN_EQUAL, QueryClause.TAG_LESS_THAN_EQUAL, QueryClause.TAG_BETWEEN);
    private final RediSearchQuery rediSearchQuery;
    private final RedisModulesOperations<String> modulesOperations;
    private final RediSearchIndexer indexer;

    public LexicographicQueryExecutor(RediSearchQuery rediSearchQuery, RedisModulesOperations<String> modulesOperations, RediSearchIndexer indexer) {
        this.rediSearchQuery = rediSearchQuery;
        this.modulesOperations = modulesOperations;
        this.indexer = indexer;
    }

    /*
     * WARNING - void declaration
     */
    public String processLexicographicQuery(List<List<Pair<String, QueryClause>>> queryOrParts, Object[] parameters, Class<?> domainType) {
        logger.debug((Object)String.format("Processing lexicographic query with %d queryOrParts and %d parameters", queryOrParts.size(), parameters.length));
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(parameters));
        ArrayList<void> orResults = new ArrayList<void>();
        boolean hasLexicographicQuery = false;
        boolean hasNonLexicographicQuery = false;
        int paramIndex = 0;
        for (List<Pair<String, QueryClause>> list : queryOrParts) {
            void var11_13;
            Object var11_14 = null;
            for (Pair<String, QueryClause> pair : list) {
                int numParams;
                String fieldName = (String)pair.getFirst();
                QueryClause queryClause = (QueryClause)((Object)pair.getSecond());
                logger.debug((Object)String.format("Processing field: %s with queryClause: %s", new Object[]{fieldName, queryClause}));
                if (this.isLexicographicQuery(queryClause)) {
                    hasLexicographicQuery = true;
                    numParams = queryClause.getClauseTemplate().getNumberOfArguments();
                    Object[] queryParams = Arrays.copyOfRange(parameters, paramIndex, paramIndex + numParams);
                    paramIndex += numParams;
                    Set<String> entityIds = this.executeLexicographicQuery(fieldName, queryClause, queryParams, domainType);
                    if (var11_13 == null) {
                        HashSet<String> hashSet = new HashSet<String>(entityIds);
                        continue;
                    }
                    var11_13.retainAll(entityIds);
                    continue;
                }
                hasNonLexicographicQuery = true;
                numParams = queryClause.getClauseTemplate().getNumberOfArguments();
                paramIndex += numParams;
            }
            if (var11_13 == null || var11_13.isEmpty()) continue;
            orResults.add(var11_13);
        }
        if (hasLexicographicQuery && !orResults.isEmpty()) {
            HashSet<String> finalResults = new HashSet<String>();
            for (Set set : orResults) {
                finalResults.addAll(set);
            }
            if (!finalResults.isEmpty()) {
                String string = this.buildIdQuery(finalResults);
                logger.debug((Object)String.format("Built ID-based query: %s", string));
                return string;
            }
            return "@__id:{}";
        }
        return null;
    }

    private boolean isLexicographicQuery(QueryClause queryClause) {
        return LEXICOGRAPHIC_QUERY_CLAUSES.contains((Object)queryClause);
    }

    private Set<String> executeLexicographicQuery(String fieldName, QueryClause queryClause, Object[] params, Class<?> domainType) {
        logger.debug((Object)String.format("Executing lexicographic query for field: %s, queryClause: %s", new Object[]{fieldName, queryClause}));
        String entityPrefix = this.indexer.getKeyspaceForEntityClass(domainType);
        if (entityPrefix == null) {
            logger.debug((Object)"Entity prefix is null");
            return Collections.emptySet();
        }
        logger.debug((Object)("Entity prefix: " + entityPrefix));
        String actualFieldName = this.getActualFieldName(domainType, fieldName);
        if (actualFieldName == null) {
            logger.debug((Object)String.format("Could not find actual field name for alias: %s", fieldName));
            return Collections.emptySet();
        }
        logger.debug((Object)String.format("Actual field name: %s", actualFieldName));
        if (!this.isFieldLexicographic(domainType, actualFieldName)) {
            logger.debug((Object)String.format("Field %s is not lexicographic", actualFieldName));
            return Collections.emptySet();
        }
        String sortedSetKey = entityPrefix + actualFieldName + ":lex";
        logger.debug((Object)String.format("Sorted set key: %s", sortedSetKey));
        Set<String> matches = this.executeRangeQuery(sortedSetKey, queryClause, params);
        logger.debug((Object)String.format("Range query returned %d matches", matches.size()));
        Set<String> result = matches.stream().map(match -> {
            int hashIndex = match.lastIndexOf(35);
            return hashIndex >= 0 ? match.substring(hashIndex + 1) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        logger.debug((Object)String.format("Extracted %d entity IDs: %s", result.size(), result));
        return result;
    }

    private Set<String> executeRangeQuery(String sortedSetKey, QueryClause queryClause, Object[] params) {
        logger.debug((Object)String.format("Executing range query on %s with clause %s and param: %s", new Object[]{sortedSetKey, queryClause, params[0]}));
        switch (queryClause) {
            case TEXT_GREATER_THAN: 
            case TAG_GREATER_THAN: {
                String gtParam = params[0].toString() + "\uffff";
                Set results = this.modulesOperations.template().opsForZSet().rangeByLex((Object)sortedSetKey, Range.rightUnbounded((Range.Bound)Range.Bound.exclusive((Object)gtParam)), Limit.unlimited());
                logger.debug((Object)String.format("ZRANGEBYLEX %s (%s +inf returned: %s", sortedSetKey, gtParam, results));
                return results;
            }
            case TEXT_LESS_THAN: 
            case TAG_LESS_THAN: {
                String ltParam = params[0].toString() + "#";
                return this.modulesOperations.template().opsForZSet().rangeByLex((Object)sortedSetKey, Range.leftUnbounded((Range.Bound)Range.Bound.exclusive((Object)ltParam)), Limit.unlimited());
            }
            case TEXT_GREATER_THAN_EQUAL: 
            case TAG_GREATER_THAN_EQUAL: {
                String gteParam = params[0].toString() + "#";
                return this.modulesOperations.template().opsForZSet().rangeByLex((Object)sortedSetKey, Range.rightUnbounded((Range.Bound)Range.Bound.inclusive((Object)gteParam)), Limit.unlimited());
            }
            case TEXT_LESS_THAN_EQUAL: 
            case TAG_LESS_THAN_EQUAL: {
                String lteParam = params[0].toString() + "\uffff";
                return this.modulesOperations.template().opsForZSet().rangeByLex((Object)sortedSetKey, Range.leftUnbounded((Range.Bound)Range.Bound.inclusive((Object)lteParam)), Limit.unlimited());
            }
            case TEXT_BETWEEN: 
            case TAG_BETWEEN: {
                String minParam = params[0].toString() + "#";
                String maxParam = params[1].toString() + "\uffff";
                return this.modulesOperations.template().opsForZSet().rangeByLex((Object)sortedSetKey, Range.closed((Object)minParam, (Object)maxParam), Limit.unlimited());
            }
        }
        return Collections.emptySet();
    }

    private String getActualFieldName(Class<?> domainType, String fieldAlias) {
        for (Field field : domainType.getDeclaredFields()) {
            String alias;
            if (field.isAnnotationPresent(Indexed.class)) {
                Indexed indexed = field.getAnnotation(Indexed.class);
                String string = alias = indexed.alias().isBlank() ? field.getName() : indexed.alias();
                if (!alias.equals(fieldAlias) && !field.getName().equals(fieldAlias)) continue;
                return field.getName();
            }
            if (!field.isAnnotationPresent(Searchable.class)) continue;
            Searchable searchable = field.getAnnotation(Searchable.class);
            String string = alias = searchable.alias().isBlank() ? field.getName() : searchable.alias();
            if (!alias.equals(fieldAlias) && !field.getName().equals(fieldAlias)) continue;
            return field.getName();
        }
        return null;
    }

    private boolean isFieldLexicographic(Class<?> domainType, String fieldName) {
        Field field = ReflectionUtils.findField(domainType, (String)fieldName);
        if (field == null) {
            return false;
        }
        if (field.isAnnotationPresent(Indexed.class)) {
            return field.getAnnotation(Indexed.class).lexicographic();
        }
        if (field.isAnnotationPresent(Searchable.class)) {
            return field.getAnnotation(Searchable.class).lexicographic();
        }
        return false;
    }

    private String buildIdQuery(Set<String> entityIds) {
        if (entityIds.isEmpty()) {
            return "@id:{}";
        }
        String idList = entityIds.stream().collect(Collectors.joining("|"));
        return "@id:{" + idList + "}";
    }
}

