/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.geo;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.util.ObjectUtils;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import redis.clients.jedis.search.querybuilder.GeoValue;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;

public class NearPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final Point point;
    private final Distance distance;

    public NearPredicate(SearchFieldAccessor field, Point point, Distance distance) {
        super(field);
        this.point = point;
        this.distance = distance;
    }

    public Point getPoint() {
        return this.point;
    }

    public Distance getDistance() {
        return this.distance;
    }

    @Override
    public Node apply(Node root) {
        boolean paramsPresent;
        boolean bl = paramsPresent = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)this.point) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)this.distance);
        if (paramsPresent) {
            GeoValue geoValue = new GeoValue(this.getPoint().getX(), this.getPoint().getY(), this.getDistance().getValue(), ObjectUtils.getDistanceUnit(this.getDistance()));
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{geoValue});
        }
        return root;
    }
}

