/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;

public class EqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T value;

    public EqualPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
    }

    public EqualPredicate(SearchFieldAccessor field, T value, Schema.FieldType fieldType) {
        super(field, fieldType);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValue())) {
            return root;
        }
        if (Iterable.class.isAssignableFrom(this.getValue().getClass())) {
            Iterable values = (Iterable)this.getValue();
            QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
            for (Object v : values) {
                and.add(this.getSearchAlias(), new String[]{this.escapeTagValue(v.toString())});
            }
            return QueryBuilders.intersect((Node[])new Node[]{root, and});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new String[]{this.escapeTagValue(this.value.toString())});
    }

    private String escapeTagValue(String value) {
        if (value.matches(".*[\\s,.<>{}\\[\\]\"':;!@#$%^&*()\\-+=~/].*")) {
            return "{\"" + value + "\"}";
        }
        return "{" + value + "}";
    }
}

