/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.serialization.gson.ReferenceDeserializer;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.Reference;
import org.springframework.stereotype.Component;

@Component
public class GsonReferenceSerializerRegistrar {
    private static final Log logger = LogFactory.getLog(GsonReferenceSerializerRegistrar.class);
    private static final String SKIPPING_REFERENCE_SEARCH = "Skipping @Reference search for %s because %s";
    private final GsonBuilder builder;
    private final ApplicationContext ac;
    private JSONOperations<?> ops;

    public GsonReferenceSerializerRegistrar(GsonBuilder builder, ApplicationContext ac) {
        this.builder = builder;
        this.ac = ac;
    }

    public void registerReferencesFor(Class<?> cls) {
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>(ObjectUtils.getBeanDefinitionsFor(this.ac, cls));
        logger.info((Object)String.format("Found %s @%s annotated Beans...", beanDefs.size(), cls.getSimpleName()));
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                this.processEntity(cl);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)String.format(SKIPPING_REFERENCE_SEARCH, beanDef.getBeanClassName(), e.getMessage()));
            }
        }
    }

    private void processEntity(Class<?> clazz) {
        this.ops = (JSONOperations)this.ac.getBean("redisJSONOperations", JSONOperations.class);
        List<Field> allClassFields = ObjectUtils.getDeclaredFieldsTransitively(clazz);
        for (Field field : allClassFields) {
            if (!field.isAnnotationPresent(Reference.class)) continue;
            logger.info((Object)String.format("\ud83e\udea7Registering reference type adapter for %s", field.getType().getName()));
            this.processField(field);
        }
    }

    private void processField(Field field) {
        Optional<Type> maybeCollectionElementType;
        TypeToken typeToken = ObjectUtils.isCollection(field) ? ((maybeCollectionElementType = ObjectUtils.getCollectionElementType(field)).isPresent() ? TypeToken.getParameterized(field.getType(), (Type[])new Type[]{maybeCollectionElementType.get()}) : TypeToken.get(field.getType())) : TypeToken.get(field.getType());
        this.builder.registerTypeAdapter(typeToken.getType(), (Object)new ReferenceDeserializer(field, this.ops, (RedisOMProperties)this.ac.getBean(RedisOMProperties.class), (CacheManager)this.ac.getBean("redisOMCacheManager", CacheManager.class)));
        this.processEntity(field.getType());
    }
}

