/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.CoreUtils;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.redis.om.spring.RedisOMProperties;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisOMProperties.class})
@ConditionalOnProperty(name={"redis.om.spring.authentication.entra-id.enabled"}, havingValue="true", matchIfMissing=false)
public class EntraIDConfiguration {
    private static final Log logger = LogFactory.getLog(EntraIDConfiguration.class);
    @Value(value="${spring.data.redis.host}")
    private String host;
    @Value(value="${spring.data.redis.port}")
    private int port;
    @Value(value="${redis.om.spring.authentication.entra-id.enabled}")
    private String clientType;

    public EntraIDConfiguration() {
        logger.info((Object)"EntraIDConfiguration initialized");
        logger.info((Object)("Redis host: " + this.host));
        logger.info((Object)("Redis port: " + this.port));
        logger.info((Object)("Redis client type: " + this.clientType));
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory() {
        logger.info((Object)"Creating JedisConnectionFactory for Entra ID authentication");
        DefaultAzureCredential defaultAzureCredential = new DefaultAzureCredentialBuilder().build();
        TokenRequestContext trc = new TokenRequestContext().addScopes(new String[]{"https://redis.azure.com/.default"});
        TokenRefreshCache tokenRefreshCache = new TokenRefreshCache((TokenCredential)defaultAzureCredential, trc);
        AccessToken accessToken = tokenRefreshCache.getAccessToken();
        boolean useSsl = true;
        String token = accessToken.getToken();
        logger.trace((Object)("Token obtained successfully: \n" + token));
        String username = this.extractUsernameFromToken(token);
        logger.debug((Object)("Username extracted from token: " + username));
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(this.getRedisStandaloneConfiguration(username, token, useSsl));
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        jedisConnectionFactory.setUseSsl(useSsl);
        logger.info((Object)"JedisConnectionFactory for EntraID created successfully");
        return jedisConnectionFactory;
    }

    private RedisStandaloneConfiguration getRedisStandaloneConfiguration(String username, String token, boolean useSsl) {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.host);
        redisStandaloneConfiguration.setPort(this.port);
        redisStandaloneConfiguration.setUsername(username);
        redisStandaloneConfiguration.setPassword(token);
        return redisStandaloneConfiguration;
    }

    private String extractUsernameFromToken(String token) {
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid JWT token");
        }
        String payload = new String(Base64.getUrlDecoder().decode(parts[1]));
        JsonObject jsonObject = JsonParser.parseString((String)payload).getAsJsonObject();
        return jsonObject.get("sub").getAsString();
    }

    private class TokenRefreshCache {
        private final TokenCredential tokenCredential;
        private final TokenRequestContext tokenRequestContext;
        private final Timer timer;
        private volatile AccessToken accessToken;
        private final Duration maxRefreshOffset = Duration.ofMinutes(5L);
        private final Duration baseRefreshOffset = Duration.ofMinutes(2L);
        private Jedis jedisInstanceToAuthenticate;
        private String username;

        public TokenRefreshCache(TokenCredential tokenCredential, TokenRequestContext tokenRequestContext) {
            this.tokenCredential = tokenCredential;
            this.tokenRequestContext = tokenRequestContext;
            this.timer = new Timer();
        }

        public AccessToken getAccessToken() {
            if (this.accessToken != null) {
                return this.accessToken;
            }
            TokenRefreshTask tokenRefreshTask = new TokenRefreshTask();
            this.accessToken = (AccessToken)this.tokenCredential.getToken(this.tokenRequestContext).block();
            this.timer.schedule((TimerTask)tokenRefreshTask, this.getTokenRefreshDelay());
            return this.accessToken;
        }

        private long getTokenRefreshDelay() {
            return (this.accessToken.getExpiresAt().minusSeconds(ThreadLocalRandom.current().nextLong(this.baseRefreshOffset.getSeconds(), this.maxRefreshOffset.getSeconds())).toEpochSecond() - OffsetDateTime.now().toEpochSecond()) * 1000L;
        }

        public TokenRefreshCache setJedisInstanceToAuthenticate(Jedis jedisInstanceToAuthenticate) {
            this.jedisInstanceToAuthenticate = jedisInstanceToAuthenticate;
            return this;
        }

        private class TokenRefreshTask
        extends TimerTask {
            private TokenRefreshTask() {
            }

            @Override
            public void run() {
                TokenRefreshCache.this.accessToken = (AccessToken)TokenRefreshCache.this.tokenCredential.getToken(TokenRefreshCache.this.tokenRequestContext).block();
                TokenRefreshCache.this.username = EntraIDConfiguration.this.extractUsernameFromToken(TokenRefreshCache.this.accessToken.getToken());
                System.out.println("Refreshed Token with Expiry: " + TokenRefreshCache.this.accessToken.getExpiresAt().toEpochSecond());
                if (TokenRefreshCache.this.jedisInstanceToAuthenticate != null && !CoreUtils.isNullOrEmpty((CharSequence)TokenRefreshCache.this.username)) {
                    TokenRefreshCache.this.jedisInstanceToAuthenticate.auth(TokenRefreshCache.this.username, TokenRefreshCache.this.accessToken.getToken());
                    System.out.println("Refreshed Jedis Connection with fresh access token, token expires at : " + TokenRefreshCache.this.accessToken.getExpiresAt().toEpochSecond());
                }
                TokenRefreshCache.this.timer.schedule((TimerTask)new TokenRefreshTask(), TokenRefreshCache.this.getTokenRefreshDelay());
            }
        }
    }
}

