/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.convert;

import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.convert.RedisOMCustomConversions;
import com.redis.om.spring.mapping.RedisEnhancedMappingContext;
import com.redis.om.spring.repository.query.QueryUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.DefaultRedisTypeMapper;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.RedisTypeMapper;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MappingRedisOMConverter
implements RedisConverter,
InitializingBean {
    private static final String INVALID_TYPE_ASSIGNMENT = "Value of type %s cannot be assigned to property %s of type %s.";
    private final RedisMappingContext mappingContext;
    private final GenericConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final RedisTypeMapper typeMapper;
    private final Comparator<String> listKeyComparator = Comparator.nullsLast(NaturalOrderingKeyComparator.INSTANCE);
    private final ProjectionFactory projectionFactory;
    @Nullable
    private ReferenceResolver referenceResolver;
    private CustomConversions customConversions;

    public MappingRedisOMConverter() {
        this(null);
    }

    public MappingRedisOMConverter(RedisMappingContext context) {
        this(context, null, null);
    }

    public MappingRedisOMConverter(@Nullable RedisMappingContext mappingContext, @Nullable ReferenceResolver referenceResolver) {
        this(mappingContext, referenceResolver, null);
    }

    public MappingRedisOMConverter(@Nullable RedisMappingContext mappingContext, @Nullable ReferenceResolver referenceResolver, @Nullable RedisTypeMapper typeMapper) {
        this.mappingContext = mappingContext != null ? mappingContext : new RedisEnhancedMappingContext();
        this.entityInstantiators = new EntityInstantiators();
        this.conversionService = new DefaultConversionService();
        this.customConversions = new RedisOMCustomConversions();
        this.typeMapper = typeMapper != null ? typeMapper : new DefaultRedisTypeMapper("_class", (MappingContext)this.mappingContext);
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.referenceResolver = referenceResolver;
        this.afterPropertiesSet();
    }

    private static boolean isByteArray(RedisPersistentProperty property) {
        return !property.getType().equals(byte[].class);
    }

    private static boolean isByteArray(TypeInformation<?> type) {
        return type.getType().equals(byte[].class);
    }

    public <R> R read(Class<R> type, RedisData source) {
        TypeInformation readType = this.typeMapper.readType((Object)source.getBucket().getPath(), TypeInformation.of(type));
        if (readType.isCollectionLike()) {
            return (R)this.readCollectionOrArray(type, "", ArrayList.class, Object.class, source.getBucket());
        }
        return this.readInternal(type, "", type, source);
    }

    @Nullable
    private <R> R readInternal(Class<?> entityClass, String path, Class<R> type, RedisData source) {
        return source.getBucket().isEmpty() ? null : (R)this.doReadInternal(entityClass, path, type, source);
    }

    private <R> R doReadInternal(Class<?> entityClass, String path, Class<R> type, RedisData source) {
        TypeInformation readType = this.typeMapper.readType((Object)source.getBucket().getPath(), TypeInformation.of(type));
        if (this.customConversions.hasCustomReadTarget(Map.class, readType.getType())) {
            HashMap<String, byte[]> partial = new HashMap<String, byte[]>();
            if (!path.isEmpty()) {
                for (Map.Entry entry : source.getBucket().extract(path + ".").entrySet()) {
                    partial.put(((String)entry.getKey()).substring(path.length() + 1), (byte[])entry.getValue());
                }
            } else {
                partial.putAll(source.getBucket().asMap());
            }
            Object instance = this.conversionService.convert(partial, readType.getType());
            RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(readType);
            if (entity != null && instance != null && entity.hasIdProperty()) {
                PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(instance);
                propertyAccessor.setProperty(entity.getRequiredIdProperty(), (Object)source.getId());
                instance = propertyAccessor.getBean();
            }
            return (R)instance;
        }
        if (this.conversionService.canConvert(byte[].class, readType.getType())) {
            return (R)this.conversionService.convert((Object)source.getBucket().get(StringUtils.hasText((String)path) ? path : "_raw"), readType.getType());
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(readType);
        EntityInstantiator instantiator = this.entityInstantiators.getInstantiatorFor((PersistentEntity)entity);
        Object instance = type.isInterface() ? source.getBucket().asMap() : instantiator.createInstance((PersistentEntity)entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider((PersistentEntity)entity, (PropertyValueProvider)new ConverterAwareParameterValueProvider(entityClass, path, source, (ConversionService)this.conversionService), (Object)this.conversionService));
        if (type.isInterface()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            RedisPersistentEntity persistentEntity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(readType);
            HashMap projectionPropertyTypes = new HashMap();
            for (Method method : type.getMethods()) {
                if (method.getParameterCount() != 0 || method.getReturnType().equals(Void.TYPE)) continue;
                String propertyName = null;
                if (method.getName().startsWith("get") && method.getName().length() > 3) {
                    propertyName = StringUtils.uncapitalize((String)method.getName().substring(3));
                } else if (method.getName().startsWith("is") && method.getName().length() > 2) {
                    propertyName = StringUtils.uncapitalize((String)method.getName().substring(2));
                }
                if (propertyName == null) continue;
                projectionPropertyTypes.put(propertyName, method.getReturnType());
            }
            for (Map.Entry entry : source.getBucket().asMap().entrySet()) {
                RedisPersistentProperty persistentProperty2;
                String key = (String)entry.getKey();
                byte[] value = (byte[])entry.getValue();
                Class targetType = (Class)projectionPropertyTypes.get(key);
                Object convertedValue = targetType != null ? this.conversionService.convert((Object)value, targetType) : ((persistentProperty2 = (RedisPersistentProperty)persistentEntity.getPersistentProperty(key)) != null ? this.conversionService.convert((Object)value, persistentProperty2.getType()) : new String(value));
                map.put(key, convertedValue);
            }
            return (R)this.projectionFactory.createProjection(type, map);
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        entity.doWithProperties(persistentProperty -> {
            InstanceCreatorMetadata constructor = entity.getInstanceCreatorMetadata();
            if (constructor != null && constructor.isCreatorParameter(persistentProperty)) {
                return;
            }
            Object targetValue = this.readProperty(entityClass, path, source, (RedisPersistentProperty)persistentProperty);
            if (targetValue != null) {
                accessor.setProperty(persistentProperty, targetValue);
            }
        });
        this.readAssociation(path, source, entity, accessor);
        return (R)instance;
    }

    @Nullable
    protected Object readProperty(Class<?> entityClass, String path, RedisData source, RedisPersistentProperty persistentProperty) {
        String currentPath = !path.isEmpty() ? path + "." + persistentProperty.getName() : persistentProperty.getName();
        TypeInformation typeInformation = persistentProperty.getTypeInformation();
        if (persistentProperty.isMap()) {
            Class mapValueType = persistentProperty.getMapValueType();
            if (mapValueType == null) {
                throw new IllegalArgumentException("Unable to retrieve MapValueType!");
            }
            if (this.conversionService.canConvert(byte[].class, mapValueType)) {
                return this.readMapOfSimpleTypes(currentPath, typeInformation.getType(), typeInformation.getRequiredComponentType().getType(), mapValueType, source);
            }
            return this.readMapOfComplexTypes(entityClass, currentPath, typeInformation.getType(), typeInformation.getRequiredComponentType().getType(), mapValueType, source);
        }
        if (typeInformation.isCollectionLike()) {
            if (!MappingRedisOMConverter.isByteArray(typeInformation)) {
                return this.readCollectionOrArray(entityClass, currentPath, typeInformation.getType(), typeInformation.getRequiredComponentType().getType(), source.getBucket());
            }
            if (!source.getBucket().hasValue(currentPath) && MappingRedisOMConverter.isByteArray(typeInformation)) {
                return this.readCollectionOrArray(entityClass, currentPath, typeInformation.getType(), typeInformation.getRequiredComponentType().getType(), source.getBucket());
            }
        }
        if (persistentProperty.isEntity() && !this.conversionService.canConvert(byte[].class, typeInformation.getRequiredActualType().getType())) {
            Bucket bucket = source.getBucket().extract(currentPath + ".");
            RedisData newBucket = new RedisData(bucket);
            TypeInformation typeToRead = this.typeMapper.readType((Object)bucket.getPropertyPath(currentPath), typeInformation);
            return this.readInternal(entityClass, currentPath, typeToRead.getType(), newBucket);
        }
        byte[] sourceBytes = source.getBucket().get(currentPath);
        if (typeInformation.getType().isPrimitive() && sourceBytes == null) {
            return null;
        }
        if (persistentProperty.isIdProperty() && ObjectUtils.isEmpty((Object)path.isEmpty())) {
            return sourceBytes != null ? this.fromBytes(sourceBytes, typeInformation.getType()) : source.getId();
        }
        if (sourceBytes == null) {
            return null;
        }
        if (this.customConversions.hasCustomReadTarget(byte[].class, persistentProperty.getType())) {
            return this.fromBytes(sourceBytes, persistentProperty.getType());
        }
        Class<?> typeToUse = this.getTypeHint(currentPath, source.getBucket(), persistentProperty.getType());
        return this.fromBytes(sourceBytes, typeToUse);
    }

    private void readAssociation(String path, RedisData source, RedisPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor) {
        entity.doWithAssociations(association -> {
            String currentPath;
            String string = currentPath = !path.isEmpty() ? path + "." + ((RedisPersistentProperty)association.getInverse()).getName() : ((RedisPersistentProperty)association.getInverse()).getName();
            if (((RedisPersistentProperty)association.getInverse()).isCollectionLike()) {
                Bucket bucket = source.getBucket().extract(currentPath + ".[");
                Collection target = CollectionFactory.createCollection((Class)((RedisPersistentProperty)association.getInverse()).getType(), (Class)((RedisPersistentProperty)association.getInverse()).getComponentType(), (int)bucket.size());
                for (Map.Entry entry : bucket.entrySet()) {
                    KeyspaceIdentifier identifier;
                    Map rawHash;
                    String referenceKey = this.fromBytes((byte[])entry.getValue(), String.class);
                    if (!KeyspaceIdentifier.isValid(referenceKey) || CollectionUtils.isEmpty((Map)(rawHash = this.referenceResolver.resolveReference((Object)(identifier = KeyspaceIdentifier.of(referenceKey)).getId(), identifier.getKeyspace())))) continue;
                    target.add(this.read(((RedisPersistentProperty)association.getInverse()).getActualType(), new RedisData(rawHash)));
                }
                accessor.setProperty(association.getInverse(), (Object)target);
            } else {
                KeyspaceIdentifier identifier;
                Map rawHash;
                byte[] binKey = source.getBucket().get(currentPath);
                if (binKey == null || binKey.length == 0) {
                    return;
                }
                String referenceKey = this.fromBytes(binKey, String.class);
                if (KeyspaceIdentifier.isValid(referenceKey) && !CollectionUtils.isEmpty((Map)(rawHash = this.referenceResolver.resolveReference((Object)(identifier = KeyspaceIdentifier.of(referenceKey)).getId(), identifier.getKeyspace())))) {
                    accessor.setProperty(association.getInverse(), this.read(((RedisPersistentProperty)association.getInverse()).getActualType(), new RedisData(rawHash)));
                }
            }
        });
    }

    public void write(Object source, RedisData sink) {
        if (source == null) {
            return;
        }
        if (source instanceof PartialUpdate) {
            PartialUpdate pu = (PartialUpdate)source;
            this.writePartialUpdate(pu, sink);
            return;
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        if (!this.customConversions.hasCustomWriteTarget(source.getClass())) {
            this.typeMapper.writeType(ClassUtils.getUserClass((Object)source), (Object)sink.getBucket().getPath());
        }
        this.writeEntity(entity, source, sink);
    }

    private void writeEntity(RedisPersistentEntity<?> entity, Object source, RedisData sink) {
        Long ttl;
        if (entity == null) {
            this.typeMapper.writeType(ClassUtils.getUserClass((Object)source), (Object)sink.getBucket().getPath());
            sink.getBucket().put("_raw", (byte[])this.conversionService.convert(source, byte[].class));
            return;
        }
        sink.setKeyspace(entity.getKeySpace());
        if (entity.getTypeInformation().isCollectionLike()) {
            this.writeCollection(entity.getType(), entity.getKeySpace(), "", (List)source, entity.getTypeInformation().getRequiredComponentType(), sink);
        } else {
            this.writeInternal(entity.getKeySpace(), "", source, entity.getTypeInformation(), sink);
        }
        Object identifier = entity.getIdentifierAccessor(source).getIdentifier();
        if (identifier != null) {
            sink.setId((String)this.getConversionService().convert(identifier, String.class));
        }
        if ((ttl = entity.getTimeToLiveAccessor().getTimeToLive(source)) != null && ttl > 0L) {
            sink.setTimeToLive(ttl);
        }
    }

    protected void writePartialUpdate(PartialUpdate<?> update, RedisData sink) {
        Long ttl;
        RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(update.getTarget());
        this.write(update.getValue(), sink);
        for (String key : sink.getBucket().keySet()) {
            if (!this.typeMapper.isTypeKey(key)) continue;
            sink.getBucket().remove(key);
            break;
        }
        if (update.isRefreshTtl() && !update.getPropertyUpdates().isEmpty() && (ttl = entity.getTimeToLiveAccessor().getTimeToLive(update)) != null && ttl > 0L) {
            sink.setTimeToLive(ttl);
        }
        for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
            String path = pUpdate.getPropertyPath();
            if (!PartialUpdate.UpdateCommand.SET.equals((Object)pUpdate.getCmd())) continue;
            this.writePartialPropertyUpdate(update, pUpdate, sink, entity, path);
        }
    }

    private void writePartialPropertyUpdate(PartialUpdate<?> update, PartialUpdate.PropertyUpdate pUpdate, RedisData sink, RedisPersistentEntity<?> entity, String path) {
        RedisPersistentProperty targetProperty = this.getTargetPropertyOrNullForPath(path, update.getTarget());
        if (targetProperty == null) {
            targetProperty = this.getTargetPropertyOrNullForPath(path.replaceAll("\\.\\[.*]", ""), update.getTarget());
            TypeInformation ti = targetProperty == null ? TypeInformation.OBJECT : (targetProperty.isMap() ? (targetProperty.getTypeInformation().getMapValueType() != null ? targetProperty.getTypeInformation().getRequiredMapValueType() : TypeInformation.OBJECT) : targetProperty.getTypeInformation().getActualType());
            this.writeInternal(entity.getKeySpace(), pUpdate.getPropertyPath(), pUpdate.getValue(), ti, sink);
            return;
        }
        if (targetProperty.isAssociation()) {
            if (targetProperty.isCollectionLike()) {
                RedisPersistentEntity ref = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(((RedisPersistentProperty)targetProperty.getRequiredAssociation().getInverse()).getTypeInformation().getRequiredComponentType().getRequiredActualType());
                int i = 0;
                for (Object o : (Collection)pUpdate.getValue()) {
                    Object refId = ref.getPropertyAccessor(o).getProperty(ref.getRequiredIdProperty());
                    if (refId == null) continue;
                    sink.getBucket().put(pUpdate.getPropertyPath() + ".[" + i + "]", this.toBytes(ref.getKeySpace() + ":" + String.valueOf(refId)));
                    ++i;
                }
            } else {
                RedisPersistentEntity ref = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(((RedisPersistentProperty)targetProperty.getRequiredAssociation().getInverse()).getTypeInformation());
                Object refId = ref.getPropertyAccessor(pUpdate.getValue()).getProperty(ref.getRequiredIdProperty());
                if (refId != null) {
                    sink.getBucket().put(pUpdate.getPropertyPath(), this.toBytes(ref.getKeySpace() + ":" + String.valueOf(refId)));
                }
            }
        } else if (targetProperty.isCollectionLike() && MappingRedisOMConverter.isByteArray(targetProperty)) {
            Set<Object> collection = pUpdate.getValue() instanceof Collection ? (Set<Object>)pUpdate.getValue() : Collections.singleton(pUpdate.getValue());
            this.writeCollection(entity.getType(), entity.getKeySpace(), pUpdate.getPropertyPath(), collection, targetProperty.getTypeInformation().getRequiredActualType(), sink);
        } else if (targetProperty.isMap()) {
            HashMap map = new HashMap();
            if (pUpdate.getValue() instanceof Map) {
                map.putAll((Map)pUpdate.getValue());
            } else if (pUpdate.getValue() instanceof Map.Entry) {
                map.put(((Map.Entry)pUpdate.getValue()).getKey(), ((Map.Entry)pUpdate.getValue()).getValue());
            } else {
                throw new MappingException(String.format("Cannot set update value for map property '%s' to '%s'. Please use a Map or Map.Entry.", pUpdate.getPropertyPath(), pUpdate.getValue()));
            }
            this.writeMap(entity.getType(), entity.getKeySpace(), pUpdate.getPropertyPath(), targetProperty.getMapValueType(), map, sink);
        } else {
            this.writeInternal(entity.getKeySpace(), pUpdate.getPropertyPath(), pUpdate.getValue(), targetProperty.getTypeInformation(), sink);
        }
    }

    @Nullable
    RedisPersistentProperty getTargetPropertyOrNullForPath(String path, Class<?> type) {
        try {
            PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(path, type);
            return (RedisPersistentProperty)persistentPropertyPath.getLeafProperty();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void writeInternal(@Nullable String keyspace, String path, @Nullable Object value, TypeInformation<?> typeHint, RedisData sink) {
        if (value == null) {
            return;
        }
        if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
            Optional targetType = this.customConversions.getCustomWriteTarget(value.getClass());
            if (!StringUtils.hasText((String)path) && targetType.isPresent() && ClassUtils.isAssignable(byte[].class, (Class)((Class)targetType.get()))) {
                sink.getBucket().put(StringUtils.hasText((String)path) ? path : "_raw", (byte[])this.conversionService.convert(value, byte[].class));
            } else {
                if (!ClassUtils.isAssignable((Class)typeHint.getType(), value.getClass())) {
                    throw new MappingException(String.format(INVALID_TYPE_ASSIGNMENT, value.getClass(), path, typeHint.getType()));
                }
                this.writeToBucket(path, value, sink, typeHint.getType());
            }
            return;
        }
        if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            sink.getBucket().put(StringUtils.hasText((String)path) ? path : "_raw", ba);
            return;
        }
        if (value.getClass() != typeHint.getType()) {
            this.typeMapper.writeType(value.getClass(), (Object)sink.getBucket().getPropertyPath(path));
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        entity.doWithProperties(persistentProperty -> {
            String propertyStringPath = (String)(!path.isEmpty() ? path + "." : "") + persistentProperty.getName();
            Object propertyValue = accessor.getProperty(persistentProperty);
            if (persistentProperty.isIdProperty()) {
                if (propertyValue == null) return;
                sink.getBucket().put(propertyStringPath, this.toBytes(propertyValue));
                return;
            }
            if (persistentProperty.isMap()) {
                if (propertyValue == null) return;
                this.writeMap(entity.getType(), keyspace, propertyStringPath, persistentProperty.getMapValueType(), (Map)propertyValue, sink);
                return;
            } else if (persistentProperty.isCollectionLike() && MappingRedisOMConverter.isByteArray(persistentProperty)) {
                if (propertyValue == null) {
                    this.writeCollection(entity.getType(), keyspace, propertyStringPath, null, persistentProperty.getTypeInformation().getRequiredComponentType(), sink);
                    return;
                } else if (Iterable.class.isAssignableFrom(propertyValue.getClass())) {
                    this.writeCollection(entity.getType(), keyspace, propertyStringPath, (Iterable)propertyValue, persistentProperty.getTypeInformation().getRequiredComponentType(), sink);
                    return;
                } else {
                    if (!propertyValue.getClass().isArray()) throw new RuntimeException("Don't know how to handle " + String.valueOf(propertyValue.getClass()) + " type collection");
                    this.writeCollection(entity.getType(), keyspace, propertyStringPath, CollectionUtils.arrayToList((Object)propertyValue), persistentProperty.getTypeInformation().getRequiredComponentType(), sink);
                }
                return;
            } else if (persistentProperty.isEntity()) {
                if (propertyValue == null) return;
                this.writeInternal(keyspace, propertyStringPath, propertyValue, persistentProperty.getTypeInformation().getRequiredActualType(), sink);
                return;
            } else {
                if (propertyValue == null) return;
                this.writeToBucket(propertyStringPath, propertyValue, sink, persistentProperty.getType());
            }
        });
        this.writeAssociation(path, entity, value, sink);
    }

    private void writeAssociation(String path, RedisPersistentEntity<?> entity, @Nullable Object value, RedisData sink) {
        if (value == null) {
            return;
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        entity.doWithAssociations(association -> {
            Object refObject = accessor.getProperty(association.getInverse());
            if (refObject == null) {
                return;
            }
            if (((RedisPersistentProperty)association.getInverse()).isCollectionLike()) {
                RedisPersistentEntity ref = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(((RedisPersistentProperty)association.getInverse()).getTypeInformation().getRequiredComponentType().getRequiredActualType());
                String keyspace = ref.getKeySpace();
                String propertyStringPath = (String)(!path.isEmpty() ? path + "." : "") + ((RedisPersistentProperty)association.getInverse()).getName();
                int i = 0;
                for (Object o : (Collection)refObject) {
                    Object refId = ref.getPropertyAccessor(o).getProperty(ref.getRequiredIdProperty());
                    if (refId == null) continue;
                    sink.getBucket().put(propertyStringPath + ".[" + i + "]", this.toBytes(keyspace + ":" + String.valueOf(refId)));
                    ++i;
                }
            } else {
                Object refId;
                RedisPersistentEntity ref = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(((RedisPersistentProperty)association.getInverse()).getTypeInformation());
                String keyspace = ref.getKeySpace();
                if (keyspace != null && (refId = ref.getPropertyAccessor(refObject).getProperty(ref.getRequiredIdProperty())) != null) {
                    String propertyStringPath = (String)(!path.isEmpty() ? path + "." : "") + ((RedisPersistentProperty)association.getInverse()).getName();
                    sink.getBucket().put(propertyStringPath, this.toBytes(keyspace + ":" + String.valueOf(refId)));
                }
            }
        });
    }

    private void writeCollection(Class<?> entityClass, @Nullable String keyspace, String path, @Nullable Iterable<?> values, TypeInformation<?> typeHint, RedisData sink) {
        if (values == null) {
            return;
        }
        Field field = null;
        Class collectionElementType = null;
        Indexed indexed = null;
        TagIndexed tagIndexed = null;
        try {
            field = ReflectionUtils.findField(entityClass, (String)path);
            if (field != null) {
                Optional<Class<?>> maybeCollectionElementType = com.redis.om.spring.util.ObjectUtils.getCollectionElementClass(field);
                collectionElementType = maybeCollectionElementType.orElse(null);
                if (field.isAnnotationPresent(Indexed.class)) {
                    indexed = field.getAnnotation(Indexed.class);
                } else if (field.isAnnotationPresent(TagIndexed.class)) {
                    tagIndexed = field.getAnnotation(TagIndexed.class);
                }
            }
        }
        catch (SecurityException | NoSuchElementException maybeCollectionElementType) {
            // empty catch block
        }
        if (field != null && collectionElementType != null && (indexed != null || tagIndexed != null) && CharSequence.class.isAssignableFrom(collectionElementType)) {
            String separator = indexed != null ? indexed.separator() : tagIndexed.separator();
            String value = StreamSupport.stream(values.spliterator(), false).map(Object::toString).map(QueryUtils::escape).collect(Collectors.joining(separator));
            this.writeInternal(keyspace, path, value, typeHint, sink);
        } else {
            int i = 0;
            for (Object value : values) {
                if (value == null) break;
                String currentPath = path + (path.isEmpty() ? "" : ".") + "[" + i + "]";
                if (!ClassUtils.isAssignable((Class)typeHint.getType(), value.getClass())) {
                    throw new MappingException(String.format(INVALID_TYPE_ASSIGNMENT, value.getClass(), currentPath, typeHint.getType()));
                }
                if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
                    this.writeToBucket(currentPath, value, sink, typeHint.getType());
                } else {
                    this.writeInternal(keyspace, currentPath, value, typeHint, sink);
                }
                ++i;
            }
        }
    }

    private void writeToBucket(String path, @Nullable Object value, RedisData sink, Class<?> propertyType) {
        if (value == null || value instanceof Optional && ((Optional)value).isEmpty()) {
            return;
        }
        if (value instanceof byte[]) {
            sink.getBucket().put(path, this.toBytes(value));
            return;
        }
        if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
            Optional targetType = this.customConversions.getCustomWriteTarget(value.getClass());
            if (!propertyType.isPrimitive() && targetType.filter(it -> ClassUtils.isAssignable(Map.class, (Class)it)).isEmpty() && this.customConversions.isSimpleType(value.getClass()) && value.getClass() != propertyType) {
                this.typeMapper.writeType(value.getClass(), (Object)sink.getBucket().getPropertyPath(path));
            }
            if (targetType.filter(it -> ClassUtils.isAssignable(Map.class, (Class)it)).isPresent()) {
                Map map = (Map)this.conversionService.convert(value, (Class)targetType.get());
                for (Map.Entry entry : map.entrySet()) {
                    sink.getBucket().put(path + (StringUtils.hasText((String)path) ? "." : "") + String.valueOf(entry.getKey()), this.toBytes(entry.getValue()));
                }
            } else if (targetType.filter(it -> ClassUtils.isAssignable(byte[].class, (Class)it)).isPresent()) {
                sink.getBucket().put(path, this.toBytes(value));
            } else {
                throw new IllegalArgumentException(String.format("Cannot convert value '%s' of type %s to bytes.", value, value.getClass()));
            }
        }
    }

    @Nullable
    private Object readCollectionOrArray(Class<?> entityClass, String path, Class<?> collectionType, Class<?> valueType, Bucket bucket) {
        Collection target;
        Field field = null;
        Class collectionElementType = null;
        Indexed indexed = null;
        TagIndexed tagIndexed = null;
        try {
            field = ReflectionUtils.findField(entityClass, (String)path);
            if (field != null) {
                Optional<Class<?>> maybeCollectionElementType = com.redis.om.spring.util.ObjectUtils.getCollectionElementClass(field);
                collectionElementType = maybeCollectionElementType.orElse(null);
                if (field.isAnnotationPresent(Indexed.class)) {
                    indexed = field.getAnnotation(Indexed.class);
                } else if (field.isAnnotationPresent(TagIndexed.class)) {
                    tagIndexed = field.getAnnotation(TagIndexed.class);
                }
            }
        }
        catch (SecurityException | NoSuchElementException maybeCollectionElementType) {
            // empty catch block
        }
        boolean isArray = collectionType.isArray();
        if (field != null && (indexed != null || tagIndexed != null) && collectionElementType != null && CharSequence.class.isAssignableFrom(collectionElementType)) {
            String separator = indexed != null ? indexed.separator() : tagIndexed.separator();
            Bucket elementData = bucket.extract(path);
            TypeInformation typeInformation = this.typeMapper.readType((Object)elementData.getPropertyPath(path), TypeInformation.of(valueType));
            Class collectionTypeToUse = isArray ? ArrayList.class : collectionType;
            Class typeToUse = typeInformation.getType();
            String collectionAsString = this.conversionService.canConvert(byte[].class, typeToUse) ? (String)this.fromBytes(elementData.get(path), typeToUse) : (String)this.readInternal(entityClass, path, typeToUse, new RedisData(elementData));
            if (collectionAsString == null) {
                collectionAsString = "";
            }
            List<String> values = Arrays.stream(collectionAsString.split("\\" + separator)).map(QueryUtils::unescape).toList();
            target = CollectionFactory.createCollection(collectionTypeToUse, valueType, (int)values.size());
            target.addAll(values);
        } else {
            ArrayList<String> keys = new ArrayList<String>(bucket.extractAllKeysFor(path));
            keys.sort(this.listKeyComparator);
            Class collectionTypeToUse = isArray ? ArrayList.class : collectionType;
            target = CollectionFactory.createCollection(collectionTypeToUse, valueType, (int)keys.size());
            for (String key : keys) {
                if (this.typeMapper.isTypeKey(key)) continue;
                Bucket elementData = bucket.extract(key);
                TypeInformation typeInformation = this.typeMapper.readType((Object)elementData.getPropertyPath(key), TypeInformation.of(valueType));
                Class typeToUse = typeInformation.getType();
                if (this.conversionService.canConvert(byte[].class, typeToUse)) {
                    target.add(this.fromBytes(elementData.get(key), typeToUse));
                    continue;
                }
                target.add(this.readInternal(entityClass, key, typeToUse, new RedisData(elementData)));
            }
        }
        return isArray ? this.toArray(target, collectionType, valueType) : (target.isEmpty() ? null : target);
    }

    private void writeMap(Class<?> entityClass, @Nullable String keyspace, String path, Class<?> mapValueType, Map<?, ?> source, RedisData sink) {
        if (CollectionUtils.isEmpty(source)) {
            return;
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            String currentPath = path + ".[" + this.mapMapKey(entry.getKey()) + "]";
            if (!ClassUtils.isAssignable(mapValueType, entry.getValue().getClass())) {
                throw new MappingException(String.format(INVALID_TYPE_ASSIGNMENT, entry.getValue().getClass(), currentPath, mapValueType));
            }
            if (this.customConversions.hasCustomWriteTarget(entry.getValue().getClass())) {
                this.writeToBucket(currentPath, entry.getValue(), sink, mapValueType);
                continue;
            }
            this.writeInternal(keyspace, currentPath, entry.getValue(), TypeInformation.of(mapValueType), sink);
        }
    }

    private String mapMapKey(Object key) {
        if (this.conversionService.canConvert(key.getClass(), byte[].class)) {
            return new String((byte[])this.conversionService.convert(key, byte[].class));
        }
        return (String)this.conversionService.convert(key, String.class);
    }

    @Nullable
    private Map<?, ?> readMapOfSimpleTypes(String path, Class<?> mapType, Class<?> keyType, Class<?> valueType, RedisData source) {
        Bucket partial = source.getBucket().extract(path + ".[");
        Map target = CollectionFactory.createMap(mapType, (int)partial.size());
        for (Map.Entry entry : partial.entrySet()) {
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = this.extractMapKeyForPath(path, (String)entry.getKey(), keyType);
            Class<?> typeToUse = this.getTypeHint(path + ".[" + String.valueOf(key) + "]", source.getBucket(), valueType);
            target.put(key, this.fromBytes((byte[])entry.getValue(), typeToUse));
        }
        return target.isEmpty() ? null : target;
    }

    @Nullable
    private Map<?, ?> readMapOfComplexTypes(Class<?> entityClass, String path, Class<?> mapType, Class<?> keyType, Class<?> valueType, RedisData source) {
        Set keys = source.getBucket().extractAllKeysFor(path);
        Map target = CollectionFactory.createMap(mapType, (int)keys.size());
        for (String key : keys) {
            Bucket partial = source.getBucket().extract(key);
            Object mapKey = this.extractMapKeyForPath(path, key, keyType);
            TypeInformation typeInformation = this.typeMapper.readType((Object)source.getBucket().getPropertyPath(key), TypeInformation.of(valueType));
            Object o = this.readInternal(entityClass, key, typeInformation.getType(), new RedisData(partial));
            target.put(mapKey, o);
        }
        return target.isEmpty() ? null : target;
    }

    @Nullable
    private Object extractMapKeyForPath(String path, String key, Class<?> targetType) {
        String regex = "^(" + Pattern.quote(path) + "\\.\\[)(.*?)(])";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(key);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Cannot extract map value for key '%s' in path '%s'.", key, path));
        }
        String mapKey = matcher.group(2);
        if (ClassUtils.isAssignable(targetType, mapKey.getClass())) {
            return mapKey;
        }
        return this.conversionService.convert((Object)this.toBytes(mapKey), targetType);
    }

    private Class<?> getTypeHint(String path, Bucket bucket, Class<?> fallback) {
        TypeInformation typeInformation = this.typeMapper.readType((Object)bucket.getPropertyPath(path), TypeInformation.of(fallback));
        return typeInformation.getType();
    }

    public byte[] toBytes(Object source) {
        if (source instanceof byte[]) {
            byte[] ba = (byte[])source;
            return ba;
        }
        return (byte[])this.conversionService.convert(source, byte[].class);
    }

    public <T> T fromBytes(byte[] source, Class<T> type) {
        if (type.isInstance(source)) {
            return type.cast(source);
        }
        return (T)this.conversionService.convert((Object)source, type);
    }

    @Nullable
    private Object toArray(Collection<Object> source, Class<?> arrayType, Class<?> valueType) {
        if (source.isEmpty()) {
            return null;
        }
        if (!ClassUtils.isPrimitiveArray(arrayType)) {
            return source.toArray((Object[])Array.newInstance(valueType, source.size()));
        }
        Object targetArray = Array.newInstance(valueType, source.size());
        Iterator<Object> iterator = source.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Array.set(targetArray, i, this.conversionService.convert(iterator.next(), valueType));
            ++i;
        }
        return i > 0 ? targetArray : null;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setCustomConversions(@Nullable CustomConversions customConversions) {
        this.customConversions = customConversions != null ? customConversions : new RedisCustomConversions();
    }

    public RedisMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Nullable
    public IndexResolver getIndexResolver() {
        return null;
    }

    public EntityInstantiators getEntityInstantiators() {
        return this.entityInstantiators;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    private void initializeConverters() {
        this.customConversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    private static enum NaturalOrderingKeyComparator implements Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String s1, String s2) {
            Part thatPart;
            Part thisPart;
            int s1offset = 0;
            for (int s2offset = 0; s1offset < s1.length() && s2offset < s2.length(); s1offset += thisPart.length(), s2offset += thatPart.length()) {
                thisPart = this.extractPart(s1, s1offset);
                int result = thisPart.compareTo(thatPart = this.extractPart(s2, s2offset));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private Part extractPart(String source, int offset) {
            StringBuilder builder = new StringBuilder();
            char c = source.charAt(offset);
            builder.append(c);
            boolean isDigit = Character.isDigit(c);
            for (int i = offset + 1; i < source.length(); ++i) {
                c = source.charAt(i);
                if (isDigit && !Character.isDigit(c) || !isDigit && Character.isDigit(c)) break;
                builder.append(c);
            }
            return new Part(builder.toString(), isDigit);
        }

        private static class Part
        implements Comparable<Part> {
            private final String rawValue;
            @Nullable
            private final Long longValue;

            Part(String value, boolean isDigit) {
                this.rawValue = value;
                this.longValue = isDigit ? Long.valueOf(value) : null;
            }

            boolean isNumeric() {
                return this.longValue != null;
            }

            int length() {
                return this.rawValue.length();
            }

            @Override
            public int compareTo(Part that) {
                if (this.isNumeric() && that.isNumeric()) {
                    return this.longValue.compareTo(that.longValue);
                }
                return this.rawValue.compareTo(that.rawValue);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null) {
                    return false;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                Part part = (Part)o;
                if (this.isNumeric() && part.isNumeric()) {
                    return this.longValue.equals(part.longValue);
                }
                return this.rawValue.equals(part.rawValue);
            }

            public int hashCode() {
                return Objects.hash(this.longValue);
            }
        }
    }

    private class ConverterAwareParameterValueProvider
    implements PropertyValueProvider<RedisPersistentProperty> {
        private final String path;
        private final RedisData source;
        private final ConversionService conversionService;
        private final Class<?> entityClass;

        ConverterAwareParameterValueProvider(Class<?> entityClass, String path, RedisData source, ConversionService conversionService) {
            this.entityClass = entityClass;
            this.path = path;
            this.source = source;
            this.conversionService = conversionService;
        }

        public <T> T getPropertyValue(RedisPersistentProperty property) {
            Object value = MappingRedisOMConverter.this.readProperty(this.entityClass, this.path, this.source, property);
            if (value == null || ClassUtils.isAssignableValue((Class)property.getType(), (Object)value)) {
                return (T)value;
            }
            return (T)this.conversionService.convert(value, property.getType());
        }
    }

    public static class KeyspaceIdentifier {
        public static final String PHANTOM = "phantom";
        public static final String DELIMITER = ":";
        public static final String PHANTOM_SUFFIX = ":phantom";
        private final String keyspace;
        private final String id;
        private final boolean phantomKey;

        private KeyspaceIdentifier(String keyspace, String id, boolean phantomKey) {
            this.keyspace = keyspace;
            this.id = id;
            this.phantomKey = phantomKey;
        }

        public static KeyspaceIdentifier of(String key) {
            Assert.isTrue((boolean)KeyspaceIdentifier.isValid(key), (String)String.format("Invalid key %s", key));
            boolean phantomKey = key.endsWith(PHANTOM_SUFFIX);
            int keyspaceEndIndex = key.indexOf(DELIMITER);
            String keyspace = key.substring(0, keyspaceEndIndex);
            String id = phantomKey ? key.substring(keyspaceEndIndex + 1, key.length() - PHANTOM_SUFFIX.length()) : key.substring(keyspaceEndIndex + 1);
            return new KeyspaceIdentifier(keyspace, id, phantomKey);
        }

        public static boolean isValid(@Nullable String key) {
            if (key == null) {
                return false;
            }
            int keyspaceEndIndex = key.indexOf(DELIMITER);
            return keyspaceEndIndex > 0;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getId() {
            return this.id;
        }

        public boolean isPhantomKey() {
            return this.phantomKey;
        }
    }

    public static class BinaryKeyspaceIdentifier {
        public static final byte DELIMITER = 58;
        protected static final byte[] PHANTOM = "phantom".getBytes();
        protected static final byte[] PHANTOM_SUFFIX = ByteUtils.concat((byte[])new byte[]{58}, (byte[])PHANTOM);
        private final byte[] keyspace;
        private final byte[] id;
        private final boolean phantomKey;

        private BinaryKeyspaceIdentifier(byte[] keyspace, byte[] id, boolean phantomKey) {
            this.keyspace = keyspace;
            this.id = id;
            this.phantomKey = phantomKey;
        }

        public static BinaryKeyspaceIdentifier of(byte[] key) {
            Assert.isTrue((boolean)BinaryKeyspaceIdentifier.isValid(key), (String)String.format("Invalid key %s", new String(key)));
            boolean phantomKey = ByteUtils.startsWith((byte[])key, (byte[])PHANTOM_SUFFIX, (int)(key.length - PHANTOM_SUFFIX.length));
            int keyspaceEndIndex = ByteUtils.indexOf((byte[])key, (byte)58);
            byte[] keyspace = BinaryKeyspaceIdentifier.extractKeyspace(key, keyspaceEndIndex);
            byte[] id = BinaryKeyspaceIdentifier.extractId(key, phantomKey, keyspaceEndIndex);
            return new BinaryKeyspaceIdentifier(keyspace, id, phantomKey);
        }

        public static boolean isValid(byte[] key) {
            if (key.length == 0) {
                return false;
            }
            int keyspaceEndIndex = ByteUtils.indexOf((byte[])key, (byte)58);
            return keyspaceEndIndex > 0 && key.length > keyspaceEndIndex;
        }

        private static byte[] extractId(byte[] key, boolean phantomKey, int keyspaceEndIndex) {
            int idSize = phantomKey ? key.length - PHANTOM_SUFFIX.length - (keyspaceEndIndex + 1) : key.length - (keyspaceEndIndex + 1);
            byte[] id = new byte[idSize];
            System.arraycopy(key, keyspaceEndIndex + 1, id, 0, idSize);
            return id;
        }

        private static byte[] extractKeyspace(byte[] key, int keyspaceEndIndex) {
            byte[] keyspace = new byte[keyspaceEndIndex];
            System.arraycopy(key, 0, keyspace, 0, keyspaceEndIndex);
            return keyspace;
        }

        public byte[] getKeyspace() {
            return this.keyspace;
        }

        public byte[] getId() {
            return this.id;
        }

        public boolean isPhantomKey() {
            return this.phantomKey;
        }
    }
}

