/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.indexing;

import com.github.f4b6a3.ulid.Ulid;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.DocumentScore;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.IndexingOptions;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.SchemaFieldType;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.SerializationHint;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.annotations.VectorIndexed;
import com.redis.om.spring.id.IdFilter;
import com.redis.om.spring.id.IdentifierFilter;
import com.redis.om.spring.indexing.SearchField;
import com.redis.om.spring.mapping.RedisEnhancedMappingContext;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.serialization.gson.EnumTypeAdapter;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.Tuples;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.Reference;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.search.FTCreateParams;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.IndexDataType;
import redis.clients.jedis.search.schemafields.GeoField;
import redis.clients.jedis.search.schemafields.NumericField;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TagField;
import redis.clients.jedis.search.schemafields.TextField;
import redis.clients.jedis.search.schemafields.VectorField;

@Component
public class RediSearchIndexer {
    private static final Log logger = LogFactory.getLog(RediSearchIndexer.class);
    private static final String SKIPPING_INDEX_CREATION = "Skipping index creation for %s because %s";
    private final Map<String, Class<?>> keyspaceToEntityClass = new ConcurrentHashMap();
    private final Map<Class<?>, String> entityClassToKeySpace = new ConcurrentHashMap();
    private final Map<Class<?>, String> entityClassToIndexName = new ConcurrentHashMap();
    private final Map<Class<?>, IdentifierFilter<?>> entityClassToIdentifierFilter = new ConcurrentHashMap();
    private final List<Class<?>> indexedEntityClasses = new ArrayList();
    private final Map<Class<?>, List<SearchField>> entityClassToSchema = new ConcurrentHashMap();
    private final Map<Pair<Class<?>, String>, String> entityClassFieldToAlias = new ConcurrentHashMap();
    private final Map<Class<?>, Set<String>> entityClassToLexicographicFields = new ConcurrentHashMap();
    private final ApplicationContext ac;
    private final RedisModulesOperations<String> rmo;
    private final RedisMappingContext mappingContext;
    private final GsonBuilder gsonBuilder;
    private final RedisOMProperties properties;

    public RediSearchIndexer(ApplicationContext ac, RedisOMProperties properties, GsonBuilder gsonBuilder) {
        this.ac = ac;
        this.properties = properties;
        this.rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        this.mappingContext = (RedisMappingContext)ac.getBean("redisEnhancedMappingContext");
        this.gsonBuilder = gsonBuilder;
    }

    public void createIndicesFor(Class<?> cls) {
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>(ObjectUtils.getBeanDefinitionsFor(this.ac, cls));
        logger.info((Object)String.format("Found %s @%s annotated Beans...", beanDefs.size(), cls.getSimpleName()));
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                logger.info((Object)String.format("Creating index for %s annotated Entity...", cl.getSimpleName()));
                this.createIndexFor(cl);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, beanDef.getBeanClassName(), e.getMessage()));
            }
        }
    }

    public void createIndexFor(Class<?> cl) {
        Optional<IndexDataType> maybeType = this.determineIndexTarget(cl);
        if (!maybeType.isPresent()) {
            return;
        }
        IndexDataType idxType = maybeType.get();
        boolean isDocument = idxType == IndexDataType.JSON;
        Optional<Document> document = isDocument ? Optional.of(cl.getAnnotation(Document.class)) : Optional.empty();
        Optional<RedisHash> hash = !isDocument ? Optional.of(cl.getAnnotation(RedisHash.class)) : Optional.empty();
        Optional<IndexingOptions> maybeIndexingOptions = Optional.ofNullable(cl.getAnnotation(IndexingOptions.class));
        Object indexName = "";
        try {
            Optional<String> maybeEntityPrefix;
            if (isDocument) {
                if (maybeIndexingOptions.isPresent()) {
                    indexName = maybeIndexingOptions.get().indexName();
                }
                indexName = ((String)indexName).isBlank() ? ((Document)document.get()).indexName() : indexName;
                indexName = ((String)indexName).isBlank() ? cl.getName() + "Idx" : indexName;
            } else {
                indexName = maybeIndexingOptions.isPresent() ? (((String)(indexName = maybeIndexingOptions.get().indexName())).isBlank() ? cl.getName() + "Idx" : indexName) : cl.getName() + "Idx";
            }
            logger.info((Object)String.format("Found @%s annotated class: %s", idxType, cl.getName()));
            List<Field> allClassFields = ObjectUtils.getDeclaredFieldsTransitively(cl);
            List<SearchField> searchFields = this.processIndexedFields(allClassFields, isDocument);
            for (SearchField field : searchFields) {
                this.registerAlias(cl, field.getField().getName(), field.getSchemaField().getFieldName().getAttribute());
            }
            Optional<String> maybeScoreField = this.getDocumentScoreField(allClassFields, isDocument);
            this.createIndexedFieldsForIdFields(cl, searchFields.stream().map(SearchField::getSchemaField).toList(), isDocument).forEach(searchFields::add);
            SearchOperations<String> opsForSearch = this.rmo.opsForSearch((String)indexName);
            FTCreateParams params = this.createIndexDefinition(cl, idxType);
            if (isDocument) {
                maybeEntityPrefix = document.map(Document::value).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty);
                maybeScoreField.ifPresent(arg_0 -> ((FTCreateParams)params).scoreField(arg_0));
            } else {
                maybeEntityPrefix = hash.map(RedisHash::value).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty);
            }
            Object entityPrefix = maybeEntityPrefix.orElse(this.getEntityPrefix(cl));
            entityPrefix = ((String)entityPrefix).endsWith(":") ? entityPrefix : (String)entityPrefix + ":";
            params.prefix(new String[]{entityPrefix});
            this.addKeySpaceMapping((String)entityPrefix, cl);
            this.updateTTLSettings(cl, (String)entityPrefix, isDocument, document, allClassFields);
            List<SchemaField> fields = searchFields.stream().map(SearchField::getSchemaField).toList();
            this.entityClassToSchema.put(cl, searchFields);
            this.entityClassToIndexName.put(cl, (String)indexName);
            if (maybeIndexingOptions.isPresent()) {
                IndexingOptions options = maybeIndexingOptions.get();
                switch (options.creationMode()) {
                    case SKIP_IF_EXIST: {
                        opsForSearch.createIndex(params, fields);
                        logger.info((Object)String.format("Created index %s...", indexName));
                        this.createSortedSetsForLexicographicFields(cl, (String)entityPrefix);
                        break;
                    }
                    case DROP_AND_RECREATE: {
                        if (this.indexExistsFor(cl)) {
                            opsForSearch.dropIndex();
                            logger.info((Object)String.format("Dropped index %s", indexName));
                        }
                        opsForSearch.createIndex(params, fields);
                        logger.info((Object)String.format("Created index %s", indexName));
                        this.createSortedSetsForLexicographicFields(cl, (String)entityPrefix);
                        break;
                    }
                    case SKIP_ALWAYS: {
                        logger.info((Object)String.format("Skipped index creation for %s", cl.getSimpleName()));
                    }
                }
            } else {
                opsForSearch.createIndex(params, fields);
                logger.info((Object)String.format("Created index %s", indexName));
            }
            this.createSortedSetsForLexicographicFields(cl, (String)entityPrefix);
        }
        catch (Exception e) {
            logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, indexName, e.getMessage()));
        }
    }

    public void dropIndexAndDocumentsFor(Class<?> cl) {
        this.dropIndex(cl, true, false);
    }

    public void dropAndRecreateIndexFor(Class<?> cl) {
        this.dropIndex(cl, false, true);
    }

    public void dropIndexFor(Class<?> cl) {
        this.dropIndex(cl, false, false);
    }

    public String getIndexName(String keyspace) {
        return this.getIndexName(this.keyspaceToEntityClass.get(this.getKeyspace(keyspace)));
    }

    public String getIndexName(Class<?> entityClass) {
        if (entityClass != null && this.entityClassToIndexName.containsKey(entityClass)) {
            return this.entityClassToIndexName.get(entityClass);
        }
        return entityClass.getName() + "Idx";
    }

    public void addKeySpaceMapping(String keyspace, Class<?> entityClass) {
        String key = this.getKeyspace(keyspace);
        this.keyspaceToEntityClass.put(key, entityClass);
        this.entityClassToKeySpace.put(entityClass, key);
        this.indexedEntityClasses.add(entityClass);
    }

    public void removeKeySpaceMapping(String keyspace, Class<?> entityClass) {
        String key = this.getKeyspace(keyspace);
        this.keyspaceToEntityClass.remove(key);
        this.entityClassToKeySpace.remove(entityClass);
        this.indexedEntityClasses.remove(entityClass);
    }

    public Class<?> getEntityClassForKeyspace(String keyspace) {
        return this.keyspaceToEntityClass.get(this.getKeyspace(keyspace));
    }

    public Optional<IdentifierFilter<?>> getIdentifierFilterFor(Class<?> entityClass) {
        if (entityClass != null && this.entityClassToIdentifierFilter.containsKey(entityClass)) {
            return Optional.of(this.entityClassToIdentifierFilter.get(entityClass));
        }
        return Optional.empty();
    }

    public Optional<IdentifierFilter<?>> getIdentifierFilterFor(String keyspace) {
        return this.getIdentifierFilterFor(this.keyspaceToEntityClass.get(keyspace.endsWith(":") ? keyspace : keyspace + ":"));
    }

    public String getKeyspaceForEntityClass(Class<?> entityClass) {
        RedisPersistentEntity persistentEntity;
        Object keyspace = this.entityClassToKeySpace.get(entityClass);
        if (keyspace == null && (persistentEntity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(entityClass)) != null) {
            String entityKeySpace = persistentEntity.getKeySpace();
            keyspace = (entityKeySpace != null ? entityKeySpace : entityClass.getName()) + ":";
        }
        return keyspace;
    }

    public boolean indexDefinitionExistsFor(Class<?> entityClass) {
        return this.indexedEntityClasses.contains(entityClass);
    }

    public boolean indexExistsFor(Class<?> entityClass) {
        try {
            return this.getIndexInfo(entityClass) != null;
        }
        catch (JedisDataException jde) {
            String lowerCaseMessage;
            String errorMessage = jde.getMessage();
            if (errorMessage != null && ((lowerCaseMessage = errorMessage.toLowerCase()).contains("unknown index") || lowerCaseMessage.contains("no such index") || lowerCaseMessage.contains("index does not exist") || lowerCaseMessage.contains("not found"))) {
                return false;
            }
            throw jde;
        }
    }

    Map<String, Object> getIndexInfo(Class<?> entityClass) {
        String indexName = this.entityClassToIndexName.get(entityClass);
        if (indexName == null) {
            return null;
        }
        SearchOperations<String> opsForSearch = this.rmo.opsForSearch(indexName);
        return opsForSearch.getInfo();
    }

    public List<SearchField> getSchemaFor(Class<?> entityClass) {
        return this.entityClassToSchema.get(entityClass);
    }

    private List<SearchField> findIndexFields(Field field, String prefix, boolean isDocument) {
        ArrayList<SearchField> fields;
        block76: {
            block74: {
                Indexed indexed;
                block77: {
                    Class fieldType;
                    block75: {
                        fields = new ArrayList<SearchField>();
                        if (!field.isAnnotationPresent(Indexed.class)) break block74;
                        logger.info((Object)String.format("Found @Indexed annotation on field of type: %s", field.getType()));
                        indexed = field.getAnnotation(Indexed.class);
                        if (indexed.lexicographic()) {
                            Class<?> entityClass = field.getDeclaringClass();
                            this.entityClassToLexicographicFields.computeIfAbsent(entityClass, k -> new HashSet()).add(field.getName());
                            logger.info((Object)String.format("Tracked lexicographic field %s on class %s", field.getName(), entityClass.getName()));
                        }
                        fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
                        if (!field.isAnnotationPresent(Reference.class)) break block75;
                        logger.debug((Object)("\ud83e\udeb2Found @Reference field " + field.getName() + " in " + field.getDeclaringClass().getSimpleName()));
                        this.createIndexedFieldForReferenceIdField(field, isDocument).ifPresent(fields::add);
                        break block76;
                    }
                    if (indexed.schemaFieldType() != SchemaFieldType.AUTODETECT) break block77;
                    if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType == UUID.class || fieldType == Ulid.class) {
                        fields.add(SearchField.of(field, this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                    } else if (fieldType.isEnum()) {
                        if (Objects.requireNonNull(indexed.serializationHint()) == SerializationHint.ORDINAL) {
                            fields.add(SearchField.of(field, (SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                            this.gsonBuilder.registerTypeAdapter((Type)fieldType, EnumTypeAdapter.of(fieldType));
                        } else {
                            fields.add(SearchField.of(field, this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                        }
                    } else if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class || field.getType() == Instant.class || field.getType() == OffsetDateTime.class) {
                        fields.add(SearchField.of(field, (SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                    } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                        Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(field);
                        if (maybeCollectionType.isPresent()) {
                            Class<?> collectionType = maybeCollectionType.get();
                            if (CharSequence.class.isAssignableFrom(collectionType) || collectionType == Boolean.class) {
                                fields.add(SearchField.of(field, this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                            } else if (isDocument) {
                                if (Number.class.isAssignableFrom(collectionType)) {
                                    fields.add(SearchField.of(field, (SchemaField)this.indexAsNumericFieldFor(field, true, prefix, indexed.sortable(), indexed.noindex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                                } else if (collectionType == Point.class) {
                                    fields.add(SearchField.of(field, (SchemaField)this.indexAsGeoFieldFor(field, true, prefix, indexed.alias())));
                                } else if (collectionType == UUID.class || collectionType == Ulid.class) {
                                    fields.add(SearchField.of(field, this.indexAsTagFieldFor(field, true, prefix, indexed.sortable(), indexed.separator(), 0, indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                                } else {
                                    logger.debug((Object)String.format("Found nested field on field of type: %s", field.getType()));
                                    fields.addAll(this.indexAsNestedFieldFor(field, prefix));
                                }
                            }
                        } else {
                            logger.debug((Object)String.format("Could not determine the type of elements in the collection %s in entity %s", field.getName(), field.getDeclaringClass().getSimpleName()));
                        }
                    } else if (Map.class.isAssignableFrom(fieldType) && isDocument) {
                        logger.info((Object)String.format("Processing Map field: %s of type %s", field.getName(), fieldType));
                        Optional<Class<?>> maybeValueType = ObjectUtils.getMapValueClass(field);
                        if (maybeValueType.isPresent()) {
                            Class<?> valueType = maybeValueType.get();
                            logger.info((Object)String.format("Map field %s has value type: %s", field.getName(), valueType));
                            String mapJsonPath = prefix == null || prefix.isBlank() ? "$." + field.getName() + ".*" : "$." + prefix + "." + field.getName() + ".*";
                            String mapFieldAlias = field.getName() + "_values";
                            if (CharSequence.class.isAssignableFrom(valueType) || valueType == UUID.class || valueType == Ulid.class || valueType.isEnum()) {
                                TagField tagField = TagField.of((FieldName)FieldName.of((String)mapJsonPath).as(mapFieldAlias));
                                if (indexed.sortable()) {
                                    tagField.sortable();
                                }
                                if (indexed.indexMissing()) {
                                    tagField.indexMissing();
                                }
                                if (indexed.indexEmpty()) {
                                    tagField.indexEmpty();
                                }
                                if (!indexed.separator().isEmpty()) {
                                    tagField.separator(indexed.separator().charAt(0));
                                }
                                fields.add(SearchField.of(field, (SchemaField)tagField));
                                logger.info((Object)String.format("Added TAG field for Map: %s as %s", field.getName(), mapFieldAlias));
                            } else if (Number.class.isAssignableFrom(valueType) || valueType == Boolean.class || valueType == LocalDateTime.class || valueType == LocalDate.class || valueType == Date.class || valueType == Instant.class || valueType == OffsetDateTime.class) {
                                NumericField numField = NumericField.of((FieldName)FieldName.of((String)mapJsonPath).as(mapFieldAlias));
                                if (indexed.sortable()) {
                                    numField.sortable();
                                }
                                if (indexed.noindex()) {
                                    numField.noIndex();
                                }
                                if (indexed.indexMissing()) {
                                    numField.indexMissing();
                                }
                                fields.add(SearchField.of(field, (SchemaField)numField));
                                logger.info((Object)String.format("Added NUMERIC field for Map: %s as %s", field.getName(), mapFieldAlias));
                            } else if (valueType == Point.class) {
                                GeoField geoField = GeoField.of((FieldName)FieldName.of((String)mapJsonPath).as(mapFieldAlias));
                                fields.add(SearchField.of(field, (SchemaField)geoField));
                                logger.info((Object)String.format("Added GEO field for Map: %s as %s", field.getName(), mapFieldAlias));
                            } else {
                                logger.info((Object)String.format("Processing complex object Map field: %s with value type %s", field.getName(), valueType.getName()));
                                for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(valueType)) {
                                    if (!subfield.isAnnotationPresent(Indexed.class)) continue;
                                    Indexed subfieldIndexed = subfield.getAnnotation(Indexed.class);
                                    String nestedJsonPath = prefix == null || prefix.isBlank() ? "$." + field.getName() + ".*." + subfield.getName() : "$." + prefix + "." + field.getName() + ".*." + subfield.getName();
                                    String nestedFieldAlias = field.getName() + "_" + subfield.getName();
                                    logger.info((Object)String.format("Processing nested field %s in Map value type, path: %s, alias: %s", subfield.getName(), nestedJsonPath, nestedFieldAlias));
                                    Class<?> subfieldType = subfield.getType();
                                    if (CharSequence.class.isAssignableFrom(subfieldType) || subfieldType == UUID.class || subfieldType == Ulid.class || subfieldType.isEnum()) {
                                        TagField tagField = TagField.of((FieldName)FieldName.of((String)nestedJsonPath).as(nestedFieldAlias));
                                        if (subfieldIndexed.sortable()) {
                                            tagField.sortable();
                                        }
                                        if (subfieldIndexed.indexMissing()) {
                                            tagField.indexMissing();
                                        }
                                        if (subfieldIndexed.indexEmpty()) {
                                            tagField.indexEmpty();
                                        }
                                        if (!subfieldIndexed.separator().isEmpty()) {
                                            tagField.separator(subfieldIndexed.separator().charAt(0));
                                        }
                                        fields.add(SearchField.of(subfield, (SchemaField)tagField));
                                        logger.info((Object)String.format("Added nested TAG field for Map value: %s", nestedFieldAlias));
                                        continue;
                                    }
                                    if (Number.class.isAssignableFrom(subfieldType) || subfieldType == Boolean.class || subfieldType == LocalDateTime.class || subfieldType == LocalDate.class || subfieldType == Date.class || subfieldType == Instant.class || subfieldType == OffsetDateTime.class) {
                                        NumericField numField = NumericField.of((FieldName)FieldName.of((String)nestedJsonPath).as(nestedFieldAlias));
                                        if (subfieldIndexed.sortable()) {
                                            numField.sortable();
                                        }
                                        if (subfieldIndexed.noindex()) {
                                            numField.noIndex();
                                        }
                                        if (subfieldIndexed.indexMissing()) {
                                            numField.indexMissing();
                                        }
                                        fields.add(SearchField.of(subfield, (SchemaField)numField));
                                        logger.info((Object)String.format("Added nested NUMERIC field for Map value: %s", nestedFieldAlias));
                                        continue;
                                    }
                                    if (subfieldType != Point.class) continue;
                                    GeoField geoField = GeoField.of((FieldName)FieldName.of((String)nestedJsonPath).as(nestedFieldAlias));
                                    fields.add(SearchField.of(subfield, (SchemaField)geoField));
                                    logger.info((Object)String.format("Added nested GEO field for Map value: %s", nestedFieldAlias));
                                }
                            }
                        }
                    } else if (fieldType == Point.class) {
                        fields.add(SearchField.of(field, (SchemaField)this.indexAsGeoFieldFor(field, isDocument, prefix, indexed.alias())));
                    } else {
                        for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(field.getType())) {
                            String subfieldPrefix = prefix == null || prefix.isBlank() ? field.getName() : String.join((CharSequence)".", prefix, field.getName());
                            fields.addAll(this.findIndexFields(subfield, subfieldPrefix, isDocument));
                        }
                    }
                    break block76;
                }
                switch (indexed.schemaFieldType()) {
                    case TAG: {
                        fields.add(SearchField.of(field, this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                        break;
                    }
                    case NUMERIC: {
                        fields.add(SearchField.of(field, (SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex(), indexed.alias(), indexed.indexMissing(), indexed.indexEmpty())));
                        break;
                    }
                    case GEO: {
                        fields.add(SearchField.of(field, (SchemaField)this.indexAsGeoFieldFor(field, true, prefix, indexed.alias())));
                        break;
                    }
                    case VECTOR: {
                        fields.add(SearchField.of(field, (SchemaField)this.indexAsVectorFieldFor(field, isDocument, prefix, indexed)));
                        break;
                    }
                    case NESTED: {
                        Class<?> nestedType = field.getType();
                        if (List.class.isAssignableFrom(nestedType) || Set.class.isAssignableFrom(nestedType)) {
                            Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(field);
                            if (maybeCollectionType.isPresent()) {
                                nestedType = maybeCollectionType.get();
                                logger.info((Object)String.format("Processing nested array field %s with element type %s", field.getName(), nestedType.getSimpleName()));
                            } else {
                                logger.warn((Object)String.format("Could not determine element type for nested field %s", field.getName()));
                                break;
                            }
                        }
                        for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(nestedType)) {
                            String subfieldPrefix = prefix == null || prefix.isBlank() ? field.getName() : String.join((CharSequence)".", prefix, field.getName());
                            fields.addAll(this.createNestedIndexFields(field, subfield, subfieldPrefix, isDocument));
                        }
                        break block76;
                    }
                }
                break block76;
            }
            if (field.isAnnotationPresent(Searchable.class)) {
                logger.info((Object)String.format("Found @Searchable annotation on field of type: %s", field.getType()));
                Searchable searchable = field.getAnnotation(Searchable.class);
                if (searchable.lexicographic()) {
                    Class<?> entityClass = field.getDeclaringClass();
                    this.entityClassToLexicographicFields.computeIfAbsent(entityClass, k -> new HashSet()).add(field.getName());
                    logger.info((Object)String.format("Tracked lexicographic field %s on class %s", field.getName(), entityClass.getName()));
                }
                fields.add(SearchField.of(field, (SchemaField)this.indexAsTextFieldFor(field, isDocument, prefix, searchable)));
            } else if (field.isAnnotationPresent(TextIndexed.class)) {
                TextIndexed ti = field.getAnnotation(TextIndexed.class);
                fields.add(SearchField.of(field, (SchemaField)this.indexAsTextFieldFor(field, isDocument, prefix, ti)));
            } else if (field.isAnnotationPresent(TagIndexed.class)) {
                TagIndexed ti = field.getAnnotation(TagIndexed.class);
                fields.add(SearchField.of(field, (SchemaField)this.indexAsTagFieldFor(field, isDocument, prefix, ti)));
            } else if (field.isAnnotationPresent(GeoIndexed.class)) {
                GeoIndexed gi = field.getAnnotation(GeoIndexed.class);
                fields.add(SearchField.of(field, (SchemaField)this.indexAsGeoFieldFor(field, isDocument, prefix, gi)));
            } else if (field.isAnnotationPresent(NumericIndexed.class)) {
                NumericIndexed ni = field.getAnnotation(NumericIndexed.class);
                fields.add(SearchField.of(field, (SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, ni)));
            } else if (field.isAnnotationPresent(VectorIndexed.class)) {
                VectorIndexed vi = field.getAnnotation(VectorIndexed.class);
                fields.add(SearchField.of(field, (SchemaField)this.indexAsVectorFieldFor(field, isDocument, prefix, vi)));
            }
        }
        return fields;
    }

    private TagField indexAsTagFieldFor(Field field, boolean isDocument, String prefix, TagIndexed ti) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(ti.alias()), Optional.empty());
        return this.getTagField(fieldName, ti.separator(), false);
    }

    private VectorField indexAsVectorFieldFor(Field field, boolean isDocument, String prefix, Indexed indexed) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("TYPE", indexed.type().toString());
        attributes.put("DIM", indexed.dimension());
        attributes.put("DISTANCE_METRIC", (Object)indexed.distanceMetric());
        if (indexed.initialCapacity() > 0) {
            attributes.put("INITIAL_CAP", indexed.initialCapacity());
        }
        if (indexed.algorithm().equals((Object)VectorField.VectorAlgorithm.FLAT) && indexed.blockSize() > 0) {
            attributes.put("BLOCK_SIZE", indexed.blockSize());
        }
        if (indexed.algorithm().equals((Object)VectorField.VectorAlgorithm.HNSW)) {
            attributes.put("M", indexed.m());
            attributes.put("EF_CONSTRUCTION", indexed.efConstruction());
            if (indexed.efRuntime() != 10) {
                attributes.put("EF_RUNTIME", indexed.efRuntime());
            }
            if (indexed.epsilon() != 0.01) {
                attributes.put("EPSILON", indexed.epsilon());
            }
        }
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(indexed.alias()), Optional.empty());
        return new VectorField(fieldName, indexed.algorithm(), attributes);
    }

    private VectorField indexAsVectorFieldFor(Field field, boolean isDocument, String prefix, VectorIndexed vi) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("TYPE", vi.type().toString());
        attributes.put("DIM", vi.dimension());
        attributes.put("DISTANCE_METRIC", (Object)vi.distanceMetric());
        if (vi.initialCapacity() > 0) {
            attributes.put("INITIAL_CAP", vi.initialCapacity());
        }
        if (vi.algorithm().equals((Object)VectorField.VectorAlgorithm.FLAT) && vi.blockSize() > 0) {
            attributes.put("BLOCK_SIZE", vi.blockSize());
        }
        if (vi.algorithm().equals((Object)VectorField.VectorAlgorithm.HNSW)) {
            attributes.put("M", vi.m());
            attributes.put("EF_CONSTRUCTION", vi.efConstruction());
            if (vi.efRuntime() != 10) {
                attributes.put("EF_RUNTIME", vi.efRuntime());
            }
            if (vi.epsilon() != 0.01) {
                attributes.put("EPSILON", vi.epsilon());
            }
        }
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(vi.alias()), Optional.empty());
        return new VectorField(fieldName, vi.algorithm(), attributes);
    }

    private SchemaField indexAsTagFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, String separator, int arrayIndex, String annotationAlias) {
        return this.indexAsTagFieldFor(field, isDocument, prefix, sortable, separator, arrayIndex, annotationAlias, false, false);
    }

    private SchemaField indexAsTagFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, String separator, int arrayIndex, String annotationAlias, boolean indexMissing, boolean indexEmpty) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(annotationAlias), Optional.of(arrayIndex));
        return this.getTagField(fieldName, separator, sortable, indexMissing, indexEmpty);
    }

    private TextField indexAsTextFieldFor(Field field, boolean isDocument, String prefix, TextIndexed ti) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(ti.alias()), Optional.empty());
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return this.getTextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic, ti.indexMissing(), ti.indexEmpty());
    }

    private TextField indexAsTextFieldFor(Field field, boolean isDocument, String prefix, Searchable ti) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(ti.alias()), Optional.empty());
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return this.getTextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic, ti.indexMissing(), ti.indexEmpty());
    }

    private GeoField indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, GeoIndexed gi) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(gi.alias()), Optional.empty());
        return GeoField.of((FieldName)fieldName);
    }

    private NumericField indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, NumericIndexed ni) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(ni.alias()), Optional.empty());
        return NumericField.of((FieldName)fieldName);
    }

    private NumericField indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex, String annotationAlias) {
        return this.indexAsNumericFieldFor(field, isDocument, prefix, sortable, noIndex, annotationAlias, false, false);
    }

    private NumericField indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex, String annotationAlias, boolean indexMissing, boolean indexEmpty) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(annotationAlias), Optional.empty());
        NumericField num = NumericField.of((FieldName)fieldName);
        if (sortable) {
            num.sortable();
        }
        if (noIndex) {
            num.noIndex();
        }
        if (indexMissing) {
            num.indexMissing();
        }
        return num;
    }

    private GeoField indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, String annotationAlias) {
        FieldName fieldName = this.buildFieldName(field, prefix, isDocument, Optional.ofNullable(annotationAlias), Optional.empty());
        return GeoField.of((FieldName)fieldName);
    }

    private List<SearchField> indexAsNestedFieldFor(Field field, String prefix) {
        String fieldPrefix = this.getFieldPrefix(prefix, true);
        return this.getNestedField(fieldPrefix, field, prefix, null);
    }

    private List<SearchField> getNestedField(String fieldPrefix, Field field, String prefix, List<SearchField> fieldList) {
        Type genericType;
        if (fieldList == null) {
            fieldList = new ArrayList<SearchField>();
        }
        if ((genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
            List<Field> subDeclaredFields = ObjectUtils.getDeclaredFieldsTransitively(actualTypeArgument);
            Object tempPrefix = "";
            prefix = prefix == null ? field.getName() : (String)prefix + "." + field.getName();
            for (Field subField : subDeclaredFields) {
                FieldName fieldName;
                String suffix;
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(subField);
                String string = suffix = maybeCollectionType.isPresent() && (CharSequence.class.isAssignableFrom(maybeCollectionType.get()) || maybeCollectionType.get() == Boolean.class) ? "[*]" : "";
                if (subField.isAnnotationPresent(TagIndexed.class)) {
                    TagIndexed ti = subField.getAnnotation(TagIndexed.class);
                    tempPrefix = field.getName() + "[0:].";
                    fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                    fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                    logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                    fieldList.add(SearchField.of(field, (SchemaField)this.getTagField(fieldName, ti.separator(), false)));
                    continue;
                }
                if (subField.isAnnotationPresent(Indexed.class)) {
                    boolean subFieldIsTagField;
                    boolean bl = subFieldIsTagField = subField.isAnnotationPresent(Indexed.class) && (CharSequence.class.isAssignableFrom(subField.getType()) || subField.getType() == Boolean.class || subField.getType() == UUID.class || maybeCollectionType.isPresent() && (CharSequence.class.isAssignableFrom(maybeCollectionType.get()) || maybeCollectionType.get() == Boolean.class));
                    if (subFieldIsTagField) {
                        Indexed indexed = subField.getAnnotation(Indexed.class);
                        tempPrefix = field.getName() + "[0:].";
                        FieldName fieldName2 = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                        String alias = QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix);
                        fieldName2 = fieldName2.as(alias);
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add(SearchField.of(field, (SchemaField)this.getTagField(fieldName2, indexed.separator(), false)));
                        continue;
                    }
                    if (Number.class.isAssignableFrom(subField.getType()) || subField.getType() == LocalDateTime.class || subField.getType() == LocalDate.class || subField.getType() == Date.class) {
                        fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                        alias = QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix);
                        fieldName = fieldName.as(alias);
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add(SearchField.of(field, (SchemaField)NumericField.of((FieldName)fieldName)));
                    }
                } else if (subField.isAnnotationPresent(Searchable.class)) {
                    Searchable searchable = subField.getAnnotation(Searchable.class);
                    tempPrefix = field.getName() + "[0:].";
                    fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                    alias = QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix);
                    fieldName = fieldName.as(alias);
                    logger.info((Object)String.format("Creating TEXT nested relationships: %s -> %s", field.getName(), subField.getName()));
                    String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)searchable.phonetic()) ? null : searchable.phonetic();
                    fieldList.add(SearchField.of(field, (SchemaField)this.getTextField(fieldName, searchable.weight(), searchable.sortable(), searchable.nostem(), searchable.noindex(), phonetic, searchable.indexMissing(), searchable.indexEmpty())));
                    continue;
                }
                if (!subField.isAnnotationPresent(Indexed.class)) continue;
                this.getNestedField(fieldPrefix + (String)tempPrefix, subField, (String)prefix, fieldList);
            }
        }
        return fieldList;
    }

    private List<SearchField> createNestedIndexFields(Field arrayField, Field nestedField, String prefix, boolean isDocument) {
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        Class nestedFieldType = ClassUtils.resolvePrimitiveIfNecessary(nestedField.getType());
        String fullFieldPath = isDocument ? "$." + arrayField.getName() + "[*]." + nestedField.getName() : arrayField.getName() + "[*]." + nestedField.getName();
        logger.info((Object)String.format("Creating automatic nested field index: %s -> %s", arrayField.getName(), fullFieldPath));
        FieldTypeMapper fieldTypeMapper = FieldTypeMapper.getFieldType(nestedFieldType);
        switch (fieldTypeMapper.ordinal()) {
            case 0: {
                FieldName fieldName = FieldName.of((String)fullFieldPath);
                String alias = QueryUtils.searchIndexFieldAliasFor(nestedField, prefix);
                if (alias != null && !alias.isEmpty()) {
                    fieldName = fieldName.as(alias);
                }
                fields.add(SearchField.of(arrayField, (SchemaField)this.getTagField(fieldName, "|", false)));
                break;
            }
            case 1: {
                FieldName fieldName = FieldName.of((String)fullFieldPath);
                String alias = QueryUtils.searchIndexFieldAliasFor(nestedField, prefix);
                if (alias != null && !alias.isEmpty()) {
                    fieldName = fieldName.as(alias);
                }
                fields.add(SearchField.of(arrayField, (SchemaField)NumericField.of((FieldName)fieldName)));
                break;
            }
            case 2: {
                FieldName fieldName = FieldName.of((String)fullFieldPath);
                String alias = QueryUtils.searchIndexFieldAliasFor(nestedField, prefix);
                if (alias != null && !alias.isEmpty()) {
                    fieldName = fieldName.as(alias);
                }
                fields.add(SearchField.of(arrayField, (SchemaField)GeoField.of((FieldName)fieldName)));
                break;
            }
            case 3: {
                logger.debug((Object)String.format("Skipping nested field %s of unsupported type %s", nestedField.getName(), nestedFieldType.getSimpleName()));
            }
        }
        return fields;
    }

    private TagField getTagField(FieldName fieldName, String separator, boolean sortable) {
        return this.getTagField(fieldName, separator, sortable, false, false);
    }

    private TagField getTagField(FieldName fieldName, String separator, boolean sortable, boolean indexMissing, boolean indexEmpty) {
        TagField tag = TagField.of((FieldName)fieldName);
        if (separator != null) {
            if (separator.length() != 1) {
                throw new IllegalArgumentException("Separator '" + separator + "' is not of length 1.");
            }
            tag.separator(separator.charAt(0));
        }
        if (sortable) {
            tag.sortable();
        }
        if (indexMissing) {
            tag.indexMissing();
        }
        if (indexEmpty) {
            tag.indexEmpty();
        }
        return tag;
    }

    private TextField getTextField(FieldName fieldName, double weight, boolean sortable, boolean noStem, boolean noIndex, String phonetic, boolean indexMissing, boolean indexEmpty) {
        TextField text = TextField.of((FieldName)fieldName);
        text.weight(weight);
        if (sortable) {
            text.sortable();
        }
        if (noStem) {
            text.noStem();
        }
        if (noIndex) {
            text.noIndex();
        }
        if (phonetic != null) {
            text.phonetic(phonetic);
        }
        if (indexMissing) {
            text.indexMissing();
        }
        if (indexEmpty) {
            text.indexEmpty();
        }
        return text;
    }

    private String getEntityPrefix(Class<?> cl) {
        String entityPrefix = cl.getName() + ":";
        if (this.mappingContext.hasPersistentEntityFor(cl)) {
            RedisPersistentEntity persistentEntity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(cl);
            entityPrefix = persistentEntity.getKeySpace() != null ? persistentEntity.getKeySpace() + ":" : entityPrefix;
            logger.info((Object)String.format("Using entity prefix '%s' as keyspace for type : %s", entityPrefix, cl));
        }
        return entityPrefix;
    }

    private void dropIndex(Class<?> cl, boolean dropDocuments, boolean recreateIndex) {
        String indexName = this.entityClassToIndexName.get(cl);
        try {
            SearchOperations<String> opsForSearch = this.rmo.opsForSearch(indexName);
            if (dropDocuments) {
                opsForSearch.dropIndexAndDocuments();
            } else {
                opsForSearch.dropIndex();
            }
            String entityPrefix = this.generateEntityPrefix(cl);
            this.removeKeySpaceMapping(entityPrefix, cl);
            if (recreateIndex) {
                this.createIndexFor(cl);
            }
        }
        catch (Exception e) {
            logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, indexName, e.getMessage()));
        }
    }

    private String generateEntityPrefix(Class<?> cl) {
        RedisHash hash;
        String entityPrefix = this.getEntityPrefix(cl);
        if (cl.isAnnotationPresent(Document.class)) {
            Document document = cl.getAnnotation(Document.class);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.value())) {
                entityPrefix = document.value();
            }
        } else if (cl.isAnnotationPresent(RedisHash.class) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hash = cl.getAnnotation(RedisHash.class)).value())) {
            entityPrefix = hash.value();
        }
        return entityPrefix;
    }

    private Optional<IndexDataType> determineIndexTarget(Class<?> cl) {
        if (cl.isAnnotationPresent(Document.class)) {
            return Optional.of(IndexDataType.JSON);
        }
        if (cl.isAnnotationPresent(RedisHash.class)) {
            return Optional.of(IndexDataType.HASH);
        }
        return Optional.empty();
    }

    private List<SearchField> processIndexedFields(List<Field> allClassFields, boolean isDocument) {
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        for (Field field : allClassFields) {
            fields.addAll(this.findIndexFields(field, null, isDocument));
        }
        return fields;
    }

    private Optional<String> getDocumentScoreField(List<Field> allClassFields, boolean isDocument) {
        return allClassFields.stream().filter(field -> field.isAnnotationPresent(DocumentScore.class)).findFirst().map(field -> (isDocument ? "$." : "") + field.getName());
    }

    private boolean isAnnotationPreset(Field idField, List<SchemaField> fields) {
        return !idField.isAnnotationPresent(Indexed.class) && !idField.isAnnotationPresent(Searchable.class) && !idField.isAnnotationPresent(TagIndexed.class) && !idField.isAnnotationPresent(TextIndexed.class) && !idField.isAnnotationPresent(NumericIndexed.class) && fields.stream().noneMatch(f -> f.getName().equals(idField.getName()));
    }

    private List<SearchField> createIndexedFieldsForIdFields(Class<?> cl, List<SchemaField> fields, boolean isDocument) {
        Field idField;
        ArrayList<SearchField> results = new ArrayList<SearchField>();
        List<Field> idFields = ObjectUtils.getIdFieldsForEntityClass(cl);
        for (Field idField2 : idFields) {
            String cls;
            Class primitive;
            if (!this.isAnnotationPreset(idField2, fields)) continue;
            Class idClass = idField2.getType();
            if (idField2.getType().isPrimitive() && (primitive = ClassUtils.resolvePrimitiveClassName((String)(cls = ObjectUtils.getTargetClassName(idClass.getName())))) != null) {
                idClass = ClassUtils.resolvePrimitiveIfNecessary((Class)primitive);
            }
            if (Number.class.isAssignableFrom(idClass)) {
                results.add(SearchField.of(idField2, (SchemaField)this.indexAsNumericFieldFor(idField2, isDocument, "", true, false, null)));
                continue;
            }
            results.add(SearchField.of(idField2, this.indexAsTagFieldFor(idField2, isDocument, "", false, "|", Integer.MIN_VALUE, null)));
        }
        Field field = idField = !idFields.isEmpty() ? idFields.get(0) : null;
        if (idField != null && idField.isAnnotationPresent(IdFilter.class)) {
            IdFilter idFilter = idField.getAnnotation(IdFilter.class);
            Class<IdentifierFilter<?>> identifierFilterClass = idFilter.value();
            try {
                IdentifierFilter<?> identifierFilter = identifierFilterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.entityClassToIdentifierFilter.put(cl, identifierFilter);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException idFilterInstantiationException) {
                logger.error((Object)String.format("Could not instantiate IdFilter of type %s applied to class %s", identifierFilterClass.getSimpleName(), cl), (Throwable)idFilterInstantiationException);
            }
        }
        return results;
    }

    private Optional<SearchField> createIndexedFieldForReferenceIdField(Field referenceIdField, boolean isDocument) {
        SerializedName serializedName = referenceIdField.getAnnotation(SerializedName.class);
        String fname = serializedName != null ? serializedName.value() : referenceIdField.getName();
        String fieldPrefix = this.getFieldPrefix("", isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + fname));
        String alias = QueryUtils.searchIndexFieldAliasFor(referenceIdField, "");
        fieldName = fieldName.as(alias);
        return Optional.of(SearchField.of(referenceIdField, (SchemaField)(isDocument ? TagField.of((FieldName)fieldName).separator('|') : TagField.of((FieldName)fieldName).separator('|').sortable())));
    }

    private FTCreateParams createIndexDefinition(Class<?> cl, IndexDataType idxType) {
        FTCreateParams params = FTCreateParams.createParams();
        params.on(idxType);
        if (cl.isAnnotationPresent(Document.class)) {
            Document document = cl.getAnnotation(Document.class);
            Optional.ofNullable(document.filter()).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty).ifPresent(arg_0 -> ((FTCreateParams)params).filter(arg_0));
            Optional.ofNullable(document.language()).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty).ifPresent(lang -> params.language(lang.getValue()));
            Optional.ofNullable(document.languageField()).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty).ifPresent(arg_0 -> ((FTCreateParams)params).languageField(arg_0));
            params.score(document.score());
        }
        return params;
    }

    private void updateTTLSettings(Class<?> cl, String entityPrefix, boolean isDocument, Optional<Document> document, List<Field> allClassFields) {
        if (isDocument) {
            KeyspaceConfiguration.KeyspaceSettings setting = new KeyspaceConfiguration.KeyspaceSettings(cl, entityPrefix);
            document.filter(doc -> doc.timeToLive() > 0L).ifPresent(doc -> setting.setTimeToLive(Long.valueOf(doc.timeToLive())));
            allClassFields.stream().filter(field -> field.isAnnotationPresent(TimeToLive.class)).findFirst().ifPresent(field -> setting.setTimeToLivePropertyName(field.getName()));
            if (this.mappingContext instanceof RedisEnhancedMappingContext) {
                ((RedisEnhancedMappingContext)this.mappingContext).getKeyspaceResolver().addKeyspaceSettings(cl, setting);
            } else {
                this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration().addKeyspaceSettings(setting);
            }
        }
    }

    private String getKeyspace(String keyspace) {
        return keyspace.endsWith(":") ? keyspace : keyspace + ":";
    }

    private String getFieldPrefix(String prefix, boolean isDocument) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        return isDocument ? "$." + chain : chain;
    }

    private void registerAlias(Class<?> cl, String fieldName, String alias) {
        this.entityClassFieldToAlias.put(Tuples.of(cl, fieldName), alias);
    }

    private FieldName buildFieldName(Field field, String prefix, boolean isDocument, Optional<String> maybeAlias, Optional<Integer> maybeArrayIndex) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        Indexed indexed = field.getAnnotation(Indexed.class);
        String fname = serializedName != null ? serializedName.value() : field.getName();
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String index = maybeArrayIndex.isPresent() && maybeArrayIndex.get() != Integer.MIN_VALUE ? ".[" + String.valueOf(maybeArrayIndex.get()) + "]" : "[*]";
        boolean needsPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) && indexed != null && !indexed.schemaFieldType().equals((Object)SchemaFieldType.VECTOR);
        String fieldPostfix = needsPostfix ? index : "";
        String name = fieldPrefix + fname + fieldPostfix;
        String alias = maybeAlias.isEmpty() || maybeAlias.get().isBlank() ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : maybeAlias.get();
        return FieldName.of((String)name).as(alias);
    }

    public String getAlias(Class<?> cl, String fieldName) {
        String alias = this.entityClassFieldToAlias.get(Tuples.of(cl, fieldName));
        return alias != null ? alias : fieldName;
    }

    public RedisOMProperties getProperties() {
        return this.properties;
    }

    public Set<String> getLexicographicFields(Class<?> entityClass) {
        return this.entityClassToLexicographicFields.getOrDefault(entityClass, Collections.emptySet());
    }

    private void createSortedSetsForLexicographicFields(Class<?> entityClass, String entityPrefix) {
        Set<String> lexicographicFields = this.entityClassToLexicographicFields.get(entityClass);
        if (lexicographicFields != null && !lexicographicFields.isEmpty()) {
            for (String fieldName : lexicographicFields) {
                String sortedSetKey = entityPrefix + fieldName + ":lex";
                logger.info((Object)String.format("Tracking lexicographic field %s with sorted set key %s", fieldName, sortedSetKey));
            }
        }
    }

    private static enum FieldTypeMapper {
        TAG,
        NUMERIC,
        GEO,
        UNSUPPORTED;


        static FieldTypeMapper getFieldType(Class<?> fieldType) {
            if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType == UUID.class || fieldType == Ulid.class || fieldType.isEnum()) {
                return TAG;
            }
            if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || fieldType == LocalDate.class || fieldType == Date.class || fieldType == Instant.class || fieldType == OffsetDateTime.class) {
                return NUMERIC;
            }
            if (fieldType == Point.class) {
                return GEO;
            }
            return UNSUPPORTED;
        }
    }
}

