/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.mapping;

import com.redis.om.spring.mapping.ClassLoaderAwareKeyspaceResolver;
import com.redis.om.spring.mapping.RedisEnhancedPersistentEntity;
import com.redis.om.spring.mapping.RedisEnhancedTimeToLiveAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.MappingConfiguration;
import org.springframework.data.redis.core.index.ConfigurableIndexDefinitionProvider;
import org.springframework.data.redis.core.index.IndexConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.TypeInformation;

public class RedisEnhancedMappingContext
extends RedisMappingContext {
    private static final Log logger = LogFactory.getLog(RedisEnhancedMappingContext.class);
    private final MappingConfiguration mappingConfiguration;
    private final TimeToLiveAccessor timeToLiveAccessor;
    private final ClassLoaderAwareKeyspaceResolver keyspaceResolver;

    public RedisEnhancedMappingContext(MappingConfiguration mappingConfiguration) {
        super(mappingConfiguration);
        this.mappingConfiguration = mappingConfiguration;
        this.keyspaceResolver = new ClassLoaderAwareKeyspaceResolver(mappingConfiguration.getKeyspaceConfiguration());
        this.timeToLiveAccessor = new RedisEnhancedTimeToLiveAccessor(mappingConfiguration.getKeyspaceConfiguration(), this);
    }

    public RedisEnhancedMappingContext() {
        this(new MappingConfiguration((ConfigurableIndexDefinitionProvider)new IndexConfiguration(), new KeyspaceConfiguration()));
    }

    protected <T> RedisPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new RedisEnhancedPersistentEntity<T>(typeInformation, this.getKeySpaceResolver(), this.timeToLiveAccessor);
    }

    public ClassLoaderAwareKeyspaceResolver getKeyspaceResolver() {
        return this.keyspaceResolver;
    }
}

