/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query.clause;

import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.repository.query.clause.QueryClauseTemplate;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Array;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.repository.query.parser.Part;
import redis.clients.jedis.search.Schema;

public enum QueryClause {
    TEXT_ALL(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.SIMPLE_PROPERTY, "$param_0", 1)),
    TEXT_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.SIMPLE_PROPERTY, "@$field:$param_0", 1)),
    TEXT_NEGATING_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.SIMPLE_PROPERTY, "-@$field:$param_0", 1)),
    TEXT_STARTING_WITH(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.STARTING_WITH, "@$field:$param_0*", 1)),
    TEXT_ENDING_WITH(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.ENDING_WITH, "@$field:*$param_0", 1)),
    TEXT_LIKE(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.LIKE, "@$field:%%%$param_0%%%", 1)),
    TEXT_NOT_LIKE(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.NOT_LIKE, "-@$field:%%%$param_0%%%", 1)),
    TEXT_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.CONTAINING, "@$field:%%%$param_0%%%", 1)),
    TEXT_NOT_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.NOT_CONTAINING, "-@$field:%%%$param_0%%%", 1)),
    TEXT_NOT_IN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.NOT_IN, "@$field:$param_0", 1)),
    TEXT_IN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.IN, "@$field:$param_0", 1)),
    TEXT_GREATER_THAN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.GREATER_THAN, "__LEXICOGRAPHIC__", 1)),
    TEXT_LESS_THAN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.LESS_THAN, "__LEXICOGRAPHIC__", 1)),
    TEXT_GREATER_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.GREATER_THAN_EQUAL, "__LEXICOGRAPHIC__", 1)),
    TEXT_LESS_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.LESS_THAN_EQUAL, "__LEXICOGRAPHIC__", 1)),
    TEXT_BETWEEN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.BETWEEN, "__LEXICOGRAPHIC__", 2)),
    NUMERIC_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.SIMPLE_PROPERTY, "@$field:[$param_0 $param_0]", 1)),
    NUMERIC_NEGATING_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.SIMPLE_PROPERTY, "@$field:-[$param_0 $param_0]", 1)),
    NUMERIC_BETWEEN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.BETWEEN, "@$field:[$param_0 $param_1]", 2)),
    NUMERIC_IN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.IN, "@$field:$param_0", 1)),
    NUMERIC_NOT_IN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.NOT_IN, "@$field:$param_0", 1)),
    NUMERIC_LESS_THAN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.LESS_THAN, "@$field:[-inf ($param_0]", 1)),
    NUMERIC_LESS_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.LESS_THAN_EQUAL, "@$field:[-inf $param_0]", 1)),
    NUMERIC_GREATER_THAN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.GREATER_THAN, "@$field:[($param_0 inf]", 1)),
    NUMERIC_GREATER_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.GREATER_THAN_EQUAL, "@$field:[$param_0 inf]", 1)),
    NUMERIC_BEFORE(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.BEFORE, "@$field:[-inf ($param_0]", 1)),
    NUMERIC_AFTER(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.AFTER, "@$field:[($param_0 inf]", 1)),
    NUMERIC_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.CONTAINING, "$param_0", 1)),
    NUMERIC_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.CONTAINING, "$param_0", 1)),
    GEO_NEAR(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.NEAR, "@$field:[$param_0 $param_1 $param_2]", 2)),
    GEO_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.CONTAINING, "$param_0", 1)),
    GEO_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.CONTAINING, "$param_0", 1)),
    GEO_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.SIMPLE_PROPERTY, "@$field:[$param_0 $param_1 .000001 ft]", 1)),
    TAG_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.SIMPLE_PROPERTY, "@$field:{$param_0}", 1)),
    TAG_GREATER_THAN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.GREATER_THAN, "__LEXICOGRAPHIC__", 1)),
    TAG_LESS_THAN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.LESS_THAN, "__LEXICOGRAPHIC__", 1)),
    TAG_GREATER_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.GREATER_THAN_EQUAL, "__LEXICOGRAPHIC__", 1)),
    TAG_LESS_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.LESS_THAN_EQUAL, "__LEXICOGRAPHIC__", 1)),
    TAG_BETWEEN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.BETWEEN, "__LEXICOGRAPHIC__", 2)),
    TAG_NOT_IN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.NOT_IN, "@$field:{$param_0}", 1)),
    TAG_IN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.IN, "@$field:{$param_0}", 1)),
    TAG_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.CONTAINING, "@$field:$param_0", 1)),
    TAG_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.CONTAINING, "$param_0", 1)),
    TAG_STARTING_WITH(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.STARTING_WITH, "@$field:{$param_0*}", 1)),
    TAG_ENDING_WITH(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.ENDING_WITH, "@$field:{*$param_0}", 1)),
    IS_NULL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.IS_NULL, "!exists(@$field)", 0)),
    IS_NOT_NULL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.IS_NOT_NULL, "exists(@$field)", 0));

    public static final Map<String, String> methodNameMap;
    public static final Pattern CONTAINING_ALL_PATTERN;
    public static final Pattern MAP_CONTAINS_PATTERN;
    public static final Pattern MAP_CONTAINS_NESTED_PATTERN;
    private static final String PARAM_PREFIX = "$param_";
    private static final String FIRST_PARAM = "$param_0";
    private static final String FIELD_EQUAL = "@$field:$param_0";
    private static final String FIELD_NON_EQUAL_PARAM_0 = "-@$field:$param_0";
    private static final String FIELD_TAG_EQUAL = "@$field:{$param_0}";
    private static final String FIELD_LIKE = "@$field:%%%$param_0%%%";
    private static final String FIELD_NOT_LIKE = "-@$field:%%%$param_0%%%";
    private static final String FIELD_NUMERIC_EQUAL_PARAM_0 = "@$field:[$param_0 $param_0]";
    private static final String FIELD_TEXT_STARTING_WITH = "@$field:$param_0*";
    private static final String FIELD_TAG_STARTING_WITH = "@$field:{$param_0*}";
    private static final String FIELD_TEXT_ENDING_WITH = "@$field:*$param_0";
    private static final String FIELD_TAG_ENDING_WITH = "@$field:{*$param_0}";
    private static final String FIELD_NUMERIC_NOT_EQUAL = "@$field:-[$param_0 $param_0]";
    private static final String FIELD_NUMERIC_BETWEEN = "@$field:[$param_0 $param_1]";
    private static final String FIELD_NUMERIC_LESS_THAN = "@$field:[-inf ($param_0]";
    private static final String FIELD_NUMERIC_LESS_THAN_EQUAL = "@$field:[-inf $param_0]";
    private static final String FIELD_NUMERIC_GREATER_THAN = "@$field:[($param_0 inf]";
    private static final String FIELD_NUMERIC_GREATER_THAN_EQUAL = "@$field:[$param_0 inf]";
    private static final String FIELD_NUMERIC_BEFORE = "@$field:[-inf ($param_0]";
    private static final String FIELD_NUMERIC_AFTER = "@$field:[($param_0 inf]";
    private static final String FIELD_GEO_NEAR = "@$field:[$param_0 $param_1 $param_2]";
    private static final String FIELD_GEO_POINT_EQUAL = "@$field:[$param_0 $param_1 .000001 ft]";
    private static final String FIELD_IS_NULL = "!exists(@$field)";
    private static final String FIELD_IS_NOT_NULL = "exists(@$field)";
    private static final String FIELD_LEXICOGRAPHIC = "__LEXICOGRAPHIC__";
    private final QueryClauseTemplate clauseTemplate;
    private final MappingRedisOMConverter converter = new MappingRedisOMConverter();

    private QueryClause(QueryClauseTemplate value) {
        this.clauseTemplate = value;
    }

    public static QueryClause get(Schema.FieldType fieldType, Part.Type partType) {
        try {
            return QueryClause.valueOf(fieldType.toString() + "_" + partType.name());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return TAG_SIMPLE_PROPERTY;
        }
    }

    public static boolean hasContainingAllClause(String methodName) {
        return CONTAINING_ALL_PATTERN.matcher(methodName).find();
    }

    public static boolean hasMapContainsClause(String methodName) {
        return MAP_CONTAINS_PATTERN.matcher(methodName).find() || MAP_CONTAINS_NESTED_PATTERN.matcher(methodName).find();
    }

    public static boolean hasMapContainsNestedClause(String methodName) {
        return MAP_CONTAINS_NESTED_PATTERN.matcher(methodName).find();
    }

    public static String getPostProcessMethodName(String methodName) {
        if (QueryClause.hasContainingAllClause(methodName)) {
            Optional<String> maybeMatchSubstring = CONTAINING_ALL_PATTERN.matcher(methodName).results().map(mr -> mr.group(1)).findFirst();
            if (maybeMatchSubstring.isPresent()) {
                String matchSubstring = maybeMatchSubstring.get();
                return methodName.replace(matchSubstring, methodNameMap.get(matchSubstring));
            }
            return methodName;
        }
        return methodName;
    }

    public static String processMapContainsMethodName(String methodName) {
        if (QueryClause.hasMapContainsNestedClause(methodName)) {
            return methodName.replaceAll("MapContains([A-Za-z]+)(GreaterThan|LessThan|After|Before|Between|NotEqual)?", "$1$2");
        }
        if (QueryClause.hasMapContainsClause(methodName)) {
            return methodName.replaceAll("MapContains(GreaterThan|LessThan|After|Before)?", "$1");
        }
        return methodName;
    }

    public QueryClauseTemplate getClauseTemplate() {
        return this.clauseTemplate;
    }

    public String prepareQuery(String field, Object ... params) {
        Object prepared = field.equalsIgnoreCase("__ALL__") ? this.clauseTemplate.getQuerySegmentTemplate() : this.clauseTemplate.getQuerySegmentTemplate().replace("$field", field);
        Iterator<Object> iter = Arrays.asList(params).iterator();
        int i = 0;
        block8: while (iter.hasNext()) {
            String paramClass;
            Object param = iter.next();
            switch (paramClass = param.getClass().getName()) {
                case "org.springframework.data.geo.Point": {
                    Point point = (Point)param;
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, Double.toString(point.getX()));
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, Double.toString(point.getY()));
                    continue block8;
                }
                case "org.springframework.data.geo.Distance": {
                    Distance distance = (Distance)param;
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, ObjectUtils.getDistanceAsRedisString(distance));
                    continue block8;
                }
            }
            List<Object> c = null;
            if (param instanceof Collection) {
                c = (List<Object>)param;
            } else if (param != null && param.getClass().isArray()) {
                if (param instanceof Object[]) {
                    c = Arrays.asList((Object[])param);
                } else {
                    int length = Array.getLength(param);
                    ArrayList<Object> list = new ArrayList<Object>(length);
                    for (int j = 0; j < length; ++j) {
                        list.add(Array.get(param, j));
                    }
                    c = list;
                }
            }
            if (c != null) {
                if (this == TAG_CONTAINING_ALL) {
                    String value = c.stream().map(n -> "@" + field + ":{" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "}").collect(Collectors.joining(" "));
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, value);
                    continue;
                }
                if (this == NUMERIC_CONTAINING) {
                    String value = c.stream().map(n -> "@" + field + ":[" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + " " + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "]").collect(Collectors.joining("|"));
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, value);
                    continue;
                }
                if (this == NUMERIC_IN) {
                    if (c.isEmpty()) {
                        prepared = ((String)prepared).replace(PARAM_PREFIX + i++, "[-1 -2]");
                        continue;
                    }
                    if (c.size() == 1) {
                        Object val = c.iterator().next();
                        prepared = ((String)prepared).replace(PARAM_PREFIX + i++, "[" + val.toString() + " " + val.toString() + "]");
                        continue;
                    }
                    String value = "(" + c.stream().map(n -> "@" + field + ":[" + n.toString() + " " + n.toString() + "]").collect(Collectors.joining("|")) + ")";
                    prepared = value;
                    continue;
                }
                if (this == NUMERIC_NOT_IN) {
                    if (c.isEmpty()) {
                        prepared = "@" + field + ":[-inf inf]";
                        continue;
                    }
                    String value = "@" + field + ":[-inf inf] " + c.stream().map(n -> "-@" + field + ":[" + n.toString() + " " + n.toString() + "]").collect(Collectors.joining(" "));
                    prepared = value;
                    continue;
                }
                if (this == NUMERIC_CONTAINING_ALL) {
                    String value = c.stream().map(n -> "@" + field + ":[" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + " " + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "]").collect(Collectors.joining(" "));
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, value);
                    continue;
                }
                if (this == GEO_CONTAINING) {
                    String value = c.stream().map(n -> {
                        Point p = (Point)n;
                        return "@" + field + ":[" + p.getX() + " " + p.getY() + " .000001 ft]";
                    }).collect(Collectors.joining("|"));
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, value);
                    continue;
                }
                if (this == GEO_CONTAINING_ALL) {
                    String value = c.stream().map(n -> {
                        Point p = (Point)n;
                        return "@" + field + ":[" + p.getX() + " " + p.getY() + " .000001 ft]";
                    }).collect(Collectors.joining(" "));
                    prepared = ((String)prepared).replace(PARAM_PREFIX + i++, value);
                    continue;
                }
                String value = c.stream().map(n -> QueryUtils.escape(ObjectUtils.asString(n, this.converter), false)).collect(Collectors.joining("|"));
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, value);
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.TEXT) {
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, param.toString());
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.NUMERIC && param instanceof Boolean) {
                String boolValue = (Boolean)param != false ? "1" : "0";
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, boolValue);
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.NUMERIC && param instanceof Date) {
                long timestamp = ((Date)param).getTime();
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, Long.toString(timestamp));
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.NUMERIC && param instanceof Instant) {
                long timestamp = ((Instant)param).toEpochMilli();
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, Long.toString(timestamp));
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.NUMERIC && param instanceof OffsetDateTime) {
                long timestamp = ((OffsetDateTime)param).toInstant().toEpochMilli();
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, Long.toString(timestamp));
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.NUMERIC && !paramClass.equalsIgnoreCase("java.time.LocalDateTime") && !paramClass.equalsIgnoreCase("java.time.LocalDate")) {
                prepared = ((String)prepared).replace(PARAM_PREFIX + i++, param.toString());
                continue;
            }
            prepared = ((String)prepared).replace(PARAM_PREFIX + i++, QueryUtils.escape(ObjectUtils.asString(param, this.converter)));
        }
        return prepared;
    }

    static {
        methodNameMap = Map.of("IsContainingAll", "IsContaining", "ContainingAll", "Containing", "ContainsAll", "Contains");
        CONTAINING_ALL_PATTERN = Pattern.compile("(IsContainingAll|ContainingAll|ContainsAll)");
        MAP_CONTAINS_PATTERN = Pattern.compile("([A-Za-z]+)MapContains");
        MAP_CONTAINS_NESTED_PATTERN = Pattern.compile("([A-Za-z]+)MapContains([A-Za-z]+)(GreaterThan|LessThan|After|Before|Between|NotEqual)?");
    }
}

