/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.gson.GsonBuilder;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.repository.query.RediSearchQuery;
import com.redis.om.spring.repository.support.SimpleRedisDocumentRepository;
import com.redis.om.spring.vectorize.Embedder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RedisDocumentRepositoryFactory
extends KeyValueRepositoryFactory {
    private static final Class<SpelQueryCreator> DEFAULT_QUERY_CREATOR = SpelQueryCreator.class;
    private final KeyValueOperations keyValueOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final Class<? extends RepositoryQuery> repositoryQueryType;
    private final RedisModulesOperations<?> rmo;
    private final RediSearchIndexer indexer;
    private final GsonBuilder gsonBuilder;
    private final RedisMappingContext mappingContext;
    private final Embedder embedder;
    private final RedisOMProperties properties;

    public RedisDocumentRepositoryFactory(KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, RedisMappingContext mappingContext, GsonBuilder gsonBuilder, Embedder embedder, RedisOMProperties properties) {
        this(keyValueOperations, rmo, indexer, DEFAULT_QUERY_CREATOR, mappingContext, gsonBuilder, embedder, properties);
    }

    public RedisDocumentRepositoryFactory(KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, RedisMappingContext mappingContext, GsonBuilder gsonBuilder, Embedder embedder, RedisOMProperties properties) {
        this(keyValueOperations, rmo, indexer, queryCreator, RediSearchQuery.class, mappingContext, gsonBuilder, embedder, properties);
    }

    public RedisDocumentRepositoryFactory(KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType, RedisMappingContext mappingContext, GsonBuilder gsonBuilder, Embedder embedder, RedisOMProperties properties) {
        super(keyValueOperations, queryCreator, repositoryQueryType);
        Assert.notNull(rmo, (String)"RedisModulesOperations must not be null!");
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
        Assert.notNull((Object)indexer, (String)"RediSearchIndexer must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        Assert.notNull(repositoryQueryType, (String)"RepositoryQueryType type must not be null!");
        Assert.notNull((Object)embedder, (String)"FeatureExtractor type must not be null!");
        Assert.notNull((Object)properties, (String)"RedisOMSpringProperties type must not be null!");
        this.keyValueOperations = keyValueOperations;
        this.rmo = rmo;
        this.indexer = indexer;
        this.queryCreator = queryCreator;
        this.repositoryQueryType = repositoryQueryType;
        this.mappingContext = mappingContext;
        this.gsonBuilder = gsonBuilder;
        this.embedder = embedder;
        this.properties = properties;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        PersistentEntity entity = this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new PersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.keyValueOperations, this.rmo, this.indexer, this.mappingContext, this.gsonBuilder, this.embedder, this.properties});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleRedisDocumentRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new RediSearchQueryLookupStrategy(evaluationContextProvider, this.keyValueOperations, this.rmo, this.indexer, this.properties, this.queryCreator, this.repositoryQueryType, this.gsonBuilder));
    }

    private record RediSearchQueryLookupStrategy(QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, RedisOMProperties properties, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType, GsonBuilder gsonBuilder) implements QueryLookupStrategy
    {
        private RediSearchQueryLookupStrategy {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
            Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
            Assert.notNull(rmo, (String)"RedisModulesOperations must not be null!");
            Assert.notNull((Object)indexer, (String)"RediSearchIndexer must not be null!");
            Assert.notNull((Object)properties, (String)"RedisOMSpringProperties must not be null!");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
            Assert.notNull(repositoryQueryType, (String)"RepositoryQueryType type must not be null!");
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            QueryMethod queryMethod = new QueryMethod(method, metadata, factory);
            Constructor constructor = ClassUtils.getConstructorIfAvailable(this.repositoryQueryType, (Class[])new Class[]{QueryMethod.class, RepositoryMetadata.class, RediSearchIndexer.class, QueryMethodEvaluationContextProvider.class, KeyValueOperations.class, RedisModulesOperations.class, Class.class, GsonBuilder.class, RedisOMProperties.class});
            Assert.state((constructor != null ? 1 : 0) != 0, (String)String.format("Constructor %s(QueryMethod, RepositoryMetadata, RediSearchIndexer, EvaluationContextProvider, KeyValueOperations, RedisModulesOperations, Class, GsonBuilder, RedisOMSpringProperties) not available!", ClassUtils.getShortName(this.repositoryQueryType)));
            return (RepositoryQuery)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{queryMethod, metadata, this.indexer, this.evaluationContextProvider, this.keyValueOperations, this.rmo, this.queryCreator, this.gsonBuilder, this.properties});
        }
    }
}

