/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.search.stream.predicates.jedis.JedisValues;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class InPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final List<T> values;

    public InPredicate(SearchFieldAccessor field, List<T> values) {
        super(field);
        this.values = values;
    }

    public List<T> getValues() {
        return this.values;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValues())) {
            return root;
        }
        QueryNode or = QueryBuilders.union((Node[])new Node[0]);
        for (T value : this.getValues()) {
            this.processValue(or, value);
        }
        return QueryBuilders.intersect((Node[])new Node[]{root, or});
    }

    private void processValue(QueryNode or, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(v -> this.processValue(or, v));
        } else if (value instanceof Iterable) {
            ((Iterable)value).forEach(v -> this.processValue(or, v));
        } else if (value.getClass().isArray()) {
            Arrays.stream((Object[])value).forEach(v -> this.processValue(or, v));
        } else {
            this.addValueToQuery(or, value);
        }
    }

    private void addValueToQuery(QueryNode or, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Integer.class) {
            or.add(this.getSearchAlias(), new Value[]{Values.eq((int)((Integer)value))});
        } else if (valueClass == Long.class) {
            or.add(this.getSearchAlias(), new Value[]{Values.eq((double)((Long)value).longValue())});
        } else if (valueClass == LocalDate.class) {
            or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((LocalDate)value)});
        } else if (valueClass == Date.class) {
            or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((Date)value)});
        } else if (valueClass == LocalDateTime.class) {
            or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((LocalDateTime)value)});
        } else if (valueClass == Instant.class) {
            or.add(this.getSearchAlias(), new Value[]{JedisValues.eq((Instant)value)});
        } else if (valueClass == BigDecimal.class) {
            or.add(this.getSearchAlias(), new Value[]{Values.eq((double)((BigDecimal)value).doubleValue())});
        } else {
            or.add(this.getSearchAlias(), new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
        }
    }
}

