/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class NotEqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private T value;
    private Iterable<?> values;

    public NotEqualPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
    }

    public NotEqualPredicate(SearchFieldAccessor field, List<String> list) {
        super(field);
        this.values = list.stream().map(QueryUtils::escape).toList();
    }

    public Iterable<?> getValues() {
        return this.value != null ? (Iterable)this.value : this.values;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValues())) {
            return root;
        }
        QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
        StreamSupport.stream(this.getValues().spliterator(), false).map(v -> Values.value((String)("{\"" + v.toString() + "\"}"))).forEach(val -> and.add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{val})}));
        return QueryBuilders.intersect((Node[])new Node[]{root, and});
    }
}

