/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class BooleanTypeAdapter
extends TypeAdapter<Boolean> {
    private static final BooleanTypeAdapter INSTANCE = new BooleanTypeAdapter();

    private BooleanTypeAdapter() {
    }

    public static BooleanTypeAdapter getInstance() {
        return INSTANCE;
    }

    public void write(JsonWriter out, Boolean value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(value != false ? 1L : 0L);
        }
    }

    public Boolean read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (token == JsonToken.BOOLEAN) {
            return in.nextBoolean();
        }
        if (token == JsonToken.NUMBER) {
            int value = in.nextInt();
            return value != 0;
        }
        if (token == JsonToken.STRING) {
            String value = in.nextString();
            if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("0".equals(value) || "false".equalsIgnoreCase(value)) {
                return false;
            }
            throw new IOException("Cannot parse boolean value: " + value);
        }
        throw new IOException("Expected BOOLEAN, NUMBER, or STRING but was " + String.valueOf(token));
    }
}

