/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class MapBooleanTypeAdapterFactory
implements TypeAdapterFactory {
    private static final MapBooleanTypeAdapterFactory INSTANCE = new MapBooleanTypeAdapterFactory();

    private MapBooleanTypeAdapterFactory() {
    }

    public static MapBooleanTypeAdapterFactory getInstance() {
        return INSTANCE;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        boolean isBooleanValue;
        if (!Map.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        Type mapType = type.getType();
        if (!(mapType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)mapType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 2) {
            return null;
        }
        Type valueType = typeArguments[1];
        boolean bl = isBooleanValue = valueType == Boolean.class || valueType == Boolean.TYPE;
        if (!isBooleanValue) {
            return null;
        }
        TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                Map map = (Map)value;
                out.beginObject();
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null) continue;
                    out.name(String.valueOf(entry.getKey()));
                    if (entry.getValue() == null) {
                        out.nullValue();
                        continue;
                    }
                    out.value((Boolean)entry.getValue() != false ? 1L : 0L);
                }
                out.endObject();
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                in.beginObject();
                while (in.hasNext()) {
                    String key = in.nextName();
                    Boolean value = this.readBooleanValue(in);
                    map.put(key, value);
                }
                in.endObject();
                return map;
            }

            private Boolean readBooleanValue(JsonReader in) throws IOException {
                JsonToken token = in.peek();
                if (token == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                if (token == JsonToken.BOOLEAN) {
                    return in.nextBoolean();
                }
                if (token == JsonToken.NUMBER) {
                    int value = in.nextInt();
                    return value != 0;
                }
                if (token == JsonToken.STRING) {
                    String value = in.nextString();
                    if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
                        return true;
                    }
                    if ("0".equals(value) || "false".equalsIgnoreCase(value)) {
                        return false;
                    }
                    throw new JsonParseException("Cannot parse boolean value: " + value);
                }
                throw new JsonParseException("Expected BOOLEAN, NUMBER, or STRING but was " + String.valueOf(token));
            }
        };
    }
}

