/*
 * Decompiled with CFR 0.152.
 */
package com.redis.enterprise;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.redis.enterprise.Command;
import com.redis.enterprise.Database;
import com.redis.enterprise.rest.Action;
import com.redis.enterprise.rest.Bootstrap;
import com.redis.enterprise.rest.CommandResponse;
import com.redis.enterprise.rest.InstalledModule;
import com.redis.enterprise.rest.ModuleInstallResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Admin
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Admin.class);
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String V1 = "/v1/";
    public static final String V2 = "/v2/";
    public static final String DEFAULT_PROTOCOL = "https";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9443;
    public static final String BOOTSTRAP = "bootstrap";
    public static final String ACTIONS = "actions";
    public static final String MODULES = "modules";
    public static final String BDBS = "bdbs";
    public static final String COMMAND = "command";
    private static final CharSequence PATH_SEPARATOR = "/";
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final UsernamePasswordCredentials credentials;
    private final CloseableHttpClient client;
    private String protocol = "https";
    private String host = "localhost";
    private int port = 9443;

    public Admin(String userName, char[] password) throws GeneralSecurityException {
        this.credentials = new UsernamePasswordCredentials(userName, password);
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslcontext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
        this.client = clientBuilder.build();
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private static String v1(String ... segments) {
        return Admin.join(V1, segments);
    }

    private static String v2(String ... segments) {
        return Admin.join(V2, segments);
    }

    private static String join(String path, String[] segments) {
        return path + String.join(PATH_SEPARATOR, segments);
    }

    private URI uri(String path) {
        try {
            return new URI(this.protocol, null, this.host, this.port, path, null, null);
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }

    private <T> T get(String path, Class<T> type) throws IOException {
        return this.get(path, (JavaType)SimpleType.constructUnsafe(type));
    }

    private <T> T get(String path, JavaType type) throws IOException {
        return this.read(this.header((ClassicHttpRequest)new HttpGet(this.uri(path))), type, 200);
    }

    private <T> T delete(String path, Class<T> type) throws IOException {
        return this.delete(path, (JavaType)SimpleType.constructUnsafe(type));
    }

    private <T> T delete(String path, JavaType type) throws IOException {
        return this.read(this.header((ClassicHttpRequest)new HttpDelete(this.uri(path))), type, 200);
    }

    private ClassicHttpRequest header(ClassicHttpRequest request) {
        request.setHeader("Content-Type", (Object)CONTENT_TYPE_JSON);
        return request;
    }

    private <T> T post(String path, Object request, Class<T> responseType) throws IOException {
        return this.post(path, request, (JavaType)SimpleType.constructUnsafe(responseType));
    }

    private <T> T post(String path, Object request, JavaType responseType) throws IOException {
        HttpPost post = new HttpPost(this.uri(path));
        String json = this.objectMapper.writeValueAsString(request);
        log.debug("POST {}", (Object)json);
        post.setEntity((HttpEntity)new StringEntity(json));
        return this.read(this.header((ClassicHttpRequest)post), responseType, 200);
    }

    private <T> T read(ClassicHttpRequest request, JavaType type, int successCode) throws IOException {
        String json;
        HttpHost target = new HttpHost(this.protocol, this.host, this.port);
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credentials != null) {
            BasicScheme basicAuth = new BasicScheme();
            basicAuth.initPreemptive((Credentials)this.credentials);
            localContext.resetAuthExchange(target, (AuthScheme)basicAuth);
        }
        CloseableHttpResponse response = this.client.execute(request, (HttpContext)localContext);
        try {
            json = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new HttpResponseParsingException("Could not parse response", e);
        }
        if (response.getCode() == successCode) {
            return (T)this.objectMapper.readValue(json, type);
        }
        throw new HttpResponseException(response.getCode(), response.getReasonPhrase() + " " + json);
    }

    public List<InstalledModule> getModules() throws IOException {
        return (List)this.get(Admin.v1(MODULES), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, InstalledModule.class));
    }

    public Database createDatabase(Database database) throws IOException {
        HashMap<String, InstalledModule> installedModules = new HashMap<String, InstalledModule>();
        for (InstalledModule module : this.getModules()) {
            installedModules.put(module.getName(), module);
        }
        for (Database.ModuleConfig moduleConfig : database.getModules()) {
            if (!installedModules.containsKey(moduleConfig.getName())) {
                throw new IllegalArgumentException(String.format("Module %s not installed", moduleConfig.getName()));
            }
            moduleConfig.setId(((InstalledModule)installedModules.get(moduleConfig.getName())).getId());
        }
        Database response = this.post(Admin.v1(BDBS), (Object)database, Database.class);
        long uid = response.getUid();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).ignoreExceptions().until(() -> this.executeCommand(uid, new Command("PING")).getResponse().asBoolean());
        return response;
    }

    public List<Database> getDatabases() throws IOException {
        return (List)this.get(Admin.v1(BDBS), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Database.class));
    }

    public void deleteDatabase(long uid) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).until(() -> {
            try {
                this.delete(Admin.v1(BDBS, String.valueOf(uid)), Database.class);
                return true;
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 409) {
                    log.info("Could not delete database {}, retrying...", (Object)uid);
                    return false;
                }
                throw e;
            }
        });
    }

    public ModuleInstallResponse installModule(String filename, InputStream inputStream) throws IOException {
        HttpPost post = new HttpPost(this.uri(Admin.v2(MODULES)));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.STRICT);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
        builder.addPart("module", (ContentBody)new ByteArrayBody(baos.toByteArray(), ContentType.MULTIPART_FORM_DATA, filename));
        post.setEntity(builder.build());
        ModuleInstallResponse response = (ModuleInstallResponse)this.read((ClassicHttpRequest)post, (JavaType)SimpleType.constructUnsafe(ModuleInstallResponse.class), 202);
        baos.close();
        Awaitility.await().timeout(Duration.ofMinutes(1L)).pollInterval(Duration.ofSeconds(1L)).ignoreExceptions().until(() -> "completed".equals(this.getAction(response.getActionUid()).getStatus()));
        return response;
    }

    public void waitForBoostrap() {
        Awaitility.await().timeout(Duration.ofMinutes(1L)).pollInterval(Duration.ofSeconds(1L)).ignoreExceptions().until(() -> "idle".equals(this.getBootstrap().getStatus().getState()));
    }

    private Bootstrap getBootstrap() throws IOException {
        return this.get(Admin.v1(BOOTSTRAP), Bootstrap.class);
    }

    private Action getAction(String uid) throws IOException {
        return this.get(Admin.v1(ACTIONS, uid), Action.class);
    }

    public CommandResponse executeCommand(long bdb, Command command) throws IOException {
        return this.post(Admin.v1(BDBS, String.valueOf(bdb), COMMAND), (Object)command, CommandResponse.class);
    }

    private static class HttpResponseParsingException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public HttpResponseParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

