/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch;

import com.redis.spring.batch.common.DataStructure;
import com.redis.spring.batch.common.KeyDump;
import com.redis.spring.batch.writer.DataStructureOperation;
import com.redis.spring.batch.writer.Operation;
import com.redis.spring.batch.writer.PipelinedOperation;
import com.redis.spring.batch.writer.SimplePipelinedOperation;
import com.redis.spring.batch.writer.WriterBuilder;
import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.api.StatefulConnection;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.batch.item.support.AbstractItemStreamItemWriter;
import org.springframework.core.convert.converter.Converter;

public class RedisItemWriter<K, V, T>
extends AbstractItemStreamItemWriter<T> {
    private final GenericObjectPool<StatefulConnection<K, V>> pool;
    private final PipelinedOperation<K, V, T> operation;

    public RedisItemWriter(GenericObjectPool<StatefulConnection<K, V>> pool, PipelinedOperation<K, V, T> operation) {
        this.pool = pool;
        this.operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<? extends T> items) throws Exception {
        try (StatefulConnection connection = (StatefulConnection)this.pool.borrowObject();){
            connection.setAutoFlushCommands(false);
            try {
                Collection<RedisFuture<?>> futures = this.operation.execute(connection, items);
                connection.flushCommands();
                long timeout = connection.getTimeout().toMillis();
                LettuceFutures.awaitAll((long)timeout, (TimeUnit)TimeUnit.MILLISECONDS, (Future[])((Future[])futures.toArray(Future[]::new)));
            }
            finally {
                connection.setAutoFlushCommands(true);
            }
        }
    }

    public static <K, V, T> WriterBuilder<K, V, T> operation(GenericObjectPool<StatefulConnection<K, V>> connectionPool, Operation<K, V, T> operation) {
        return new WriterBuilder<K, V, T>(connectionPool, operation);
    }

    public static <K, V> WriterBuilder<K, V, DataStructure<K>> dataStructure(GenericObjectPool<StatefulConnection<K, V>> pool) {
        return new WriterBuilder(pool, new DataStructureOperation());
    }

    public static <K, V> WriterBuilder<K, V, DataStructure<K>> dataStructure(GenericObjectPool<StatefulConnection<K, V>> pool, Converter<StreamMessage<K, V>, XAddArgs> xaddArgs) {
        return new WriterBuilder(pool, new DataStructureOperation<K, V>(xaddArgs));
    }

    public static <K, V> WriterBuilder<K, V, KeyDump<K>> keyDump(GenericObjectPool<StatefulConnection<K, V>> pool) {
        return new WriterBuilder(pool, SimplePipelinedOperation.keyDump());
    }
}

