/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public final class ConnectionPoolBuilder {
    public static final boolean DEFAULT_LIFO = true;
    public static final boolean DEFAULT_FAIRNESS = false;
    public static final Duration DEFAULT_MAX_WAIT = BaseObjectPoolConfig.DEFAULT_MAX_WAIT;
    public static final Duration DEFAULT_MIN_EVICTABLE_IDLE_DURATION = BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION;
    public static final Duration DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT = BaseObjectPoolConfig.DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT;
    public static final Duration DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION = BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final String DEFAULT_EVICTION_POLICY_CLASS_NAME = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    public static final boolean DEFAULT_TEST_ON_CREATE = false;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final Duration DEFAULT_TIME_BETWEEN_EVICTION_RUNS = BaseObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS;
    public static final boolean DEFAULT_BLOCK_WHEN_EXHAUSTED = true;
    public static final boolean DEFAULT_JMX_ENABLE = true;
    public static final String DEFAULT_JMX_NAME_PREFIX = "pool";
    public static final String DEFAULT_JMX_NAME_BASE = BaseObjectPoolConfig.DEFAULT_JMX_NAME_BASE;
    public static final int DEFAULT_MAX_TOTAL = 8;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    Optional<ReadFrom> readFrom = Optional.empty();
    boolean lifo = true;
    boolean fairness = false;
    Duration maxWaitDuration = DEFAULT_MAX_WAIT;
    Duration minEvictableIdleDuration = DEFAULT_MIN_EVICTABLE_IDLE_DURATION;
    Duration evictorShutdownTimeoutDuration = DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT;
    Duration softMinEvictableIdleDuration = DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION;
    int numTestsPerEvictionRun = 3;
    Optional<EvictionPolicy<?>> evictionPolicy = Optional.empty();
    String evictionPolicyClassName = DEFAULT_EVICTION_POLICY_CLASS_NAME;
    boolean testOnCreate = false;
    boolean testOnBorrow = false;
    boolean testOnReturn = false;
    boolean testWhileIdle = false;
    Duration durationBetweenEvictionRuns = DEFAULT_TIME_BETWEEN_EVICTION_RUNS;
    boolean blockWhenExhausted = true;
    boolean jmxEnabled = true;
    String jmxNamePrefix = "pool";
    String jmxNameBase = DEFAULT_JMX_NAME_BASE;
    int maxTotal = 8;
    int maxIdle = 8;
    int minIdle = 0;
    private final AbstractRedisClient client;

    public ConnectionPoolBuilder(AbstractRedisClient client) {
        this.client = client;
    }

    public ConnectionPoolBuilder readFrom(ReadFrom readFrom) {
        return this.readFrom(Optional.of(readFrom));
    }

    public ConnectionPoolBuilder readFrom(Optional<ReadFrom> readFrom) {
        this.readFrom = readFrom;
        return this;
    }

    public ConnectionPoolBuilder lifo(boolean lifo) {
        this.lifo = lifo;
        return this;
    }

    public ConnectionPoolBuilder fairness(boolean fairness) {
        this.fairness = fairness;
        return this;
    }

    public ConnectionPoolBuilder maxWaitDuration(Duration maxWaitDuration) {
        this.maxWaitDuration = maxWaitDuration;
        return this;
    }

    public ConnectionPoolBuilder minEvictableIdleDuration(Duration minEvictableIdleDuration) {
        this.minEvictableIdleDuration = minEvictableIdleDuration;
        return this;
    }

    public ConnectionPoolBuilder evictorShutdownTimeoutDuration(Duration evictorShutdownTimeoutDuration) {
        this.evictorShutdownTimeoutDuration = evictorShutdownTimeoutDuration;
        return this;
    }

    public ConnectionPoolBuilder softMinEvictableIdleDuration(Duration softMinEvictableIdleDuration) {
        this.softMinEvictableIdleDuration = softMinEvictableIdleDuration;
        return this;
    }

    public ConnectionPoolBuilder numTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        return this;
    }

    public ConnectionPoolBuilder evictionPolicy(EvictionPolicy<?> evictionPolicy) {
        return this.evictionPolicy(Optional.of(evictionPolicy));
    }

    public ConnectionPoolBuilder evictionPolicy(Optional<EvictionPolicy<?>> evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public ConnectionPoolBuilder evictionPolicyClassName(String evictionPolicyClassName) {
        this.evictionPolicyClassName = evictionPolicyClassName;
        return this;
    }

    public ConnectionPoolBuilder testOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
        return this;
    }

    public ConnectionPoolBuilder testOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public ConnectionPoolBuilder testOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public ConnectionPoolBuilder testWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public ConnectionPoolBuilder durationBetweenEvictionRuns(Duration durationBetweenEvictionRuns) {
        this.durationBetweenEvictionRuns = durationBetweenEvictionRuns;
        return this;
    }

    public ConnectionPoolBuilder blockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
        return this;
    }

    public ConnectionPoolBuilder jmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        return this;
    }

    public ConnectionPoolBuilder jmxNamePrefix(String jmxNamePrefix) {
        this.jmxNamePrefix = jmxNamePrefix;
        return this;
    }

    public ConnectionPoolBuilder jmxNameBase(String jmxNameBase) {
        this.jmxNameBase = jmxNameBase;
        return this;
    }

    public ConnectionPoolBuilder maxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public ConnectionPoolBuilder maxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public ConnectionPoolBuilder minIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public <K, V> GenericObjectPoolConfig<StatefulConnection<K, V>> config() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setBlockWhenExhausted(this.blockWhenExhausted);
        this.evictionPolicy.ifPresent(p -> config.setEvictionPolicy(p));
        config.setEvictionPolicyClassName(this.evictionPolicyClassName);
        config.setEvictorShutdownTimeout(this.evictorShutdownTimeoutDuration);
        config.setFairness(this.fairness);
        config.setJmxEnabled(this.jmxEnabled);
        config.setJmxNameBase(this.jmxNameBase);
        config.setJmxNamePrefix(this.jmxNamePrefix);
        config.setLifo(this.lifo);
        config.setMaxIdle(this.maxIdle);
        config.setMaxTotal(this.maxTotal);
        config.setMaxWait(this.maxWaitDuration);
        config.setMinEvictableIdleTime(this.minEvictableIdleDuration);
        config.setMinIdle(this.minIdle);
        config.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        config.setSoftMinEvictableIdleTime(this.softMinEvictableIdleDuration);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestOnCreate(this.testOnCreate);
        config.setTestOnReturn(this.testOnReturn);
        config.setTestWhileIdle(this.testWhileIdle);
        config.setTimeBetweenEvictionRuns(this.durationBetweenEvictionRuns);
        return config;
    }

    public GenericObjectPool<StatefulConnection<String, String>> build() {
        return this.build((RedisCodec)StringCodec.UTF8);
    }

    public <K, V> GenericObjectPool<StatefulConnection<K, V>> build(RedisCodec<K, V> codec) {
        return ConnectionPoolSupport.createGenericObjectPool(this.connectionSupplier(this.client, codec), this.config());
    }

    public <K, V> Supplier<StatefulConnection<K, V>> connectionSupplier(AbstractRedisClient client, RedisCodec<K, V> codec) {
        if (client instanceof RedisClusterClient) {
            return () -> {
                StatefulRedisClusterConnection connection = ((RedisClusterClient)client).connect(codec);
                this.readFrom.ifPresent(arg_0 -> ((StatefulRedisClusterConnection)connection).setReadFrom(arg_0));
                return connection;
            };
        }
        return () -> ((RedisClient)client).connect(codec);
    }

    public static ConnectionPoolBuilder create(AbstractRedisClient client) {
        return new ConnectionPoolBuilder(client);
    }
}

