/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import com.redis.lettucemod.timeseries.Sample;
import com.redis.spring.batch.common.KeyTtlValue;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.StreamMessage;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataStructure<K>
extends KeyTtlValue<K> {
    private Type type;
    private Object value;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "DataStructure [type=" + (Object)((Object)this.type) + ", key=" + this.getKey() + ", value=" + this.value + ", ttl=" + this.getTtl() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.type, this.value});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataStructure other = (DataStructure)obj;
        return this.type == other.type && Objects.equals(this.value, other.value);
    }

    public static <K> DataStructure<K> of(K key, Type type, Object value) {
        DataStructure<K> dataStructure = new DataStructure<K>();
        dataStructure.setKey(key);
        dataStructure.setType(type);
        dataStructure.setValue(value);
        return dataStructure;
    }

    public static <K, V> DataStructure<K> hash(K key, Map<K, V> value) {
        return DataStructure.of(key, Type.HASH, value);
    }

    public static <K, V> DataStructure<K> string(K key, V value) {
        return DataStructure.of(key, Type.STRING, value);
    }

    public static <K, V> DataStructure<K> set(K key, Collection<V> value) {
        return DataStructure.of(key, Type.SET, value);
    }

    public static <K, V> DataStructure<K> zset(K key, Collection<ScoredValue<V>> value) {
        return DataStructure.of(key, Type.ZSET, value);
    }

    public static <K, V> DataStructure<K> list(K key, Collection<V> value) {
        return DataStructure.of(key, Type.LIST, value);
    }

    public static <K, V> DataStructure<K> stream(K key, Collection<StreamMessage<K, V>> value) {
        return DataStructure.of(key, Type.STREAM, value);
    }

    public static <K, V> DataStructure<K> json(K key, V value) {
        return DataStructure.of(key, Type.JSON, value);
    }

    public static <K> DataStructure<K> timeSeries(K key, Collection<Sample> value) {
        return DataStructure.of(key, Type.TIMESERIES, value);
    }

    public void setTypeString(String string) {
        this.setType(Type.of(string));
    }

    public static enum Type {
        NONE,
        UNKNOWN,
        SET,
        LIST,
        ZSET,
        STREAM,
        STRING,
        HASH,
        JSON("ReJSON-RL"),
        TIMESERIES("TSDB-TYPE");

        private static final Map<String, Type> TYPES;
        private String string;

        private Type() {
            this.string = this.name();
        }

        private Type(String string2) {
            this.string = string2;
        }

        public String getString() {
            return this.string;
        }

        public static Type of(String string) {
            if (string == null) {
                throw new NullPointerException("Name is null");
            }
            return TYPES.getOrDefault(string.toLowerCase(), UNKNOWN);
        }

        static {
            TYPES = Stream.of(Type.values()).collect(Collectors.toMap(t -> t.string.toLowerCase(), t -> t));
        }
    }
}

